/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hive.hcatalog.api.HCatTable;
import org.apache.hive.hcatalog.common.HCatException;
import org.apache.hive.hcatalog.data.schema.HCatFieldSchema;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class HCatCreateTableDesc {
    private boolean ifNotExists;
    private HCatTable hcatTable;

    private HCatCreateTableDesc(HCatTable hcatTable, boolean ifNotExists) {
        this.hcatTable = hcatTable;
        this.ifNotExists = ifNotExists;
    }

    @Deprecated
    public static Builder create(String dbName, String tableName, List<HCatFieldSchema> columns) {
        return new Builder(dbName, tableName, columns);
    }

    public static Builder create(HCatTable table, boolean ifNotExists) {
        return new Builder(table, ifNotExists);
    }

    public static Builder create(HCatTable table) {
        return new Builder(table, false);
    }

    public HCatTable getHCatTable() {
        return this.hcatTable;
    }

    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    @Deprecated
    public String getTableName() {
        return this.hcatTable.getTableName();
    }

    @Deprecated
    public List<HCatFieldSchema> getCols() {
        return this.hcatTable.getCols();
    }

    @Deprecated
    public List<HCatFieldSchema> getPartitionCols() {
        return this.hcatTable.getPartCols();
    }

    @Deprecated
    public List<String> getBucketCols() {
        return this.hcatTable.getBucketCols();
    }

    @Deprecated
    public int getNumBuckets() {
        return this.hcatTable.getNumBuckets();
    }

    @Deprecated
    public String getComments() {
        return this.hcatTable.comment();
    }

    @Deprecated
    public String getStorageHandler() {
        return this.hcatTable.getStorageHandler();
    }

    @Deprecated
    public String getLocation() {
        return this.hcatTable.getLocation();
    }

    @Deprecated
    public boolean getExternal() {
        return this.hcatTable.getTabletype().equalsIgnoreCase(HCatTable.Type.EXTERNAL_TABLE.toString());
    }

    @Deprecated
    public List<Order> getSortCols() {
        return this.hcatTable.getSortCols();
    }

    @Deprecated
    public Map<String, String> getTblProps() {
        return this.hcatTable.getTblProps();
    }

    @Deprecated
    public String getFileFormat() {
        return this.hcatTable.fileFormat();
    }

    @Deprecated
    public String getDatabaseName() {
        return this.hcatTable.getDbName();
    }

    @Deprecated
    public Map<String, String> getSerdeParams() {
        return this.hcatTable.getSerdeParams();
    }

    public String toString() {
        return "HCatCreateTableDesc [ " + this.hcatTable.toString() + ", ifNotExists = " + this.ifNotExists + "]";
    }

    public static class Builder {
        private boolean ifNotExists;
        private HCatTable hcatTable;

        @Deprecated
        private Builder(String dbName, String tableName, List<HCatFieldSchema> columns) {
            this.hcatTable = new HCatTable(dbName, tableName).cols(columns);
        }

        private Builder(HCatTable hcatTable, boolean ifNotExists) {
            this.hcatTable = hcatTable;
            this.ifNotExists = ifNotExists;
        }

        public Builder ifNotExists(boolean ifNotExists) {
            this.ifNotExists = ifNotExists;
            return this;
        }

        @Deprecated
        public Builder partCols(List<HCatFieldSchema> partCols) {
            this.hcatTable.partCols(partCols);
            return this;
        }

        @Deprecated
        public Builder bucketCols(List<String> bucketCols, int buckets) {
            this.hcatTable.bucketCols(bucketCols).numBuckets(buckets);
            return this;
        }

        @Deprecated
        public Builder storageHandler(String storageHandler) throws HCatException {
            this.hcatTable.storageHandler(storageHandler);
            return this;
        }

        @Deprecated
        public Builder location(String location) {
            this.hcatTable.location(location);
            return this;
        }

        @Deprecated
        public Builder comments(String comment) {
            this.hcatTable.comment(comment);
            return this;
        }

        @Deprecated
        public Builder isTableExternal(boolean isExternal) {
            this.hcatTable.tableType(isExternal ? HCatTable.Type.EXTERNAL_TABLE : HCatTable.Type.MANAGED_TABLE);
            return this;
        }

        @Deprecated
        public Builder sortCols(ArrayList<Order> sortCols) {
            this.hcatTable.sortCols(sortCols);
            return this;
        }

        @Deprecated
        public Builder tblProps(Map<String, String> tblProps) {
            this.hcatTable.tblProps(tblProps);
            return this;
        }

        @Deprecated
        public Builder fileFormat(String format) {
            this.hcatTable.fileFormat(format);
            return this;
        }

        @Deprecated
        public Builder fieldsTerminatedBy(char delimiter) {
            return this.serdeParam("field.delim", Character.toString(delimiter));
        }

        @Deprecated
        public Builder escapeChar(char escapeChar) {
            return this.serdeParam("escape.delim", Character.toString(escapeChar));
        }

        @Deprecated
        public Builder collectionItemsTerminatedBy(char delimiter) {
            return this.serdeParam("collection.delim", Character.toString(delimiter));
        }

        @Deprecated
        public Builder mapKeysTerminatedBy(char delimiter) {
            return this.serdeParam("mapkey.delim", Character.toString(delimiter));
        }

        @Deprecated
        public Builder linesTerminatedBy(char delimiter) {
            return this.serdeParam("line.delim", Character.toString(delimiter));
        }

        @Deprecated
        public Builder nullDefinedAs(char nullChar) {
            return this.serdeParam("serialization.null.format", Character.toString(nullChar));
        }

        @Deprecated
        public Builder serdeParam(String paramName, String value) {
            this.hcatTable.serdeParam(paramName, value);
            return this;
        }

        public HCatCreateTableDesc build() throws HCatException {
            return new HCatCreateTableDesc(this.hcatTable, this.ifNotExists);
        }
    }
}

