/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.compaction.evaluator.amoro;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Map;
import org.apache.iceberg.mr.hive.compaction.evaluator.amoro.CompatiblePropertyUtil;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OptimizingConfig {
    private boolean enabled;
    private long targetSize;
    private long openFileCost;
    private int fragmentRatio;
    private double minTargetSizeRatio;
    private int minorLeastFileCount;
    private int minorLeastInterval;
    private double majorDuplicateRatio;
    private int fullTriggerInterval;
    private boolean fullRewriteAllFiles;

    public boolean isEnabled() {
        return this.enabled;
    }

    public OptimizingConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public long getTargetSize() {
        return this.targetSize;
    }

    public OptimizingConfig setTargetSize(long targetSize) {
        this.targetSize = targetSize;
        return this;
    }

    public long getOpenFileCost() {
        return this.openFileCost;
    }

    public OptimizingConfig setOpenFileCost(long openFileCost) {
        this.openFileCost = openFileCost;
        return this;
    }

    public int getFragmentRatio() {
        return this.fragmentRatio;
    }

    public OptimizingConfig setFragmentRatio(int fragmentRatio) {
        this.fragmentRatio = fragmentRatio;
        return this;
    }

    public double getMinTargetSizeRatio() {
        return this.minTargetSizeRatio;
    }

    public OptimizingConfig setMinTargetSizeRatio(double minTargetSizeRatio) {
        this.minTargetSizeRatio = minTargetSizeRatio;
        return this;
    }

    public int getMinorLeastFileCount() {
        return this.minorLeastFileCount;
    }

    public OptimizingConfig setMinorLeastFileCount(int minorLeastFileCount) {
        this.minorLeastFileCount = minorLeastFileCount;
        return this;
    }

    public int getMinorLeastInterval() {
        return this.minorLeastInterval;
    }

    public OptimizingConfig setMinorLeastInterval(int minorLeastInterval) {
        this.minorLeastInterval = minorLeastInterval;
        return this;
    }

    public double getMajorDuplicateRatio() {
        return this.majorDuplicateRatio;
    }

    public OptimizingConfig setMajorDuplicateRatio(double majorDuplicateRatio) {
        this.majorDuplicateRatio = majorDuplicateRatio;
        return this;
    }

    public int getFullTriggerInterval() {
        return this.fullTriggerInterval;
    }

    public OptimizingConfig setFullTriggerInterval(int fullTriggerInterval) {
        this.fullTriggerInterval = fullTriggerInterval;
        return this;
    }

    public boolean isFullRewriteAllFiles() {
        return this.fullRewriteAllFiles;
    }

    public OptimizingConfig setFullRewriteAllFiles(boolean fullRewriteAllFiles) {
        this.fullRewriteAllFiles = fullRewriteAllFiles;
        return this;
    }

    public static OptimizingConfig parse(Map<String, String> properties) {
        return new OptimizingConfig().setEnabled(CompatiblePropertyUtil.propertyAsBoolean(properties, "self-optimizing.enabled", true)).setFragmentRatio(CompatiblePropertyUtil.propertyAsInt(properties, "self-optimizing.fragment-ratio", 8)).setMinTargetSizeRatio(CompatiblePropertyUtil.propertyAsDouble(properties, "self-optimizing.min-target-size-ratio", 0.75)).setOpenFileCost(CompatiblePropertyUtil.propertyAsLong(properties, "read.split.open-file-cost", 0x400000L)).setTargetSize(CompatiblePropertyUtil.propertyAsLong(properties, "self-optimizing.target-size", 0x8000000L)).setMinorLeastFileCount(CompatiblePropertyUtil.propertyAsInt(properties, "self-optimizing.minor.trigger.file-count", 12)).setMinorLeastInterval(CompatiblePropertyUtil.propertyAsInt(properties, "self-optimizing.minor.trigger.interval", 3600000)).setMajorDuplicateRatio(CompatiblePropertyUtil.propertyAsDouble(properties, "self-optimizing.major.trigger.duplicate-ratio", 0.1)).setFullTriggerInterval(CompatiblePropertyUtil.propertyAsInt(properties, "self-optimizing.full.trigger.interval", -1)).setFullRewriteAllFiles(CompatiblePropertyUtil.propertyAsBoolean(properties, "self-optimizing.full.rewrite-all-files", true));
    }
}

