/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.util;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.Iterator;
import org.apache.hive.org.apache.commons.lang3.StringUtils;
import org.jsonschema2pojo.util.Models;

public class ParcelableHelper {
    public void addWriteToParcel(JDefinedClass jclass) {
        JMethod method = jclass.method(1, Void.TYPE, "writeToParcel");
        JVar dest = method.param(jclass.owner().directClass("android.os.Parcel"), "dest");
        method.param(Integer.TYPE, "flags");
        if (this.extendsParcelable(jclass)) {
            method.body().directStatement("super.writeToParcel(dest, flags);");
        }
        for (JFieldVar f : jclass.fields().values()) {
            if ((f.mods().getValue() & 0x10) == 16) continue;
            if (f.type().erasure().name().equals("List")) {
                method.body().invoke((JExpression)dest, "writeList").arg(f);
                continue;
            }
            method.body().invoke((JExpression)dest, "writeValue").arg(f);
        }
    }

    public void addDescribeContents(JDefinedClass jclass) {
        JMethod method = jclass.method(1, Integer.TYPE, "describeContents");
        method.body()._return(JExpr.lit(0));
    }

    public void addCreator(JDefinedClass jclass) {
        JClass creatorType = jclass.owner().directClass("android.os.Parcelable.Creator").narrow((JClass)jclass);
        JDefinedClass creatorClass = jclass.owner().anonymousClass(creatorType);
        this.addCreateFromParcel(jclass, creatorClass);
        this.addNewArray(jclass, creatorClass);
        JFieldVar creatorField = jclass.field(25, creatorType, "CREATOR");
        creatorField.init(JExpr._new(creatorClass));
    }

    public void addConstructorFromParcel(JDefinedClass jclass) {
        JMethod ctorFromParcel = jclass.constructor(2);
        JVar in = ctorFromParcel.param(jclass.owner().directClass("android.os.Parcel"), "in");
        if (this.extendsParcelable(jclass)) {
            ctorFromParcel.body().directStatement("super(in);");
        }
        for (JFieldVar f : jclass.fields().values()) {
            if ((f.mods().getValue() & 0x10) == 16) continue;
            if (f.type().erasure().name().equals("List")) {
                ctorFromParcel.body().invoke((JExpression)in, "readList").arg(JExpr._this().ref(f)).arg(JExpr.direct(this.getListType(f.type()) + ".class.getClassLoader()"));
                continue;
            }
            ctorFromParcel.body().assign(JExpr._this().ref(f), JExpr.cast(f.type(), in.invoke("readValue").arg(JExpr.direct(f.type().erasure().name() + ".class.getClassLoader()"))));
        }
    }

    private void addNewArray(JDefinedClass jclass, JDefinedClass creatorClass) {
        JMethod newArray = creatorClass.method(1, jclass.array(), "newArray");
        newArray.param(Integer.TYPE, "size");
        newArray.body()._return(JExpr.direct("new " + jclass.name() + "[size]"));
    }

    private void addCreateFromParcel(JDefinedClass jclass, JDefinedClass creatorClass) {
        JMethod createFromParcel = creatorClass.method(1, jclass, "createFromParcel");
        JVar in = createFromParcel.param(jclass.owner().directClass("android.os.Parcel"), "in");
        Models.suppressWarnings(createFromParcel, "unchecked");
        createFromParcel.body()._return(JExpr._new(jclass).arg(in));
    }

    private boolean extendsParcelable(JDefinedClass jclass) {
        Iterator<JClass> interfaces;
        Iterator<JClass> iterator = interfaces = jclass._extends() != null ? jclass._extends()._implements() : null;
        if (interfaces != null) {
            while (interfaces.hasNext()) {
                JClass iface = interfaces.next();
                if (!iface.erasure().name().equals("Parcelable")) continue;
                return true;
            }
        }
        return false;
    }

    private String getListType(JType jType) {
        String typeName = jType.fullName();
        return StringUtils.substringBeforeLast(StringUtils.substringAfter(typeName, "<"), ">");
    }
}

