/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql.objects;

import java.util.List;
import org.apache.hive.hplsql.ArityException;
import org.apache.hive.hplsql.File;
import org.apache.hive.hplsql.Row;
import org.apache.hive.hplsql.TypeException;
import org.apache.hive.hplsql.Var;

public class MethodParams {
    private final List<Var> actual;

    public MethodParams(String methodName, List<Var> actual, Arity arity) {
        this.actual = actual;
        arity.check(methodName, actual);
    }

    public Long longAt(int nth) {
        return this.at(nth, Long.class);
    }

    public Row rowAt(int nth) {
        return this.at(nth, Row.class);
    }

    public String stringAt(int nth) {
        return this.at(nth, String.class);
    }

    public File fileAt(int nth) {
        return this.at(nth, File.class);
    }

    public <T> T at(int nth, Class<T> clazz) {
        try {
            return clazz.cast(this.actual.get((int)nth).value);
        }
        catch (ClassCastException e) {
            throw new TypeException(null, clazz, this.actual.get((int)nth).type, this.actual.get((int)nth).value);
        }
    }

    public static interface Arity {
        public static final Arity NULLARY = Arity.of(0);
        public static final Arity UNARY = Arity.of(1);
        public static final Arity BINARY = Arity.of(2);

        public void check(String var1, List<?> var2);

        public static Arity of(int count) {
            return (methodName, params) -> {
                if (params.size() != count) {
                    throw new ArityException(null, methodName, count, params.size());
                }
            };
        }

        public static Arity min(int count) {
            return (methodName, params) -> {
                if (params.size() < count) {
                    throw new ArityException(null, "wrong number of arguments in call to '" + methodName + "'. Expected at least " + count + " got " + params.size() + ".");
                }
            };
        }

        public static Arity max(int count) {
            return (methodName, params) -> {
                if (params.size() > count) {
                    throw new ArityException(null, "wrong number of arguments in call to '" + methodName + "'. Expected at most " + count + " got " + params.size() + ".");
                }
            };
        }
    }
}

