/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import org.apache.hive.hplsql.Exec;
import org.apache.hive.hplsql.Query;
import org.apache.hive.hplsql.Timer;

public class Conn {
    HashMap<String, Stack<Connection>> connections = new HashMap();
    HashMap<String, String> connStrings = new HashMap();
    HashMap<String, Type> connTypes = new HashMap();
    HashMap<String, ArrayList<String>> connInits = new HashMap();
    HashMap<String, ArrayList<String>> preSql = new HashMap();
    Exec exec;
    Timer timer = new Timer();
    boolean trace = false;
    boolean info = false;

    Conn(Exec e) {
        this.exec = e;
        this.trace = this.exec.getTrace();
        this.info = this.exec.getInfo();
    }

    public Query executeQuery(Query query, String connName) {
        try {
            Connection conn = this.getConnection(connName);
            this.runPreSql(connName, conn);
            Statement stmt = conn.createStatement();
            this.exec.info(null, "Starting query");
            this.timer.start();
            ResultSet rs = stmt.executeQuery(query.sql);
            this.timer.stop();
            query.set(conn, stmt, rs);
            if (this.info) {
                this.exec.info(null, "Query executed successfully (" + this.timer.format() + ")");
            }
        }
        catch (Exception e) {
            query.setError(e);
        }
        return query;
    }

    public Query prepareQuery(Query query, String connName) {
        try {
            Connection conn = this.getConnection(connName);
            this.timer.start();
            PreparedStatement stmt = conn.prepareStatement(query.sql);
            this.timer.stop();
            query.set(conn, stmt);
            if (this.info) {
                this.exec.info(null, "Prepared statement executed successfully (" + this.timer.format() + ")");
            }
        }
        catch (Exception e) {
            query.setError(e);
        }
        return query;
    }

    public void closeQuery(Query query, String connName) {
        query.closeStatement();
        this.returnConnection(connName, query.getConnection());
    }

    void runPreSql(String connName, Connection conn) throws SQLException {
        ArrayList<String> sqls = this.preSql.get(connName);
        if (sqls != null) {
            Statement s2 = conn.createStatement();
            for (String sql : sqls) {
                this.exec.info(null, "Starting pre-SQL statement");
                s2.execute(sql);
            }
            s2.close();
            this.preSql.remove(connName);
        }
    }

    synchronized Connection getConnection(String connName) throws Exception {
        Stack<Connection> connStack = this.connections.get(connName);
        String connStr = this.connStrings.get(connName);
        if (connStr == null) {
            throw new Exception("Unknown connection profile: " + connName);
        }
        if (connStack != null && !connStack.empty()) {
            return connStack.pop();
        }
        Connection c = this.openConnection(connStr);
        ArrayList<String> sqls = this.connInits.get(connName);
        if (sqls != null) {
            Statement s2 = c.createStatement();
            for (String sql : sqls) {
                s2.execute(sql);
            }
            s2.close();
        }
        return c;
    }

    Connection openConnection(String connStr) throws Exception {
        String driver = "org.apache.hadoop.hive.jdbc.HiveDriver";
        StringBuilder url = new StringBuilder();
        String usr = "";
        String pwd = "";
        if (connStr != null) {
            String[] c = connStr.split(";");
            if (c.length >= 1) {
                driver = c[0];
            }
            if (c.length >= 2) {
                url.append(c[1]);
            } else {
                url.append("jdbc:hive://");
            }
            for (int i = 2; i < c.length; ++i) {
                if (c[i].contains("=")) {
                    url.append(";");
                    url.append(c[i]);
                    continue;
                }
                if (usr.isEmpty()) {
                    usr = c[i];
                    continue;
                }
                if (!pwd.isEmpty()) continue;
                pwd = c[i];
            }
        }
        Class.forName(driver);
        this.timer.start();
        Connection conn = DriverManager.getConnection(url.toString().trim(), usr, pwd);
        this.timer.stop();
        if (this.info) {
            this.exec.info(null, "Open connection: " + String.valueOf(url) + " (" + this.timer.format() + ")");
        }
        return conn;
    }

    Type getTypeByProfile(String name) {
        return this.connTypes.get(name);
    }

    Type getType(String connStr) {
        if (connStr.contains("hive.")) {
            return Type.HIVE;
        }
        if (connStr.contains("db2.")) {
            return Type.DB2;
        }
        if (connStr.contains("mysql.")) {
            return Type.MYSQL;
        }
        if (connStr.contains("teradata.")) {
            return Type.TERADATA;
        }
        return Type.HIVE;
    }

    void returnConnection(String name, Connection conn) {
        if (conn != null) {
            this.connections.get(name).push(conn);
        }
    }

    public void addConnection(String name, String connStr) {
        this.connections.put(name, new Stack());
        this.connStrings.put(name, connStr);
        this.connTypes.put(name, this.getType(connStr));
    }

    public void addConnectionInit(String name, String connInit) {
        String[] sa;
        ArrayList<String> a = new ArrayList<String>();
        for (String s2 : sa = connInit.split(";")) {
            if ((s2 = s2.trim()).isEmpty()) continue;
            a.add(s2);
        }
        this.connInits.put(name, a);
    }

    public void addPreSql(String name, ArrayList<String> sql) {
        this.preSql.put(name, sql);
    }

    public static enum Type {
        DB2,
        HIVE,
        MYSQL,
        TERADATA;

    }
}

