/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import java.text.DecimalFormat;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MutableMetric;
import org.apache.hadoop.metrics2.util.Quantile;
import org.apache.hadoop.metrics2.util.QuantileEstimator;
import org.apache.hadoop.metrics2.util.SampleQuantiles;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hive.org.apache.commons.lang3.StringUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class MutableQuantiles
extends MutableMetric {
    @VisibleForTesting
    public static final Quantile[] QUANTILES = new Quantile[]{new Quantile(0.5, 0.05), new Quantile(0.75, 0.025), new Quantile(0.9, 0.01), new Quantile(0.95, 0.005), new Quantile(0.99, 0.001)};
    private MetricsInfo numInfo;
    private MetricsInfo[] quantileInfos;
    private int intervalSecs;
    private static DecimalFormat decimalFormat = new DecimalFormat("###.####");
    private QuantileEstimator estimator;
    private long previousCount = 0L;
    private ScheduledFuture<?> scheduledTask = null;
    @VisibleForTesting
    protected Map<Quantile, Long> previousSnapshot = null;
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("MutableQuantiles-%d").build());

    public MutableQuantiles(String name, String description, String sampleName, String valueName, int interval) {
        String ucName = StringUtils.capitalize(name);
        String usName = StringUtils.capitalize(sampleName);
        String uvName = StringUtils.capitalize(valueName);
        String desc = StringUtils.uncapitalize(description);
        String lsName = StringUtils.uncapitalize(sampleName);
        String lvName = StringUtils.uncapitalize(valueName);
        this.setInterval(interval);
        this.setNumInfo(Interns.info(ucName + "Num" + usName, String.format("Number of %s for %s with %ds interval", lsName, desc, interval)));
        this.scheduledTask = scheduler.scheduleWithFixedDelay(new RolloverSample(this), interval, interval, TimeUnit.SECONDS);
        Quantile[] quantilesArray = this.getQuantiles();
        this.setQuantileInfos(quantilesArray.length);
        this.setQuantiles(ucName, uvName, desc, lvName, decimalFormat);
        this.setEstimator(new SampleQuantiles(quantilesArray));
    }

    void setQuantiles(String ucName, String uvName, String desc, String lvName, DecimalFormat pDecimalFormat) {
        for (int i = 0; i < QUANTILES.length; ++i) {
            double percentile = 100.0 * MutableQuantiles.QUANTILES[i].quantile;
            String nameTemplate = ucName + pDecimalFormat.format(percentile) + "thPercentile" + uvName;
            String descTemplate = pDecimalFormat.format(percentile) + " percentile " + lvName + " with " + this.getInterval() + " second interval for " + desc;
            this.addQuantileInfo(i, Interns.info(nameTemplate, descTemplate));
        }
    }

    public MutableQuantiles() {
    }

    @Override
    public synchronized void snapshot(MetricsRecordBuilder builder, boolean all) {
        Quantile[] quantilesArray = this.getQuantiles();
        if (all || this.changed()) {
            builder.addGauge(this.numInfo, this.previousCount);
            for (int i = 0; i < quantilesArray.length; ++i) {
                long newValue = 0L;
                if (this.previousSnapshot != null) {
                    newValue = this.previousSnapshot.get(quantilesArray[i]);
                }
                builder.addGauge(this.quantileInfos[i], newValue);
            }
            if (this.changed()) {
                this.clearChanged();
            }
        }
    }

    public synchronized void add(long value) {
        this.estimator.insert(value);
    }

    public synchronized Quantile[] getQuantiles() {
        return QUANTILES;
    }

    public synchronized void setNumInfo(MetricsInfo pNumInfo) {
        this.numInfo = pNumInfo;
    }

    public synchronized void setQuantileInfos(int length) {
        this.quantileInfos = new MetricsInfo[length];
    }

    public synchronized void addQuantileInfo(int i, MetricsInfo info) {
        this.quantileInfos[i] = info;
    }

    public synchronized void setInterval(int pIntervalSecs) {
        this.intervalSecs = pIntervalSecs;
    }

    public synchronized int getInterval() {
        return this.intervalSecs;
    }

    public void stop() {
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel(false);
        }
        this.scheduledTask = null;
    }

    @VisibleForTesting
    public synchronized QuantileEstimator getEstimator() {
        return this.estimator;
    }

    public synchronized void setEstimator(QuantileEstimator quantileEstimator) {
        this.estimator = quantileEstimator;
    }

    private static class RolloverSample
    implements Runnable {
        MutableQuantiles parent;

        public RolloverSample(MutableQuantiles parent) {
            this.parent = parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MutableQuantiles mutableQuantiles = this.parent;
            synchronized (mutableQuantiles) {
                this.parent.previousCount = this.parent.estimator.getCount();
                this.parent.previousSnapshot = this.parent.estimator.snapshot();
                this.parent.estimator.clear();
            }
            this.parent.setChanged();
        }
    }
}

