/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.conf;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.hadoop.hive.metastore.conf.Validator;

public class StringSetValidator
implements Validator {
    private final boolean caseSensitive;
    private final Set<String> expected = new LinkedHashSet<String>();

    public StringSetValidator(String ... values) {
        this(false, values);
    }

    public StringSetValidator(boolean caseSensitive, String ... values) {
        this.caseSensitive = caseSensitive;
        for (String value : values) {
            this.expected.add(caseSensitive ? value : value.toLowerCase());
        }
    }

    public Set<String> getExpected() {
        return new HashSet<String>(this.expected);
    }

    @Override
    public void validate(String value) {
        if (value == null || !this.expected.contains(this.caseSensitive ? value : value.toLowerCase())) {
            throw new IllegalArgumentException("Invalid value.. expects one of " + String.valueOf(this.expected));
        }
    }
}

