/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.io;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.function.UnaryOperator;
import org.apache.hadoop.hive.common.io.FetchCallback;
import org.apache.hadoop.hive.common.io.SessionStream;

public class QTestFetchConverter
extends SessionStream
implements FetchCallback {
    private final UnaryOperator<String> transformation;
    private final PrintStream inner;
    private final boolean hasFetchCallback;

    public QTestFetchConverter(OutputStream out, boolean autoFlush, String encoding, UnaryOperator<String> transformation) throws UnsupportedEncodingException {
        super(out, autoFlush, encoding);
        PrintStream ps;
        this.inner = out instanceof PrintStream ? (ps = (PrintStream)out) : new PrintStream(out);
        this.hasFetchCallback = out instanceof FetchCallback;
        this.transformation = transformation;
    }

    @Override
    public void println(String str) {
        this.inner.println((String)this.transformation.apply(str));
    }

    @Override
    public void foundQuery(boolean queryfound) {
        if (this.hasFetchCallback) {
            ((FetchCallback)((Object)this.inner)).foundQuery(queryfound);
        }
    }

    @Override
    public void fetchStarted() {
        if (this.hasFetchCallback) {
            ((FetchCallback)((Object)this.inner)).fetchStarted();
        }
    }

    @Override
    public void fetchFinished() {
        if (this.hasFetchCallback) {
            ((FetchCallback)((Object)this.inner)).fetchFinished();
        }
        this.flush();
    }
}

