/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.rfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.util.MutableByteSequence;
import org.apache.accumulo.core.util.UnsynchronizedBuffer;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

public class RelativeKey
implements Writable {
    private static final byte BIT = 1;
    private Key key;
    private Key prevKey;
    private byte fieldsSame;
    private byte fieldsPrefixed;
    private static final byte ROW_SAME = 1;
    private static final byte CF_SAME = 2;
    private static final byte CQ_SAME = 4;
    private static final byte CV_SAME = 8;
    private static final byte TS_SAME = 16;
    private static final byte DELETED = 32;
    private static final byte PREFIX_COMPRESSION_ENABLED = -128;
    private static final byte ROW_COMMON_PREFIX = 1;
    private static final byte CF_COMMON_PREFIX = 2;
    private static final byte CQ_COMMON_PREFIX = 4;
    private static final byte CV_COMMON_PREFIX = 8;
    private static final byte TS_DIFF = 16;
    int rowCommonPrefixLen;
    int cfCommonPrefixLen;
    int cqCommonPrefixLen;
    int cvCommonPrefixLen;
    long tsDiff;

    public RelativeKey() {
    }

    public RelativeKey(Key prevKey, Key key) {
        this.key = key;
        this.fieldsSame = 0;
        this.fieldsPrefixed = 0;
        if (prevKey != null) {
            ByteSequence prevKeyScratch = prevKey.getRowData();
            ByteSequence keyScratch = key.getRowData();
            this.rowCommonPrefixLen = RelativeKey.getCommonPrefix(prevKeyScratch, keyScratch);
            if (this.rowCommonPrefixLen == -1) {
                this.fieldsSame = (byte)(this.fieldsSame | 1);
            } else if (this.rowCommonPrefixLen > 1) {
                this.fieldsPrefixed = (byte)(this.fieldsPrefixed | 1);
            }
            prevKeyScratch = prevKey.getColumnFamilyData();
            keyScratch = key.getColumnFamilyData();
            this.cfCommonPrefixLen = RelativeKey.getCommonPrefix(prevKeyScratch, keyScratch);
            if (this.cfCommonPrefixLen == -1) {
                this.fieldsSame = (byte)(this.fieldsSame | 2);
            } else if (this.cfCommonPrefixLen > 1) {
                this.fieldsPrefixed = (byte)(this.fieldsPrefixed | 2);
            }
            prevKeyScratch = prevKey.getColumnQualifierData();
            keyScratch = key.getColumnQualifierData();
            this.cqCommonPrefixLen = RelativeKey.getCommonPrefix(prevKeyScratch, keyScratch);
            if (this.cqCommonPrefixLen == -1) {
                this.fieldsSame = (byte)(this.fieldsSame | 4);
            } else if (this.cqCommonPrefixLen > 1) {
                this.fieldsPrefixed = (byte)(this.fieldsPrefixed | 4);
            }
            prevKeyScratch = prevKey.getColumnVisibilityData();
            keyScratch = key.getColumnVisibilityData();
            this.cvCommonPrefixLen = RelativeKey.getCommonPrefix(prevKeyScratch, keyScratch);
            if (this.cvCommonPrefixLen == -1) {
                this.fieldsSame = (byte)(this.fieldsSame | 8);
            } else if (this.cvCommonPrefixLen > 1) {
                this.fieldsPrefixed = (byte)(this.fieldsPrefixed | 8);
            }
            this.tsDiff = key.getTimestamp() - prevKey.getTimestamp();
            if (this.tsDiff == 0L) {
                this.fieldsSame = (byte)(this.fieldsSame | 0x10);
            } else {
                this.fieldsPrefixed = (byte)(this.fieldsPrefixed | 0x10);
            }
            this.fieldsSame = (byte)(this.fieldsSame | (this.fieldsPrefixed == 0 ? 0 : -128));
        }
        if (key.isDeleted()) {
            this.fieldsSame = (byte)(this.fieldsSame | 0x20);
        }
    }

    static int getCommonPrefix(ByteSequence prev, ByteSequence cur) {
        if (prev == cur) {
            return -1;
        }
        int prevLen = prev.length();
        int curLen = cur.length();
        int maxChecks = Math.min(prevLen, curLen);
        for (int common = 0; common < maxChecks; ++common) {
            int b;
            int a = prev.byteAt(common) & 0xFF;
            if (a == (b = cur.byteAt(common) & 0xFF)) continue;
            return common;
        }
        return prevLen == curLen ? -1 : maxChecks;
    }

    public void setPrevKey(Key pk) {
        this.prevKey = pk;
    }

    public void readFields(DataInput in) throws IOException {
        this.fieldsSame = in.readByte();
        this.fieldsPrefixed = (this.fieldsSame & 0xFFFFFF80) == -128 ? in.readByte() : (byte)0;
        byte[] row = (this.fieldsSame & 1) == 1 ? this.prevKey.getRowData().toArray() : ((this.fieldsPrefixed & 1) == 1 ? RelativeKey.readPrefix(in, this.prevKey.getRowData()) : RelativeKey.read(in));
        byte[] cf = (this.fieldsSame & 2) == 2 ? this.prevKey.getColumnFamilyData().toArray() : ((this.fieldsPrefixed & 2) == 2 ? RelativeKey.readPrefix(in, this.prevKey.getColumnFamilyData()) : RelativeKey.read(in));
        byte[] cq = (this.fieldsSame & 4) == 4 ? this.prevKey.getColumnQualifierData().toArray() : ((this.fieldsPrefixed & 4) == 4 ? RelativeKey.readPrefix(in, this.prevKey.getColumnQualifierData()) : RelativeKey.read(in));
        byte[] cv = (this.fieldsSame & 8) == 8 ? this.prevKey.getColumnVisibilityData().toArray() : ((this.fieldsPrefixed & 8) == 8 ? RelativeKey.readPrefix(in, this.prevKey.getColumnVisibilityData()) : RelativeKey.read(in));
        long ts = (this.fieldsSame & 0x10) == 16 ? this.prevKey.getTimestamp() : ((this.fieldsPrefixed & 0x10) == 16 ? WritableUtils.readVLong((DataInput)in) + this.prevKey.getTimestamp() : WritableUtils.readVLong((DataInput)in));
        this.prevKey = this.key = new Key(row, cf, cq, cv, ts, (this.fieldsSame & 0x20) == 32, false);
    }

    public static SkippR fastSkip(DataInput in, Key seekKey, MutableByteSequence value, Key prevKey, Key currKey, int entriesLeft) throws IOException {
        int count;
        MutableByteSequence cv;
        MutableByteSequence cq;
        MutableByteSequence cf;
        MutableByteSequence row;
        MutableByteSequence pcv;
        MutableByteSequence pcq;
        MutableByteSequence pcf;
        MutableByteSequence prow;
        ByteSequence stopRow = seekKey.getRowData();
        ByteSequence stopCF = seekKey.getColumnFamilyData();
        ByteSequence stopCQ = seekKey.getColumnQualifierData();
        long ts = -1L;
        long pts = -1L;
        boolean pdel = false;
        int rowCmp = -1;
        int cfCmp = -1;
        int cqCmp = -1;
        if (currKey != null) {
            prow = new MutableByteSequence(currKey.getRowData());
            pcf = new MutableByteSequence(currKey.getColumnFamilyData());
            pcq = new MutableByteSequence(currKey.getColumnQualifierData());
            pcv = new MutableByteSequence(currKey.getColumnVisibilityData());
            pts = currKey.getTimestamp();
            row = new MutableByteSequence(currKey.getRowData());
            cf = new MutableByteSequence(currKey.getColumnFamilyData());
            cq = new MutableByteSequence(currKey.getColumnQualifierData());
            cv = new MutableByteSequence(currKey.getColumnVisibilityData());
            ts = currKey.getTimestamp();
            rowCmp = row.compareTo(stopRow);
            cfCmp = cf.compareTo(stopCF);
            cqCmp = cq.compareTo(stopCQ);
            if (rowCmp >= 0) {
                if (rowCmp > 0) {
                    RelativeKey rk = new RelativeKey();
                    rk.key = rk.prevKey = new Key(currKey);
                    return new SkippR(rk, 0, prevKey);
                }
                if (cfCmp >= 0) {
                    if (cfCmp > 0) {
                        RelativeKey rk = new RelativeKey();
                        rk.key = rk.prevKey = new Key(currKey);
                        return new SkippR(rk, 0, prevKey);
                    }
                    if (cqCmp >= 0) {
                        RelativeKey rk = new RelativeKey();
                        rk.key = rk.prevKey = new Key(currKey);
                        return new SkippR(rk, 0, prevKey);
                    }
                }
            }
        } else {
            row = new MutableByteSequence(new byte[64], 0, 0);
            cf = new MutableByteSequence(new byte[64], 0, 0);
            cq = new MutableByteSequence(new byte[64], 0, 0);
            cv = new MutableByteSequence(new byte[64], 0, 0);
            prow = new MutableByteSequence(new byte[64], 0, 0);
            pcf = new MutableByteSequence(new byte[64], 0, 0);
            pcq = new MutableByteSequence(new byte[64], 0, 0);
            pcv = new MutableByteSequence(new byte[64], 0, 0);
        }
        int fieldsSame = -1;
        byte fieldsPrefixed = 0;
        Key newPrevKey = null;
        for (count = 0; count < entriesLeft; ++count) {
            MutableByteSequence tmp;
            pdel = (fieldsSame & 0x20) == 32;
            fieldsSame = in.readByte();
            fieldsPrefixed = (fieldsSame & 0xFFFFFF80) == -128 ? in.readByte() : (byte)0;
            boolean changed = false;
            if ((fieldsSame & 1) != 1) {
                tmp = prow;
                prow = row;
                row = tmp;
                if ((fieldsPrefixed & 1) == 1) {
                    RelativeKey.readPrefix(in, row, prow);
                } else {
                    RelativeKey.read(in, row);
                }
                rowCmp = row.compareTo(stopRow);
                changed = true;
            }
            if ((fieldsSame & 2) != 2) {
                tmp = pcf;
                pcf = cf;
                cf = tmp;
                if ((fieldsPrefixed & 2) == 2) {
                    RelativeKey.readPrefix(in, cf, pcf);
                } else {
                    RelativeKey.read(in, cf);
                }
                cfCmp = cf.compareTo(stopCF);
                changed = true;
            }
            if ((fieldsSame & 4) != 4) {
                tmp = pcq;
                pcq = cq;
                cq = tmp;
                if ((fieldsPrefixed & 4) == 4) {
                    RelativeKey.readPrefix(in, cq, pcq);
                } else {
                    RelativeKey.read(in, cq);
                }
                cqCmp = cq.compareTo(stopCQ);
                changed = true;
            }
            if ((fieldsSame & 8) != 8) {
                tmp = pcv;
                pcv = cv;
                cv = tmp;
                if ((fieldsPrefixed & 8) == 8) {
                    RelativeKey.readPrefix(in, cv, pcv);
                } else {
                    RelativeKey.read(in, cv);
                }
            }
            if ((fieldsSame & 0x10) != 16) {
                pts = ts;
                ts = (fieldsPrefixed & 0x10) == 16 ? WritableUtils.readVLong((DataInput)in) + pts : WritableUtils.readVLong((DataInput)in);
            }
            RelativeKey.readValue(in, value);
            if (!changed || rowCmp < 0 || rowCmp <= 0 && (cfCmp < 0 || cfCmp <= 0 && cqCmp < 0)) continue;
            break;
        }
        if (count > 1) {
            MutableByteSequence trow = (fieldsSame & 1) == 1 ? row : prow;
            MutableByteSequence tcf = (fieldsSame & 2) == 2 ? cf : pcf;
            MutableByteSequence tcq = (fieldsSame & 4) == 4 ? cq : pcq;
            MutableByteSequence tcv = (fieldsSame & 8) == 8 ? cv : pcv;
            long tts = (fieldsSame & 0x10) == 16 ? ts : pts;
            newPrevKey = new Key(trow.getBackingArray(), trow.offset(), trow.length(), tcf.getBackingArray(), tcf.offset(), tcf.length(), tcq.getBackingArray(), tcq.offset(), tcq.length(), tcv.getBackingArray(), tcv.offset(), tcv.length(), tts);
            newPrevKey.setDeleted(pdel);
        } else if (count == 1) {
            newPrevKey = currKey != null ? currKey : prevKey;
        } else {
            throw new IllegalStateException();
        }
        RelativeKey result = new RelativeKey();
        result.key = new Key(row.getBackingArray(), row.offset(), row.length(), cf.getBackingArray(), cf.offset(), cf.length(), cq.getBackingArray(), cq.offset(), cq.length(), cv.getBackingArray(), cv.offset(), cv.length(), ts);
        result.key.setDeleted((fieldsSame & 0x20) != 0);
        result.prevKey = result.key;
        return new SkippR(result, count, newPrevKey);
    }

    private static void read(DataInput in, MutableByteSequence mbseq) throws IOException {
        int len = WritableUtils.readVInt((DataInput)in);
        RelativeKey.read(in, mbseq, len);
    }

    private static void readValue(DataInput in, MutableByteSequence mbseq) throws IOException {
        int len = in.readInt();
        RelativeKey.read(in, mbseq, len);
    }

    private static void read(DataInput in, MutableByteSequence mbseqDestination, int len) throws IOException {
        if (mbseqDestination.getBackingArray().length < len) {
            mbseqDestination.setArray(new byte[UnsynchronizedBuffer.nextArraySize(len)], 0, 0);
        }
        in.readFully(mbseqDestination.getBackingArray(), 0, len);
        mbseqDestination.setLength(len);
    }

    private static byte[] readPrefix(DataInput in, ByteSequence prefixSource) throws IOException {
        int prefixLen = WritableUtils.readVInt((DataInput)in);
        int remainingLen = WritableUtils.readVInt((DataInput)in);
        byte[] data = new byte[prefixLen + remainingLen];
        if (prefixSource.isBackedByArray()) {
            System.arraycopy(prefixSource.getBackingArray(), prefixSource.offset(), data, 0, prefixLen);
        } else {
            byte[] prefixArray = prefixSource.toArray();
            System.arraycopy(prefixArray, 0, data, 0, prefixLen);
        }
        in.readFully(data, prefixLen, remainingLen);
        return data;
    }

    private static void readPrefix(DataInput in, MutableByteSequence dest, ByteSequence prefixSource) throws IOException {
        int prefixLen = WritableUtils.readVInt((DataInput)in);
        int remainingLen = WritableUtils.readVInt((DataInput)in);
        int len = prefixLen + remainingLen;
        if (dest.getBackingArray().length < len) {
            dest.setArray(new byte[UnsynchronizedBuffer.nextArraySize(len)], 0, 0);
        }
        if (prefixSource.isBackedByArray()) {
            System.arraycopy(prefixSource.getBackingArray(), prefixSource.offset(), dest.getBackingArray(), 0, prefixLen);
        } else {
            byte[] prefixArray = prefixSource.toArray();
            System.arraycopy(prefixArray, 0, dest.getBackingArray(), 0, prefixLen);
        }
        in.readFully(dest.getBackingArray(), prefixLen, remainingLen);
        dest.setLength(len);
    }

    private static byte[] read(DataInput in) throws IOException {
        int len = WritableUtils.readVInt((DataInput)in);
        byte[] data = new byte[len];
        in.readFully(data);
        return data;
    }

    public Key getKey() {
        return this.key;
    }

    private static void write(DataOutput out, ByteSequence bs) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)bs.length());
        out.write(bs.getBackingArray(), bs.offset(), bs.length());
    }

    private static void writePrefix(DataOutput out, ByteSequence bs, int commonPrefixLength) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)commonPrefixLength);
        WritableUtils.writeVInt((DataOutput)out, (int)(bs.length() - commonPrefixLength));
        out.write(bs.getBackingArray(), bs.offset() + commonPrefixLength, bs.length() - commonPrefixLength);
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(this.fieldsSame);
        if ((this.fieldsSame & 0xFFFFFF80) == -128) {
            out.write(this.fieldsPrefixed);
        }
        if ((this.fieldsSame & 1) != 1) {
            if ((this.fieldsPrefixed & 1) == 1) {
                RelativeKey.writePrefix(out, this.key.getRowData(), this.rowCommonPrefixLen);
            } else {
                RelativeKey.write(out, this.key.getRowData());
            }
        }
        if ((this.fieldsSame & 2) != 2) {
            if ((this.fieldsPrefixed & 2) == 2) {
                RelativeKey.writePrefix(out, this.key.getColumnFamilyData(), this.cfCommonPrefixLen);
            } else {
                RelativeKey.write(out, this.key.getColumnFamilyData());
            }
        }
        if ((this.fieldsSame & 4) != 4) {
            if ((this.fieldsPrefixed & 4) == 4) {
                RelativeKey.writePrefix(out, this.key.getColumnQualifierData(), this.cqCommonPrefixLen);
            } else {
                RelativeKey.write(out, this.key.getColumnQualifierData());
            }
        }
        if ((this.fieldsSame & 8) != 8) {
            if ((this.fieldsPrefixed & 8) == 8) {
                RelativeKey.writePrefix(out, this.key.getColumnVisibilityData(), this.cvCommonPrefixLen);
            } else {
                RelativeKey.write(out, this.key.getColumnVisibilityData());
            }
        }
        if ((this.fieldsSame & 0x10) != 16) {
            if ((this.fieldsPrefixed & 0x10) == 16) {
                WritableUtils.writeVLong((DataOutput)out, (long)this.tsDiff);
            } else {
                WritableUtils.writeVLong((DataOutput)out, (long)this.key.getTimestamp());
            }
        }
    }

    public static class SkippR {
        RelativeKey rk;
        int skipped;
        Key prevKey;

        SkippR(RelativeKey rk, int skipped, Key prevKey) {
            this.rk = rk;
            this.skipped = skipped;
            this.prevKey = prevKey;
        }
    }
}

