/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.accumulo.core.client.admin.DelegationTokenConfig;
import org.apache.accumulo.core.security.thrift.TAuthenticationTokenIdentifier;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.accumulo.core.util.ThriftMessageUtil;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.TokenIdentifier;

public class AuthenticationTokenIdentifier
extends TokenIdentifier {
    public static final Text TOKEN_KIND = new Text("ACCUMULO_AUTH_TOKEN");
    private TAuthenticationTokenIdentifier impl = null;
    private DelegationTokenConfig cfg = null;

    public AuthenticationTokenIdentifier() {
    }

    public AuthenticationTokenIdentifier(String principal) {
        this(principal, null);
    }

    public AuthenticationTokenIdentifier(String principal, DelegationTokenConfig cfg) {
        Objects.requireNonNull(principal);
        this.impl = new TAuthenticationTokenIdentifier(principal);
        this.cfg = cfg;
    }

    public AuthenticationTokenIdentifier(String principal, int keyId, long issueDate, long expirationDate, String instanceId) {
        Objects.requireNonNull(principal);
        this.impl = new TAuthenticationTokenIdentifier(principal);
        this.impl.setKeyId(keyId);
        this.impl.setIssueDate(issueDate);
        this.impl.setExpirationDate(expirationDate);
        this.impl.setInstanceId(instanceId);
    }

    public AuthenticationTokenIdentifier(AuthenticationTokenIdentifier identifier) {
        Objects.requireNonNull(identifier);
        this.impl = new TAuthenticationTokenIdentifier(identifier.getThriftIdentifier());
    }

    public AuthenticationTokenIdentifier(TAuthenticationTokenIdentifier identifier) {
        Objects.requireNonNull(identifier);
        this.impl = new TAuthenticationTokenIdentifier(identifier);
    }

    public void setKeyId(int keyId) {
        this.impl.setKeyId(keyId);
    }

    public int getKeyId() {
        Objects.requireNonNull(this.impl, "Identifier not initialized");
        return this.impl.getKeyId();
    }

    public void setIssueDate(long issueDate) {
        Objects.requireNonNull(this.impl, "Identifier not initialized");
        this.impl.setIssueDate(issueDate);
    }

    public long getIssueDate() {
        Objects.requireNonNull(this.impl, "Identifier not initialized");
        return this.impl.getIssueDate();
    }

    public void setExpirationDate(long expirationDate) {
        Objects.requireNonNull(this.impl, "Identifier not initialized");
        this.impl.setExpirationDate(expirationDate);
    }

    public long getExpirationDate() {
        Objects.requireNonNull(this.impl, "Identifier not initialized");
        return this.impl.getExpirationDate();
    }

    public void setInstanceId(String instanceId) {
        Objects.requireNonNull(this.impl, "Identifier not initialized");
        this.impl.setInstanceId(instanceId);
    }

    public String getInstanceId() {
        Objects.requireNonNull(this.impl, "Identifier not initialized");
        return this.impl.getInstanceId();
    }

    public TAuthenticationTokenIdentifier getThriftIdentifier() {
        Objects.requireNonNull(this.impl);
        return this.impl;
    }

    public DelegationTokenConfig getConfig() {
        return this.cfg;
    }

    public void write(DataOutput out) throws IOException {
        if (null != this.impl) {
            ThriftMessageUtil msgUtil = new ThriftMessageUtil();
            ByteBuffer serialized = msgUtil.serialize(this.impl);
            out.writeInt(serialized.limit());
            ByteBufferUtil.write(out, serialized);
        } else {
            out.writeInt(0);
        }
    }

    public void readFields(DataInput in) throws IOException {
        int length = in.readInt();
        if (length > 0) {
            ThriftMessageUtil msgUtil = new ThriftMessageUtil();
            byte[] serialized = new byte[length];
            in.readFully(serialized);
            this.impl = new TAuthenticationTokenIdentifier();
            msgUtil.deserialize(serialized, this.impl);
        }
    }

    public Text getKind() {
        return TOKEN_KIND;
    }

    public UserGroupInformation getUser() {
        if (null != this.impl && this.impl.isSetPrincipal()) {
            return UserGroupInformation.createRemoteUser((String)this.impl.getPrincipal());
        }
        return null;
    }

    public int hashCode() {
        if (null == this.impl) {
            return 0;
        }
        HashCodeBuilder hcb = new HashCodeBuilder(7, 11);
        if (this.impl.isSetPrincipal()) {
            hcb.append((Object)this.impl.getPrincipal());
        }
        if (this.impl.isSetKeyId()) {
            hcb.append(this.impl.getKeyId());
        }
        if (this.impl.isSetIssueDate()) {
            hcb.append(this.impl.getIssueDate());
        }
        if (this.impl.isSetExpirationDate()) {
            hcb.append(this.impl.getExpirationDate());
        }
        if (this.impl.isSetInstanceId()) {
            hcb.append((Object)this.impl.getInstanceId());
        }
        return hcb.toHashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("AuthenticationTokenIdentifier(").append(this.impl).append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        if (o instanceof AuthenticationTokenIdentifier) {
            AuthenticationTokenIdentifier other = (AuthenticationTokenIdentifier)((Object)o);
            if (null == this.impl) {
                return null == other.impl;
            }
            return this.impl.equals(other.impl);
        }
        return false;
    }
}

