/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.binder.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.spi.FilterReply;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.Counter;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.MeterRegistry;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.Tag;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.instrument.binder.logging.LogbackMetrics;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.lang.NonNullApi;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.micrometer.core.lang.NonNullFields;
import org.slf4j.Marker;

@NonNullApi
@NonNullFields
class MetricsTurboFilter
extends TurboFilter {
    private final Counter errorCounter;
    private final Counter warnCounter;
    private final Counter infoCounter;
    private final Counter debugCounter;
    private final Counter traceCounter;

    MetricsTurboFilter(MeterRegistry registry, Iterable<Tag> tags) {
        this.errorCounter = Counter.builder("logback.events").tags(tags).tags("level", "error").description("Number of error level events that made it to the logs").baseUnit("events").register(registry);
        this.warnCounter = Counter.builder("logback.events").tags(tags).tags("level", "warn").description("Number of warn level events that made it to the logs").baseUnit("events").register(registry);
        this.infoCounter = Counter.builder("logback.events").tags(tags).tags("level", "info").description("Number of info level events that made it to the logs").baseUnit("events").register(registry);
        this.debugCounter = Counter.builder("logback.events").tags(tags).tags("level", "debug").description("Number of debug level events that made it to the logs").baseUnit("events").register(registry);
        this.traceCounter = Counter.builder("logback.events").tags(tags).tags("level", "trace").description("Number of trace level events that made it to the logs").baseUnit("events").register(registry);
    }

    public FilterReply decide(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t2) {
        if (format == null) {
            return FilterReply.NEUTRAL;
        }
        Boolean ignored = LogbackMetrics.ignoreMetrics.get();
        if (ignored != null && ignored.booleanValue()) {
            return FilterReply.NEUTRAL;
        }
        if (level.isGreaterOrEqual(logger.getEffectiveLevel())) {
            switch (level.toInt()) {
                case 40000: {
                    this.errorCounter.increment();
                    break;
                }
                case 30000: {
                    this.warnCounter.increment();
                    break;
                }
                case 20000: {
                    this.infoCounter.increment();
                    break;
                }
                case 10000: {
                    this.debugCounter.increment();
                    break;
                }
                case 5000: {
                    this.traceCounter.increment();
                }
            }
        }
        return FilterReply.NEUTRAL;
    }
}

