/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.client;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import org.apache.hive.kudu.org.apache.kudu.ColumnSchema;
import org.apache.hive.kudu.org.apache.kudu.Schema;
import org.apache.hive.kudu.org.apache.kudu.Type;
import org.apache.hive.kudu.org.apache.kudu.client.Bytes;
import org.apache.hive.kudu.org.apache.kudu.util.DateUtil;
import org.apache.hive.kudu.org.apache.kudu.util.TimestampUtil;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class RowResult {
    protected static final int INDEX_RESET_LOCATION = -1;
    protected int index = -1;
    protected final Schema schema;

    RowResult(Schema schema, int rowIndex) {
        this.schema = schema;
        this.index = rowIndex;
    }

    void resetPointer() {
        this.advancePointerTo(-1);
    }

    void advancePointerTo(int rowIndex) {
        this.index = rowIndex;
    }

    public final int getInt(String columnName) {
        return this.getInt(this.schema.getColumnIndex(columnName));
    }

    public abstract int getInt(int var1);

    public final short getShort(String columnName) {
        return this.getShort(this.schema.getColumnIndex(columnName));
    }

    public abstract short getShort(int var1);

    public final boolean getBoolean(String columnName) {
        return this.getBoolean(this.schema.getColumnIndex(columnName));
    }

    public abstract boolean getBoolean(int var1);

    public final byte getByte(String columnName) {
        return this.getByte(this.schema.getColumnIndex(columnName));
    }

    public abstract byte getByte(int var1);

    public final long getLong(String columnName) {
        return this.getLong(this.schema.getColumnIndex(columnName));
    }

    public abstract long getLong(int var1);

    public final float getFloat(String columnName) {
        return this.getFloat(this.schema.getColumnIndex(columnName));
    }

    public abstract float getFloat(int var1);

    public final double getDouble(String columnName) {
        return this.getDouble(this.schema.getColumnIndex(columnName));
    }

    public abstract double getDouble(int var1);

    public final BigDecimal getDecimal(String columnName) {
        return this.getDecimal(this.schema.getColumnIndex(columnName));
    }

    public abstract BigDecimal getDecimal(int var1);

    public final Timestamp getTimestamp(String columnName) {
        return this.getTimestamp(this.schema.getColumnIndex(columnName));
    }

    public abstract Timestamp getTimestamp(int var1);

    public final Date getDate(String columnName) {
        return this.getDate(this.schema.getColumnIndex(columnName));
    }

    public final Date getDate(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.DATE);
        int days = this.getInt(columnIndex);
        return DateUtil.epochDaysToSqlDate(days);
    }

    public final Schema getColumnProjection() {
        return this.schema;
    }

    public final String getString(String columnName) {
        return this.getString(this.schema.getColumnIndex(columnName));
    }

    public final String getString(int columnIndex) {
        this.checkType(columnIndex, Type.STRING);
        return this.getVarLengthData(columnIndex);
    }

    protected abstract String getVarLengthData(int var1);

    public final String getVarchar(int columnIndex) {
        this.checkType(columnIndex, Type.VARCHAR);
        return this.getVarLengthData(columnIndex);
    }

    public final String getVarchar(String columnName) {
        return this.getVarchar(this.schema.getColumnIndex(columnName));
    }

    public final byte[] getBinaryCopy(String columnName) {
        return this.getBinaryCopy(this.schema.getColumnIndex(columnName));
    }

    public abstract byte[] getBinaryCopy(int var1);

    public final ByteBuffer getBinary(String columnName) {
        return this.getBinary(this.schema.getColumnIndex(columnName));
    }

    public abstract ByteBuffer getBinary(int var1);

    public final boolean isNull(String columnName) {
        return this.isNull(this.schema.getColumnIndex(columnName));
    }

    public abstract boolean isNull(int var1);

    public final Object getObject(String columnName) {
        return this.getObject(this.schema.getColumnIndex(columnName));
    }

    public final Object getObject(int columnIndex) {
        this.checkValidColumn(columnIndex);
        if (this.isNull(columnIndex)) {
            return null;
        }
        Type type = this.schema.getColumnByIndex(columnIndex).getType();
        switch (type) {
            case BOOL: {
                return this.getBoolean(columnIndex);
            }
            case INT8: {
                return this.getByte(columnIndex);
            }
            case INT16: {
                return this.getShort(columnIndex);
            }
            case INT32: {
                return this.getInt(columnIndex);
            }
            case INT64: {
                return this.getLong(columnIndex);
            }
            case DATE: {
                return this.getDate(columnIndex);
            }
            case UNIXTIME_MICROS: {
                return this.getTimestamp(columnIndex);
            }
            case FLOAT: {
                return Float.valueOf(this.getFloat(columnIndex));
            }
            case DOUBLE: {
                return this.getDouble(columnIndex);
            }
            case VARCHAR: {
                return this.getVarchar(columnIndex);
            }
            case STRING: {
                return this.getString(columnIndex);
            }
            case BINARY: {
                return this.getBinaryCopy(columnIndex);
            }
            case DECIMAL: {
                return this.getDecimal(columnIndex);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + (Object)((Object)type));
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public final boolean hasIsDeleted() {
        return this.schema.hasIsDeleted();
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public final boolean isDeleted() {
        return this.getBoolean(this.schema.getIsDeletedIndex());
    }

    public final Type getColumnType(String columnName) {
        return this.schema.getColumn(columnName).getType();
    }

    public final Type getColumnType(int columnIndex) {
        return this.schema.getColumnByIndex(columnIndex).getType();
    }

    public final Schema getSchema() {
        return this.schema;
    }

    protected final void checkValidColumn(int columnIndex) {
        if (columnIndex >= this.schema.getColumnCount()) {
            throw new IndexOutOfBoundsException("Requested column is out of range, " + columnIndex + " out of " + this.schema.getColumnCount());
        }
    }

    protected final void checkNull(int columnIndex) {
        if (!this.schema.hasNullableColumns()) {
            return;
        }
        if (this.isNull(columnIndex)) {
            ColumnSchema columnSchema = this.schema.getColumnByIndex(columnIndex);
            throw new IllegalArgumentException("The requested column (name: " + columnSchema.getName() + ", index: " + columnIndex + ") is null");
        }
    }

    protected final void checkType(int columnIndex, Type ... types) {
        ColumnSchema columnSchema = this.schema.getColumnByIndex(columnIndex);
        Type columnType = columnSchema.getType();
        for (Type type : types) {
            if (!columnType.equals((Object)type)) continue;
            return;
        }
        throw new IllegalArgumentException("Column (name: " + columnSchema.getName() + ", index: " + columnIndex + ") is of type " + columnType.getName() + " but was requested as a type " + Arrays.toString((Object[])types));
    }

    public String rowToString() {
        StringBuilder buf = new StringBuilder();
        block15: for (int i = 0; i < this.schema.getColumnCount(); ++i) {
            ColumnSchema col = this.schema.getColumnByIndex(i);
            if (i != 0) {
                buf.append(", ");
            }
            Type type = col.getType();
            buf.append(type.name());
            buf.append(" ").append(col.getName());
            if (col.getTypeAttributes() != null) {
                buf.append(col.getTypeAttributes().toStringForType(type));
            }
            buf.append("=");
            if (this.isNull(i)) {
                buf.append("NULL");
                continue;
            }
            switch (col.getType()) {
                case INT8: {
                    buf.append(this.getByte(i));
                    continue block15;
                }
                case INT16: {
                    buf.append(this.getShort(i));
                    continue block15;
                }
                case INT32: {
                    buf.append(this.getInt(i));
                    continue block15;
                }
                case INT64: {
                    buf.append(this.getLong(i));
                    continue block15;
                }
                case DATE: {
                    buf.append(DateUtil.epochDaysToDateString(this.getInt(i)));
                    continue block15;
                }
                case UNIXTIME_MICROS: {
                    buf.append(TimestampUtil.timestampToString(this.getTimestamp(i)));
                    continue block15;
                }
                case VARCHAR: {
                    buf.append(this.getVarchar(i));
                    continue block15;
                }
                case STRING: {
                    buf.append(this.getString(i));
                    continue block15;
                }
                case BINARY: {
                    buf.append(Bytes.pretty(this.getBinaryCopy(i)));
                    continue block15;
                }
                case FLOAT: {
                    buf.append(this.getFloat(i));
                    continue block15;
                }
                case DOUBLE: {
                    buf.append(this.getDouble(i));
                    continue block15;
                }
                case DECIMAL: {
                    buf.append(this.getDecimal(i));
                    continue block15;
                }
                case BOOL: {
                    buf.append(this.getBoolean(i));
                    continue block15;
                }
                default: {
                    buf.append("<unknown type!>");
                }
            }
        }
        return buf.toString();
    }

    public String toStringLongFormat() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.toString());
        buf.append("{");
        buf.append(this.rowToString());
        buf.append("}");
        return buf.toString();
    }
}

