/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.client;

import org.apache.hive.kudu.org.apache.kudu.client.CallResponse;
import org.apache.hive.kudu.org.apache.kudu.client.KuduException;
import org.apache.hive.kudu.org.apache.kudu.client.KuduRpc;
import org.apache.hive.kudu.org.apache.kudu.client.KuduTable;
import org.apache.hive.kudu.org.apache.kudu.client.RecallDeletedTableResponse;
import org.apache.hive.kudu.org.apache.kudu.master.Master;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.protobuf.ByteString;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.protobuf.Message;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.util.Timer;
import org.apache.hive.kudu.org.apache.kudu.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class RecallDeletedTableRequest
extends KuduRpc<RecallDeletedTableResponse> {
    static final String RECALL_DELETED_TABLE = "RecallDeletedTable";
    private final String newTableName;
    private final String id;

    RecallDeletedTableRequest(KuduTable table, String id, String newTableName, Timer timer, long timeoutMillis) {
        super(table, timer, timeoutMillis);
        this.id = id;
        this.newTableName = newTableName;
    }

    @Override
    Message createRequestPB() {
        Master.RecallDeletedTableRequestPB.Builder builder = Master.RecallDeletedTableRequestPB.newBuilder();
        builder.setTable(Master.TableIdentifierPB.newBuilder().setTableId(ByteString.copyFromUtf8(this.id)));
        if (!this.newTableName.isEmpty()) {
            builder.setNewTableName(this.newTableName);
        }
        return builder.build();
    }

    @Override
    String serviceName() {
        return "kudu.master.MasterService";
    }

    @Override
    String method() {
        return RECALL_DELETED_TABLE;
    }

    @Override
    Pair<RecallDeletedTableResponse, Object> deserialize(CallResponse callResponse, String tsUUID) throws KuduException {
        Master.RecallDeletedTableResponsePB.Builder builder = Master.RecallDeletedTableResponsePB.newBuilder();
        RecallDeletedTableRequest.readProtobuf(callResponse.getPBMessage(), builder);
        RecallDeletedTableResponse response = new RecallDeletedTableResponse(this.timeoutTracker.getElapsedMillis(), tsUUID);
        return new Pair<RecallDeletedTableResponse, Object>(response, builder.hasError() ? builder.getError() : null);
    }
}

