/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.com.stumbleupon.async;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.hive.kudu.com.stumbleupon.async.Callback;
import org.apache.hive.kudu.com.stumbleupon.async.Deferred;
import org.apache.hive.kudu.com.stumbleupon.async.DeferredGroupException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DeferredGroup<T> {
    private final Deferred<ArrayList<T>> parent = new Deferred();
    private int nresults;
    private final ArrayList<Object> results;

    public DeferredGroup(Collection<Deferred<T>> deferreds, boolean ordered) {
        this.nresults = deferreds.size();
        this.results = new ArrayList(this.nresults);
        if (this.nresults == 0) {
            this.parent.callback(this.results);
            return;
        }
        if (ordered) {
            int i = 0;
            for (Deferred<T> d : deferreds) {
                this.results.add(null);
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                final class NotifyOrdered<T>
                implements Callback<T, T> {
                    private final int index;

                    NotifyOrdered(int index) {
                        this.index = index;
                    }

                    @Override
                    public T call(T arg) {
                        DeferredGroup.this.recordCompletion(arg, this.index);
                        return arg;
                    }

                    public String toString() {
                        return "notify #" + this.index + " DeferredGroup@" + DeferredGroup.super.hashCode();
                    }
                }
                d.addBoth(new NotifyOrdered(i++));
            }
        } else {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            final class Notify<T>
            implements Callback<T, T> {
                Notify() {
                }

                @Override
                public T call(T arg) {
                    DeferredGroup.this.recordCompletion(arg);
                    return arg;
                }

                public String toString() {
                    return "notify DeferredGroup@" + DeferredGroup.super.hashCode();
                }
            }
            Notify notify = new Notify();
            for (Deferred<T> d : deferreds) {
                d.addBoth(notify);
            }
        }
    }

    public Deferred<ArrayList<T>> getDeferred() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordCompletion(Object result) {
        int left;
        DeferredGroup deferredGroup = this;
        synchronized (deferredGroup) {
            this.results.add(result);
            left = --this.nresults;
        }
        if (left == 0) {
            this.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordCompletion(Object result, int index) {
        int left;
        DeferredGroup deferredGroup = this;
        synchronized (deferredGroup) {
            this.results.set(index, result);
            left = --this.nresults;
        }
        if (left == 0) {
            this.done();
        }
    }

    private void done() {
        for (Object r : this.results) {
            if (!(r instanceof Exception)) continue;
            this.parent.callback(new DeferredGroupException(this.results, (Exception)r));
            return;
        }
        this.parent.callback(this.results);
    }

    public String toString() {
        return "DeferredGroup(parent=" + this.parent + ", # results=" + this.results.size() + " / " + this.nresults + " left)";
    }
}

