/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.properties;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.datanucleus.PropertyNames;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.util.NucleusLogger;

public class FrequentlyAccessedProperties {
    private static Map<String, Field> fieldMap = new HashMap<String, Field>();
    private FrequentlyAccessedProperties defaults;
    private Boolean manageRelationships = null;
    private Boolean reachabilityAtCommit = null;
    private Boolean detachOnClose = null;
    private Boolean detachAllOnCommit = null;
    private String level2CacheStoreMode = null;
    private String level2CacheRetrieveMode = null;
    private Boolean serialiseRead = null;
    private Boolean optimisticLocking = null;

    public void setDefaults(FrequentlyAccessedProperties defaults) {
        this.defaults = defaults;
    }

    public void setProperty(String property, Object value) {
        if (property == null) {
            return;
        }
        Field f = fieldMap.get(property.toLowerCase());
        if (f == null) {
            return;
        }
        try {
            if (value == null) {
                f.set(this, null);
                return;
            }
            if (f.getType() == Boolean.class) {
                if (value instanceof Boolean) {
                    f.set(this, value);
                } else if (value instanceof String) {
                    Boolean boolVal = Boolean.valueOf((String)value);
                    f.set(this, boolVal);
                }
            } else {
                f.set(this, String.valueOf(value));
            }
        }
        catch (Exception e) {
            throw new NucleusUserException("Failed to set property: " + property + "=" + value + ": " + e, e);
        }
    }

    public Boolean getManageRelationships() {
        if (this.manageRelationships == null && this.defaults != null) {
            return this.defaults.getManageRelationships();
        }
        return this.manageRelationships;
    }

    public Boolean getReachabilityAtCommit() {
        if (this.reachabilityAtCommit == null && this.defaults != null) {
            return this.defaults.getReachabilityAtCommit();
        }
        return this.reachabilityAtCommit;
    }

    public Boolean getDetachOnClose() {
        if (this.detachOnClose == null && this.defaults != null) {
            return this.defaults.getDetachOnClose();
        }
        return this.detachOnClose;
    }

    public Boolean getDetachAllOnCommit() {
        if (this.detachAllOnCommit == null && this.defaults != null) {
            return this.defaults.getDetachAllOnCommit();
        }
        return this.detachAllOnCommit;
    }

    public String getLevel2CacheStoreMode() {
        if (this.level2CacheStoreMode == null && this.defaults != null) {
            return this.defaults.getLevel2CacheStoreMode();
        }
        return this.level2CacheStoreMode;
    }

    public String getLevel2CacheRetrieveMode() {
        if (this.level2CacheRetrieveMode == null && this.defaults != null) {
            return this.defaults.getLevel2CacheRetrieveMode();
        }
        return this.level2CacheRetrieveMode;
    }

    public Boolean getSerialiseRead() {
        if (this.serialiseRead == null && this.defaults != null) {
            return this.defaults.getSerialiseRead();
        }
        return this.serialiseRead;
    }

    public Boolean getOptimisticLocking() {
        if (this.optimisticLocking == null && this.defaults != null) {
            return this.defaults.getOptimisticLocking();
        }
        return this.optimisticLocking;
    }

    private static void addField(String propertyName, String fieldName) throws NoSuchFieldException, SecurityException {
        Field f = FrequentlyAccessedProperties.class.getDeclaredField(fieldName);
        f.setAccessible(true);
        fieldMap.put(propertyName.toLowerCase(), f);
    }

    static {
        try {
            FrequentlyAccessedProperties.addField(PropertyNames.PROPERTY_PERSISTENCE_BY_REACHABILITY_AT_COMMIT, "reachabilityAtCommit");
            FrequentlyAccessedProperties.addField(PropertyNames.PROPERTY_MANAGE_RELATIONSHIPS, "manageRelationships");
            FrequentlyAccessedProperties.addField(PropertyNames.PROPERTY_DETACH_ON_CLOSE, "detachOnClose");
            FrequentlyAccessedProperties.addField(PropertyNames.PROPERTY_DETACH_ALL_ON_COMMIT, "detachAllOnCommit");
            FrequentlyAccessedProperties.addField("datanucleus.cache.level2.storemode", "level2CacheStoreMode");
            FrequentlyAccessedProperties.addField("datanucleus.cache.level2.retrievemode", "level2CacheRetrieveMode");
            FrequentlyAccessedProperties.addField("datanucleus.serializeread", "serialiseRead");
            FrequentlyAccessedProperties.addField("datanucleus.optimistic", "optimisticLocking");
        }
        catch (Exception e) {
            NucleusLogger.GENERAL.error("Failed to set up frequently accessed properties: " + e, e);
        }
    }
}

