/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.common.requests;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafkaesque.common.message.EndTxnResponseData;
import org.apache.kafkaesque.common.protocol.ApiKeys;
import org.apache.kafkaesque.common.protocol.Errors;
import org.apache.kafkaesque.common.protocol.types.Struct;
import org.apache.kafkaesque.common.requests.AbstractResponse;

public class EndTxnResponse
extends AbstractResponse {
    public final EndTxnResponseData data;

    public EndTxnResponse(EndTxnResponseData data) {
        this.data = data;
    }

    public EndTxnResponse(Struct struct) {
        this(struct, (short)(EndTxnResponseData.SCHEMAS.length - 1));
    }

    public EndTxnResponse(Struct struct, short version) {
        this.data = new EndTxnResponseData(struct, version);
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.error());
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    public static EndTxnResponse parse(ByteBuffer buffer, short version) {
        return new EndTxnResponse(ApiKeys.END_TXN.parseResponse(version, buffer), version);
    }

    public String toString() {
        return this.data.toString();
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 1;
    }
}

