/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.conf.ConfigKey;
import org.apache.hadoop.hbase.procedure2.util.StringUtils;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.RegionSplitPolicy;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class ConstantSizeRegionSplitPolicy
extends RegionSplitPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(ConstantSizeRegionSplitPolicy.class);
    private long desiredMaxFileSize;
    private double jitterRate;
    protected boolean overallHRegionFiles;
    public static final String MAX_FILESIZE_JITTER_KEY = ConfigKey.DOUBLE("hbase.hregion.max.filesize.jitter", new Predicate[0]);

    public String toString() {
        return "ConstantSizeRegionSplitPolicy{desiredMaxFileSize=" + this.desiredMaxFileSize + ", jitterRate=" + this.jitterRate + '}';
    }

    @Override
    protected void configureForRegion(HRegion region) {
        super.configureForRegion(region);
        Configuration conf = this.getConf();
        TableDescriptor desc = region.getTableDescriptor();
        if (desc != null) {
            this.desiredMaxFileSize = desc.getMaxFileSize();
        }
        if (this.desiredMaxFileSize <= 0L) {
            this.desiredMaxFileSize = conf.getLong(HConstants.HREGION_MAX_FILESIZE, 0x280000000L);
        }
        this.overallHRegionFiles = conf.getBoolean("hbase.hregion.split.overallfiles", false);
        double jitter = conf.getDouble(MAX_FILESIZE_JITTER_KEY, 0.25);
        this.jitterRate = ((double)ThreadLocalRandom.current().nextFloat() - 0.5) * jitter;
        long jitterValue = (long)((double)this.desiredMaxFileSize * this.jitterRate);
        this.desiredMaxFileSize = this.jitterRate > 0.0 && jitterValue > Long.MAX_VALUE - this.desiredMaxFileSize ? Long.MAX_VALUE : (this.desiredMaxFileSize += jitterValue);
    }

    @Override
    protected boolean shouldSplit() {
        if (!this.canSplit()) {
            return false;
        }
        return this.isExceedSize(this.desiredMaxFileSize);
    }

    long getDesiredMaxFileSize() {
        return this.desiredMaxFileSize;
    }

    @InterfaceAudience.Private
    public boolean positiveJitterRate() {
        return this.jitterRate > 0.0;
    }

    protected final boolean isExceedSize(long sizeToCheck) {
        if (this.overallHRegionFiles) {
            long sumSize = 0L;
            for (HStore store : this.region.getStores()) {
                sumSize += store.getSize();
            }
            if (sumSize > sizeToCheck) {
                LOG.debug("Should split because region size is big enough sumSize={}, sizeToCheck={}", (Object)StringUtils.humanSize(sumSize), (Object)StringUtils.humanSize(sizeToCheck));
                return true;
            }
        } else {
            for (HStore store : this.region.getStores()) {
                long size = store.getSize();
                if (size <= sizeToCheck) continue;
                LOG.debug("Should split because {} size={}, sizeToCheck={}", new Object[]{store.getColumnFamilyName(), StringUtils.humanSize(size), StringUtils.humanSize(sizeToCheck)});
                return true;
            }
        }
        return false;
    }
}

