/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.CheckAndMutate;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterAllFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.testclassification.CoprocessorTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.tool.LoadIncrementalHFiles;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={CoprocessorTests.class, LargeTests.class})
public class TestRegionObserverInterface {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionObserverInterface.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRegionObserverInterface.class);
    public static final TableName TEST_TABLE = TableName.valueOf((String)"TestTable");
    public static final byte[] FAMILY = Bytes.toBytes((String)"f");
    public static final byte[] A = Bytes.toBytes((String)"a");
    public static final byte[] B = Bytes.toBytes((String)"b");
    public static final byte[] C = Bytes.toBytes((String)"c");
    public static final byte[] ROW = Bytes.toBytes((String)"testrow");
    private static HBaseTestingUtility util = new HBaseTestingUtility();
    private static MiniHBaseCluster cluster = null;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Configuration conf = util.getConfiguration();
        conf.setBoolean("hbase.master.distributed.log.replay", true);
        conf.setStrings("hbase.coprocessor.region.classes", new String[]{SimpleRegionObserver.class.getName()});
        util.startMiniCluster();
        cluster = util.getMiniHBaseCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        util.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegionObserver() throws IOException {
        TableName tableName = TableName.valueOf((String)(TEST_TABLE.getNameAsString() + "." + this.name.getMethodName()));
        Table table = util.createTable(tableName, (byte[][])new byte[][]{A, B, C});
        try {
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"hadPreGet", "hadPostGet", "hadPrePut", "hadPostPut", "hadDelete", "hadPostStartRegionOperation", "hadPostCloseRegionOperation", "hadPostBatchMutateIndispensably"}, tableName, new Boolean[]{false, false, false, false, false, false, false, false});
            Put put = new Put(ROW);
            put.addColumn(A, A, A);
            put.addColumn(B, B, B);
            put.addColumn(C, C, C);
            table.put(put);
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"hadPreGet", "hadPostGet", "hadPrePut", "hadPostPut", "hadPreBatchMutate", "hadPostBatchMutate", "hadDelete", "hadPostStartRegionOperation", "hadPostCloseRegionOperation", "hadPostBatchMutateIndispensably"}, TEST_TABLE, new Boolean[]{false, false, true, true, true, true, false, true, true, true});
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"getCtPreOpen", "getCtPostOpen", "getCtPreClose", "getCtPostClose"}, tableName, new Integer[]{1, 1, 0, 0});
            Get get = new Get(ROW);
            get.addColumn(A, A);
            get.addColumn(B, B);
            get.addColumn(C, C);
            table.get(get);
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"hadPreGet", "hadPostGet", "hadPrePut", "hadPostPut", "hadDelete", "hadPrePreparedDeleteTS"}, tableName, new Boolean[]{true, true, true, true, false, false});
            Delete delete = new Delete(ROW);
            delete.addColumn(A, A);
            delete.addColumn(B, B);
            delete.addColumn(C, C);
            table.delete(delete);
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"hadPreGet", "hadPostGet", "hadPrePut", "hadPostPut", "hadPreBatchMutate", "hadPostBatchMutate", "hadDelete", "hadPrePreparedDeleteTS"}, tableName, new Boolean[]{true, true, true, true, true, true, true, true});
        }
        finally {
            util.deleteTable(tableName);
            table.close();
        }
        this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"getCtPreOpen", "getCtPostOpen", "getCtPreClose", "getCtPostClose"}, tableName, new Integer[]{1, 1, 1, 1});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRowMutation() throws IOException {
        TableName tableName = TableName.valueOf((String)(TEST_TABLE.getNameAsString() + "." + this.name.getMethodName()));
        Table table = util.createTable(tableName, (byte[][])new byte[][]{A, B, C});
        try {
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"hadPreGet", "hadPostGet", "hadPrePut", "hadPostPut", "hadDeleted"}, tableName, new Boolean[]{false, false, false, false, false});
            Put put = new Put(ROW);
            put.addColumn(A, A, A);
            put.addColumn(B, B, B);
            put.addColumn(C, C, C);
            Delete delete = new Delete(ROW);
            delete.addColumn(A, A);
            delete.addColumn(B, B);
            delete.addColumn(C, C);
            RowMutations arm = new RowMutations(ROW);
            arm.add(put);
            arm.add(delete);
            table.mutateRow(arm);
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"hadPreGet", "hadPostGet", "hadPrePut", "hadPostPut", "hadDeleted"}, tableName, new Boolean[]{false, false, true, true, true});
        }
        finally {
            util.deleteTable(tableName);
            table.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncrementHook() throws IOException {
        TableName tableName = TableName.valueOf((String)(TEST_TABLE.getNameAsString() + "." + this.name.getMethodName()));
        Table table = util.createTable(tableName, (byte[][])new byte[][]{A, B, C});
        try {
            Increment inc = new Increment(Bytes.toBytes((int)0));
            inc.addColumn(A, A, 1L);
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"hadPreIncrement", "hadPostIncrement", "hadPreIncrementAfterRowLock", "hadPreBatchMutate", "hadPostBatchMutate", "hadPostBatchMutateIndispensably"}, tableName, new Boolean[]{false, false, false, false, false, false});
            table.increment(inc);
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"hadPreIncrement", "hadPostIncrement", "hadPreIncrementAfterRowLock", "hadPreBatchMutate", "hadPostBatchMutate", "hadPostBatchMutateIndispensably"}, tableName, new Boolean[]{true, true, true, true, true, true});
        }
        finally {
            util.deleteTable(tableName);
            table.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckAndPutHooks() throws IOException {
        TableName tableName = TableName.valueOf((String)(TEST_TABLE.getNameAsString() + "." + this.name.getMethodName()));
        try (Table table = util.createTable(tableName, (byte[][])new byte[][]{A, B, C});){
            Put p = new Put(Bytes.toBytes((int)0));
            p.addColumn(A, A, A);
            table.put(p);
            p = new Put(Bytes.toBytes((int)0));
            p.addColumn(A, A, A);
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"getPreCheckAndPut", "getPreCheckAndPutAfterRowLock", "getPostCheckAndPut", "getPreCheckAndPutWithFilter", "getPreCheckAndPutWithFilterAfterRowLock", "getPostCheckAndPutWithFilter", "getPreCheckAndMutate", "getPreCheckAndMutateAfterRowLock", "getPostCheckAndMutate"}, tableName, new Integer[]{0, 0, 0, 0, 0, 0, 0, 0, 0});
            table.checkAndMutate(Bytes.toBytes((int)0), A).qualifier(A).ifEquals(A).thenPut(p);
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"getPreCheckAndPut", "getPreCheckAndPutAfterRowLock", "getPostCheckAndPut", "getPreCheckAndPutWithFilter", "getPreCheckAndPutWithFilterAfterRowLock", "getPostCheckAndPutWithFilter", "getPreCheckAndMutate", "getPreCheckAndMutateAfterRowLock", "getPostCheckAndMutate"}, tableName, new Integer[]{1, 1, 1, 0, 0, 0, 1, 1, 1});
            table.checkAndMutate(Bytes.toBytes((int)0), (Filter)new SingleColumnValueFilter(A, A, CompareOperator.EQUAL, A)).thenPut(p);
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"getPreCheckAndPut", "getPreCheckAndPutAfterRowLock", "getPostCheckAndPut", "getPreCheckAndPutWithFilter", "getPreCheckAndPutWithFilterAfterRowLock", "getPostCheckAndPutWithFilter", "getPreCheckAndMutate", "getPreCheckAndMutateAfterRowLock", "getPostCheckAndMutate"}, tableName, new Integer[]{1, 1, 1, 1, 1, 1, 2, 2, 2});
        }
        finally {
            util.deleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckAndDeleteHooks() throws IOException {
        TableName tableName = TableName.valueOf((String)(TEST_TABLE.getNameAsString() + "." + this.name.getMethodName()));
        Table table = util.createTable(tableName, (byte[][])new byte[][]{A, B, C});
        try {
            Put p = new Put(Bytes.toBytes((int)0));
            p.addColumn(A, A, A);
            table.put(p);
            Delete d = new Delete(Bytes.toBytes((int)0));
            table.delete(d);
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"getPreCheckAndDelete", "getPreCheckAndDeleteAfterRowLock", "getPostCheckAndDelete", "getPreCheckAndDeleteWithFilter", "getPreCheckAndDeleteWithFilterAfterRowLock", "getPostCheckAndDeleteWithFilter", "getPreCheckAndMutate", "getPreCheckAndMutateAfterRowLock", "getPostCheckAndMutate"}, tableName, new Integer[]{0, 0, 0, 0, 0, 0, 0, 0, 0});
            table.checkAndMutate(Bytes.toBytes((int)0), A).qualifier(A).ifEquals(A).thenDelete(d);
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"getPreCheckAndDelete", "getPreCheckAndDeleteAfterRowLock", "getPostCheckAndDelete", "getPreCheckAndDeleteWithFilter", "getPreCheckAndDeleteWithFilterAfterRowLock", "getPostCheckAndDeleteWithFilter", "getPreCheckAndMutate", "getPreCheckAndMutateAfterRowLock", "getPostCheckAndMutate"}, tableName, new Integer[]{1, 1, 1, 0, 0, 0, 1, 1, 1});
            table.checkAndMutate(Bytes.toBytes((int)0), (Filter)new SingleColumnValueFilter(A, A, CompareOperator.EQUAL, A)).thenDelete(d);
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"getPreCheckAndDelete", "getPreCheckAndDeleteAfterRowLock", "getPostCheckAndDelete", "getPreCheckAndDeleteWithFilter", "getPreCheckAndDeleteWithFilterAfterRowLock", "getPostCheckAndDeleteWithFilter", "getPreCheckAndMutate", "getPreCheckAndMutateAfterRowLock", "getPostCheckAndMutate"}, tableName, new Integer[]{1, 1, 1, 1, 1, 1, 2, 2, 2});
        }
        finally {
            util.deleteTable(tableName);
            table.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckAndIncrementHooks() throws Exception {
        TableName tableName = TableName.valueOf((String)(TEST_TABLE.getNameAsString() + "." + this.name.getMethodName()));
        Table table = util.createTable(tableName, (byte[][])new byte[][]{A, B, C});
        try {
            byte[] row = Bytes.toBytes((int)0);
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"getPreCheckAndMutate", "getPreCheckAndMutateAfterRowLock", "getPostCheckAndMutate"}, tableName, new Integer[]{0, 0, 0});
            table.checkAndMutate(CheckAndMutate.newBuilder((byte[])row).ifNotExists(A, A).build(new Increment(row).addColumn(A, A, 1L)));
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"getPreCheckAndMutate", "getPreCheckAndMutateAfterRowLock", "getPostCheckAndMutate"}, tableName, new Integer[]{1, 1, 1});
            table.checkAndMutate(CheckAndMutate.newBuilder((byte[])row).ifEquals(A, A, Bytes.toBytes((long)1L)).build(new Increment(row).addColumn(A, A, 1L)));
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"getPreCheckAndMutate", "getPreCheckAndMutateAfterRowLock", "getPostCheckAndMutate"}, tableName, new Integer[]{2, 2, 2});
        }
        finally {
            util.deleteTable(tableName);
            table.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckAndAppendHooks() throws Exception {
        TableName tableName = TableName.valueOf((String)(TEST_TABLE.getNameAsString() + "." + this.name.getMethodName()));
        Table table = util.createTable(tableName, (byte[][])new byte[][]{A, B, C});
        try {
            byte[] row = Bytes.toBytes((int)0);
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"getPreCheckAndMutate", "getPreCheckAndMutateAfterRowLock", "getPostCheckAndMutate"}, tableName, new Integer[]{0, 0, 0});
            table.checkAndMutate(CheckAndMutate.newBuilder((byte[])row).ifNotExists(A, A).build(new Append(row).addColumn(A, A, A)));
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"getPreCheckAndMutate", "getPreCheckAndMutateAfterRowLock", "getPostCheckAndMutate"}, tableName, new Integer[]{1, 1, 1});
            table.checkAndMutate(CheckAndMutate.newBuilder((byte[])row).ifEquals(A, A, A).build(new Append(row).addColumn(A, A, A)));
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"getPreCheckAndMutate", "getPreCheckAndMutateAfterRowLock", "getPostCheckAndMutate"}, tableName, new Integer[]{2, 2, 2});
        }
        finally {
            util.deleteTable(tableName);
            table.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckAndRowMutationsHooks() throws Exception {
        TableName tableName = TableName.valueOf((String)(TEST_TABLE.getNameAsString() + "." + this.name.getMethodName()));
        Table table = util.createTable(tableName, (byte[][])new byte[][]{A, B, C});
        try {
            byte[] row = Bytes.toBytes((int)0);
            Put p = new Put(row).addColumn(A, A, A);
            table.put(p);
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"getPreCheckAndMutate", "getPreCheckAndMutateAfterRowLock", "getPostCheckAndMutate"}, tableName, new Integer[]{0, 0, 0});
            table.checkAndMutate(CheckAndMutate.newBuilder((byte[])row).ifEquals(A, A, A).build(new RowMutations(row).add((Mutation)new Put(row).addColumn(B, B, B)).add((Mutation)new Delete(row))));
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"getPreCheckAndMutate", "getPreCheckAndMutateAfterRowLock", "getPostCheckAndMutate"}, tableName, new Integer[]{1, 1, 1});
            Object[] result = new Object[2];
            table.batch(Arrays.asList(p, CheckAndMutate.newBuilder((byte[])row).ifEquals(A, A, A).build(new RowMutations(row).add((Mutation)new Put(row).addColumn(B, B, B)).add((Mutation)new Delete(row)))), result);
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"getPreCheckAndMutate", "getPreCheckAndMutateAfterRowLock", "getPostCheckAndMutate"}, tableName, new Integer[]{2, 2, 2});
        }
        finally {
            util.deleteTable(tableName);
            table.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppendHook() throws IOException {
        TableName tableName = TableName.valueOf((String)(TEST_TABLE.getNameAsString() + "." + this.name.getMethodName()));
        Table table = util.createTable(tableName, (byte[][])new byte[][]{A, B, C});
        try {
            Append app = new Append(Bytes.toBytes((int)0));
            app.addColumn(A, A, A);
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"hadPreAppend", "hadPostAppend", "hadPreAppendAfterRowLock", "hadPreBatchMutate", "hadPostBatchMutate", "hadPostBatchMutateIndispensably"}, tableName, new Boolean[]{false, false, false, false, false, false});
            table.append(app);
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"hadPreAppend", "hadPostAppend", "hadPreAppendAfterRowLock", "hadPreBatchMutate", "hadPostBatchMutate", "hadPostBatchMutateIndispensably"}, tableName, new Boolean[]{true, true, true, true, true, true});
        }
        finally {
            util.deleteTable(tableName);
            table.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHBase3583() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        util.createTable(tableName, (byte[][])new byte[][]{A, B, C});
        util.waitUntilAllRegionsAssigned(tableName);
        this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"hadPreGet", "hadPostGet", "wasScannerNextCalled", "wasScannerCloseCalled"}, tableName, new Boolean[]{false, false, false, false});
        Table table = util.getConnection().getTable(tableName);
        Put put = new Put(ROW);
        put.addColumn(A, A, A);
        table.put(put);
        Get get = new Get(ROW);
        get.addColumn(A, A);
        table.get(get);
        this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"hadPreGet", "hadPostGet", "wasScannerNextCalled", "wasScannerCloseCalled"}, tableName, new Boolean[]{true, true, false, false});
        Scan s = new Scan();
        try (ResultScanner scanner = table.getScanner(s);){
            Result rr = scanner.next();
            while (rr != null) {
                rr = scanner.next();
            }
        }
        this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"wasScannerNextCalled", "wasScannerCloseCalled"}, tableName, new Boolean[]{true, true});
        util.deleteTable(tableName);
        table.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHBASE14489() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table table = util.createTable(tableName, (byte[][])new byte[][]{A});
        Put put = new Put(ROW);
        put.addColumn(A, A, A);
        table.put(put);
        Scan s = new Scan();
        s.setFilter((Filter)new FilterAllFilter());
        try (ResultScanner scanner = table.getScanner(s);){
            Result rr = scanner.next();
            while (rr != null) {
                rr = scanner.next();
            }
        }
        this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"wasScannerFilterRowCalled"}, tableName, new Boolean[]{true});
        util.deleteTable(tableName);
        table.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHBase3758() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        util.createTable(tableName, (byte[][])new byte[][]{A, B, C});
        this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"hadDeleted", "wasScannerOpenCalled"}, tableName, new Boolean[]{false, false});
        Table table = util.getConnection().getTable(tableName);
        Put put = new Put(ROW);
        put.addColumn(A, A, A);
        table.put(put);
        Delete delete = new Delete(ROW);
        table.delete(delete);
        this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"hadDeleted", "wasScannerOpenCalled"}, tableName, new Boolean[]{true, false});
        Scan s = new Scan();
        try (ResultScanner scanner = table.getScanner(s);){
            Result rr = scanner.next();
            while (rr != null) {
                rr = scanner.next();
            }
        }
        this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"wasScannerOpenCalled"}, tableName, new Boolean[]{true});
        util.deleteTable(tableName);
        table.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompactionOverride() throws Exception {
        int i;
        TableName compactTable = TableName.valueOf((String)this.name.getMethodName());
        Admin admin = util.getAdmin();
        if (admin.tableExists(compactTable)) {
            admin.disableTable(compactTable);
            admin.deleteTable(compactTable);
        }
        HTableDescriptor htd = new HTableDescriptor(compactTable);
        htd.addFamily(new HColumnDescriptor(A));
        htd.addCoprocessor(EvenOnlyCompactor.class.getName());
        admin.createTable((TableDescriptor)htd);
        Table table = util.getConnection().getTable(compactTable);
        for (long i2 = 1L; i2 <= 10L; ++i2) {
            byte[] iBytes = Bytes.toBytes((long)i2);
            Put put = new Put(iBytes);
            put.setDurability(Durability.SKIP_WAL);
            put.addColumn(A, A, iBytes);
            table.put(put);
        }
        HRegion firstRegion = cluster.getRegions(compactTable).get(0);
        Coprocessor cp = firstRegion.getCoprocessorHost().findCoprocessor(EvenOnlyCompactor.class);
        Assert.assertNotNull((String)"EvenOnlyCompactor coprocessor should be loaded", (Object)cp);
        EvenOnlyCompactor compactor = (EvenOnlyCompactor)cp;
        long ts = EnvironmentEdgeManager.currentTime();
        admin.flush(compactTable);
        for (i = 0; i < 10 && compactor.lastFlush < ts; ++i) {
            Thread.sleep(1000L);
        }
        Assert.assertTrue((String)"Flush didn't complete", (compactor.lastFlush >= ts ? 1 : 0) != 0);
        LOG.debug("Flush complete");
        ts = compactor.lastFlush;
        admin.majorCompact(compactTable);
        for (i = 0; i < 30 && compactor.lastCompaction < ts; ++i) {
            Thread.sleep(1000L);
        }
        LOG.debug("Last compaction was at " + compactor.lastCompaction);
        Assert.assertTrue((String)"Compaction didn't complete", (compactor.lastCompaction >= ts ? 1 : 0) != 0);
        try (ResultScanner scanner = table.getScanner(new Scan());){
            for (long i3 = 2L; i3 <= 10L; i3 += 2L) {
                Result r = scanner.next();
                Assert.assertNotNull((Object)r);
                Assert.assertFalse((boolean)r.isEmpty());
                byte[] iBytes = Bytes.toBytes((long)i3);
                Assert.assertArrayEquals((String)("Row should be " + i3), (byte[])r.getRow(), (byte[])iBytes);
                Assert.assertArrayEquals((String)("Value should be " + i3), (byte[])r.getValue(A, A), (byte[])iBytes);
            }
        }
        table.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void bulkLoadHFileTest() throws Exception {
        String testName = TestRegionObserverInterface.class.getName() + "." + this.name.getMethodName();
        TableName tableName = TableName.valueOf((String)(TEST_TABLE.getNameAsString() + "." + this.name.getMethodName()));
        Configuration conf = util.getConfiguration();
        Table table = util.createTable(tableName, (byte[][])new byte[][]{A, B, C});
        try (RegionLocator locator = util.getConnection().getRegionLocator(tableName);){
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"hadPreBulkLoadHFile", "hadPostBulkLoadHFile"}, tableName, new Boolean[]{false, false});
            FileSystem fs = util.getTestFileSystem();
            Path dir = util.getDataTestDirOnTestFS(testName).makeQualified(fs);
            Path familyDir = new Path(dir, Bytes.toString((byte[])A));
            TestRegionObserverInterface.createHFile(util.getConfiguration(), fs, new Path(familyDir, Bytes.toString((byte[])A)), A, A);
            new LoadIncrementalHFiles(conf).doBulkLoad(dir, util.getAdmin(), table, locator);
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"hadPreBulkLoadHFile", "hadPostBulkLoadHFile"}, tableName, new Boolean[]{true, true});
        }
        finally {
            util.deleteTable(tableName);
            table.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecovery() throws Exception {
        LOG.info(TestRegionObserverInterface.class.getName() + "." + this.name.getMethodName());
        TableName tableName = TableName.valueOf((String)(TEST_TABLE.getNameAsString() + "." + this.name.getMethodName()));
        Table table = util.createTable(tableName, (byte[][])new byte[][]{A, B, C});
        try (RegionLocator locator = util.getConnection().getRegionLocator(tableName);){
            JVMClusterUtil.RegionServerThread rs1 = cluster.startRegionServer();
            ServerName sn2 = rs1.getRegionServer().getServerName();
            String regEN = ((HRegionLocation)locator.getAllRegionLocations().get(0)).getRegionInfo().getEncodedName();
            util.getAdmin().move(Bytes.toBytes((String)regEN), sn2);
            while (!sn2.equals((Object)((HRegionLocation)locator.getAllRegionLocations().get(0)).getServerName())) {
                Thread.sleep(100L);
            }
            Put put = new Put(ROW);
            put.addColumn(A, A, A);
            put.addColumn(B, B, B);
            put.addColumn(C, C, C);
            table.put(put);
            table.put(put);
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"hadPreGet", "hadPostGet", "hadPrePut", "hadPostPut", "hadPreBatchMutate", "hadPostBatchMutate", "hadDelete"}, tableName, new Boolean[]{false, false, true, true, true, true, false});
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"getCtPreReplayWALs", "getCtPostReplayWALs", "getCtPreWALRestore", "getCtPostWALRestore", "getCtPrePut", "getCtPostPut"}, tableName, new Integer[]{0, 0, 0, 0, 2, 2});
            cluster.killRegionServer(rs1.getRegionServer().getServerName());
            Threads.sleep((long)1000L);
            util.waitUntilAllRegionsAssigned(tableName);
            LOG.info("All regions assigned");
            this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"getCtPreReplayWALs", "getCtPostReplayWALs", "getCtPreWALRestore", "getCtPostWALRestore", "getCtPrePut", "getCtPostPut"}, tableName, new Integer[]{1, 1, 2, 2, 0, 0});
        }
        finally {
            util.deleteTable(tableName);
            table.close();
        }
    }

    @Test
    public void testPreWALRestoreSkip() throws Exception {
        LOG.info(TestRegionObserverInterface.class.getName() + "." + this.name.getMethodName());
        TableName tableName = TableName.valueOf((String)"SKIPPED_BY_PREWALRESTORE");
        Table table = util.createTable(tableName, (byte[][])new byte[][]{A, B, C});
        try (RegionLocator locator = util.getConnection().getRegionLocator(tableName);){
            JVMClusterUtil.RegionServerThread rs1 = cluster.startRegionServer();
            ServerName sn2 = rs1.getRegionServer().getServerName();
            String regEN = ((HRegionLocation)locator.getAllRegionLocations().get(0)).getRegionInfo().getEncodedName();
            util.getAdmin().move(Bytes.toBytes((String)regEN), sn2);
            while (!sn2.equals((Object)((HRegionLocation)locator.getAllRegionLocations().get(0)).getServerName())) {
                Thread.sleep(100L);
            }
            Put put = new Put(ROW);
            put.addColumn(A, A, A);
            put.addColumn(B, B, B);
            put.addColumn(C, C, C);
            table.put(put);
            cluster.killRegionServer(rs1.getRegionServer().getServerName());
            Threads.sleep((long)20000L);
            util.waitUntilAllRegionsAssigned(tableName);
        }
        this.verifyMethodResult(SimpleRegionObserver.class, new String[]{"getCtPreWALRestore", "getCtPostWALRestore"}, tableName, new Integer[]{0, 0});
        util.deleteTable(tableName);
        table.close();
    }

    private void testPreWALAppendHook(Table table, TableName tableName) throws IOException {
        int expectedCalls = 0;
        String[] methodArray = new String[]{"getCtPreWALAppend"};
        Object[] resultArray = new Object[1];
        Put p = new Put(ROW);
        p.addColumn(A, A, A);
        table.put(p);
        resultArray[0] = ++expectedCalls;
        this.verifyMethodResult(SimpleRegionObserver.class, methodArray, tableName, resultArray);
        Append a = new Append(ROW);
        a.addColumn(B, B, B);
        table.append(a);
        resultArray[0] = ++expectedCalls;
        this.verifyMethodResult(SimpleRegionObserver.class, methodArray, tableName, resultArray);
        Increment i = new Increment(ROW);
        i.addColumn(C, C, 1L);
        table.increment(i);
        resultArray[0] = ++expectedCalls;
        this.verifyMethodResult(SimpleRegionObserver.class, methodArray, tableName, resultArray);
        Delete d = new Delete(ROW);
        table.delete(d);
        resultArray[0] = ++expectedCalls;
        this.verifyMethodResult(SimpleRegionObserver.class, methodArray, tableName, resultArray);
    }

    @Test
    public void testPreWALAppend() throws Exception {
        SimpleRegionObserver sro = new SimpleRegionObserver();
        ObserverContext ctx = (ObserverContext)Mockito.mock(ObserverContext.class);
        WALKeyImpl key = new WALKeyImpl(Bytes.toBytes((String)"region"), TEST_TABLE, EnvironmentEdgeManager.currentTime());
        WALEdit edit = new WALEdit();
        sro.preWALAppend((ObserverContext<RegionCoprocessorEnvironment>)ctx, (WALKey)key, edit);
        Assert.assertEquals((long)1L, (long)key.getExtendedAttributes().size());
        Assert.assertArrayEquals((byte[])SimpleRegionObserver.WAL_EXTENDED_ATTRIBUTE_BYTES, (byte[])key.getExtendedAttribute(Integer.toString(sro.getCtPreWALAppend())));
    }

    @Test
    public void testPreWALAppendIsWrittenToWAL() throws Exception {
        TableName tableName = TableName.valueOf((String)(TEST_TABLE.getNameAsString() + "." + this.name.getMethodName()));
        Table table = util.createTable(tableName, (byte[][])new byte[][]{A, B, C});
        PreWALAppendWALActionsListener listener = new PreWALAppendWALActionsListener();
        List<HRegion> regions = util.getHBaseCluster().getRegions(tableName);
        HRegion region = regions.get(0);
        region.getWAL().registerWALActionsListener((WALActionsListener)listener);
        this.testPreWALAppendHook(table, tableName);
        boolean[] expectedResults = new boolean[]{true, true, true, true};
        Assert.assertArrayEquals((boolean[])expectedResults, (boolean[])listener.getWalKeysCorrectArray());
    }

    @Test
    public void testPreWALAppendNotCalledOnMetaEdit() throws Exception {
        TableName tableName = TableName.valueOf((String)(TEST_TABLE.getNameAsString() + "." + this.name.getMethodName()));
        TableDescriptorBuilder tdBuilder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        ColumnFamilyDescriptorBuilder cfBuilder = ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY);
        tdBuilder.setColumnFamily(cfBuilder.build());
        tdBuilder.setCoprocessor(SimpleRegionObserver.class.getName());
        TableDescriptor td = tdBuilder.build();
        Table table = util.createTable(td, (byte[][])new byte[][]{A, B, C});
        PreWALAppendWALActionsListener listener = new PreWALAppendWALActionsListener();
        List<HRegion> regions = util.getHBaseCluster().getRegions(tableName);
        HRegion region = regions.get(0);
        region.getWAL().registerWALActionsListener((WALActionsListener)listener);
        region.flush(true);
        region.compact(false);
        region.close();
        String[] methods = new String[]{"getCtPreWALAppend"};
        Object[] expectedResult = new Integer[]{0};
        this.verifyMethodResult(SimpleRegionObserver.class, methods, tableName, expectedResult);
    }

    private void verifyMethodResult(Class<?> coprocessor, String[] methodName, TableName tableName, Object[] value) throws IOException {
        try {
            for (JVMClusterUtil.RegionServerThread t : cluster.getRegionServerThreads()) {
                if (!t.isAlive() || t.getRegionServer().isAborted() || t.getRegionServer().isStopping()) continue;
                for (RegionInfo r : ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)t.getRegionServer().getRSRpcServices())) {
                    if (!r.getTable().equals((Object)tableName)) continue;
                    RegionCoprocessorHost cph = t.getRegionServer().getOnlineRegion(r.getRegionName()).getCoprocessorHost();
                    Coprocessor cp = cph.findCoprocessor(coprocessor.getName());
                    Assert.assertNotNull((Object)cp);
                    for (int i = 0; i < methodName.length; ++i) {
                        Method m = coprocessor.getMethod(methodName[i], new Class[0]);
                        Object o = m.invoke((Object)cp, new Object[0]);
                        Assert.assertTrue((String)("Result of " + coprocessor.getName() + "." + methodName[i] + " is expected to be " + value[i].toString() + ", while we get " + o.toString()), (boolean)o.equals(value[i]));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createHFile(Configuration conf, FileSystem fs, Path path, byte[] family, byte[] qualifier) throws IOException {
        HFileContext context = new HFileContextBuilder().build();
        long now = EnvironmentEdgeManager.currentTime();
        try (HFile.Writer writer = HFile.getWriterFactory((Configuration)conf, (CacheConfig)new CacheConfig(conf)).withPath(fs, path).withFileContext(context).create();){
            for (int i = 1; i <= 9; ++i) {
                KeyValue kv = new KeyValue(Bytes.toBytes((String)(i + "")), family, qualifier, now, Bytes.toBytes((String)(i + "")));
                writer.append((Cell)kv);
            }
        }
    }

    private static class PreWALAppendWALActionsListener
    implements WALActionsListener {
        boolean[] walKeysCorrect = new boolean[]{false, false, false, false};

        private PreWALAppendWALActionsListener() {
        }

        public void postAppend(long entryLen, long elapsedTimeMillis, WALKey logKey, WALEdit logEdit) throws IOException {
            for (int k = 0; k < 4; ++k) {
                if (this.walKeysCorrect[k]) continue;
                this.walKeysCorrect[k] = Arrays.equals(SimpleRegionObserver.WAL_EXTENDED_ATTRIBUTE_BYTES, logKey.getExtendedAttribute(Integer.toString(k + 1)));
            }
        }

        boolean[] getWalKeysCorrectArray() {
            return this.walKeysCorrect;
        }
    }

    public static class EvenOnlyCompactor
    implements RegionCoprocessor,
    RegionObserver {
        long lastCompaction;
        long lastFlush;

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public InternalScanner preCompact(ObserverContext<RegionCoprocessorEnvironment> e, Store store, final InternalScanner scanner, ScanType scanType, CompactionLifeCycleTracker tracker, CompactionRequest request) {
            return new InternalScanner(){

                public boolean next(List<Cell> results, ScannerContext scannerContext) throws IOException {
                    boolean hasMore;
                    ArrayList internalResults = new ArrayList();
                    do {
                        hasMore = scanner.next(internalResults, scannerContext);
                        if (internalResults.isEmpty()) continue;
                        long row = Bytes.toLong((byte[])CellUtil.cloneValue((Cell)((Cell)internalResults.get(0))));
                        if (row % 2L == 0L) break;
                        internalResults.clear();
                    } while (hasMore);
                    if (!internalResults.isEmpty()) {
                        results.addAll(internalResults);
                    }
                    return hasMore;
                }

                public void close() throws IOException {
                    scanner.close();
                }
            };
        }

        public void postCompact(ObserverContext<RegionCoprocessorEnvironment> e, Store store, StoreFile resultFile, CompactionLifeCycleTracker tracker, CompactionRequest request) {
            this.lastCompaction = EnvironmentEdgeManager.currentTime();
        }

        public void postFlush(ObserverContext<RegionCoprocessorEnvironment> e, FlushLifeCycleTracker tracker) {
            this.lastFlush = EnvironmentEdgeManager.currentTime();
        }
    }
}

