/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.compress.xz;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.io.ByteBufferInputStream;
import org.apache.hadoop.hbase.io.compress.CompressionUtil;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.yetus.audience.InterfaceAudience;
import org.tukaani.xz.ArrayCache;
import org.tukaani.xz.BasicArrayCache;
import org.tukaani.xz.LZMAInputStream;

@InterfaceAudience.Private
public class LzmaDecompressor
implements Decompressor {
    protected static final ArrayCache ARRAY_CACHE = new BasicArrayCache(){

        public byte[] getByteArray(int size, boolean fillWithZeros) {
            return super.getByteArray(size, true);
        }
    };
    protected ByteBuffer inBuf;
    protected ByteBuffer outBuf;
    protected int inLen;
    protected boolean finished;

    LzmaDecompressor(int bufferSize) {
        this.inBuf = ByteBuffer.allocate(bufferSize);
        this.outBuf = ByteBuffer.allocate(bufferSize);
        this.outBuf.position(bufferSize);
    }

    public int decompress(byte[] b, int off, int len) throws IOException {
        if (this.outBuf.hasRemaining()) {
            int remaining = this.outBuf.remaining();
            int n = Math.min(remaining, len);
            this.outBuf.get(b, off, n);
            return n;
        }
        if (this.inBuf.position() > 0) {
            this.inBuf.flip();
            int remaining = this.inBuf.remaining();
            this.inLen -= remaining;
            this.outBuf.clear();
            try (ByteBufferInputStream lowerIn = new ByteBufferInputStream(this.inBuf);){
                byte[] buf = new byte[8192];
                try (LZMAInputStream in = new LZMAInputStream((InputStream)lowerIn, ARRAY_CACHE);){
                    int read;
                    do {
                        if ((read = in.read(buf)) <= 0) continue;
                        this.outBuf.put(buf, 0, read);
                    } while (read > 0);
                }
            }
            int written = this.outBuf.position();
            this.outBuf.flip();
            this.inBuf.clear();
            int n = Math.min(written, len);
            this.outBuf.get(b, off, n);
            return n;
        }
        this.finished = true;
        return 0;
    }

    public void end() {
    }

    public boolean finished() {
        return this.finished;
    }

    public int getRemaining() {
        return this.inLen;
    }

    public boolean needsDictionary() {
        return false;
    }

    public void reset() {
        this.inBuf.clear();
        this.inLen = 0;
        this.outBuf.clear();
        this.outBuf.position(this.outBuf.capacity());
        this.finished = false;
    }

    public boolean needsInput() {
        return this.inBuf.position() == 0;
    }

    public void setDictionary(byte[] b, int off, int len) {
        throw new UnsupportedOperationException("setDictionary is not supported");
    }

    public void setInput(byte[] b, int off, int len) {
        if (this.inBuf.remaining() < len) {
            int needed = CompressionUtil.roundInt2((int)(this.inBuf.capacity() + len));
            ByteBuffer newBuf = ByteBuffer.allocate(needed);
            this.inBuf.flip();
            newBuf.put(this.inBuf);
            this.inBuf = newBuf;
        }
        this.inBuf.put(b, off, len);
        this.inLen += len;
        this.finished = false;
    }
}

