/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import com.google.errorprone.annotations.RestrictedApi;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MobFileCompactionChore
extends ScheduledChore {
    private static final Logger LOG = LoggerFactory.getLogger(MobFileCompactionChore.class);
    private HMaster master;
    private int regionBatchSize = 0;

    public MobFileCompactionChore(HMaster master) {
        super(master.getServerName() + "-MobFileCompactionChore", (Stoppable)master, master.getConfiguration().getInt("hbase.mob.compaction.chore.period", 604800), (long)master.getConfiguration().getInt("hbase.mob.compaction.chore.period", 604800), TimeUnit.SECONDS);
        this.master = master;
        this.regionBatchSize = master.getConfiguration().getInt("hbase.mob.major.compaction.region.batch.size", 0);
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*")
    public MobFileCompactionChore(Configuration conf, int batchSize) {
        this.regionBatchSize = batchSize;
    }

    protected void chore() {
        boolean reported = false;
        try (Admin admin = this.master.getConnection().getAdmin();){
            TableDescriptors htds = this.master.getTableDescriptors();
            Map<String, TableDescriptor> map = htds.getAll();
            for (TableDescriptor htd : map.values()) {
                if (!this.master.getTableStateManager().isTableState(htd.getTableName(), TableState.State.ENABLED)) {
                    LOG.info("Skipping MOB compaction on table {} because it is not ENABLED", (Object)htd.getTableName());
                    continue;
                }
                LOG.info("Starting MOB compaction on table {}, checking {} column families", (Object)htd.getTableName(), (Object)htd.getColumnFamilyCount());
                for (ColumnFamilyDescriptor hcd : htd.getColumnFamilies()) {
                    try {
                        if (hcd.isMobEnabled()) {
                            if (!reported) {
                                this.master.reportMobCompactionStart(htd.getTableName());
                                reported = true;
                            }
                            LOG.info("Major MOB compacting table={} cf={}", (Object)htd.getTableName(), (Object)hcd.getNameAsString());
                            if (this.regionBatchSize == 0) {
                                LOG.debug("Table={} cf ={}: batch MOB compaction is disabled, {}=0 - all regions will be compacted in parallel", new Object[]{htd.getTableName(), hcd.getNameAsString(), "hbase.mob.compaction.batch.size"});
                                admin.majorCompact(htd.getTableName(), hcd.getName());
                                continue;
                            }
                            LOG.info("Table={} cf={}: performing MOB major compaction in batches 'hbase.mob.compaction.batch.size'={}", new Object[]{htd.getTableName(), hcd.getNameAsString(), this.regionBatchSize});
                            this.performMajorCompactionInBatches(admin, htd, hcd);
                            continue;
                        }
                        LOG.debug("Skipping table={} column family={} because it is not MOB-enabled", (Object)htd.getTableName(), (Object)hcd.getNameAsString());
                    }
                    catch (IOException e) {
                        LOG.error("Failed to compact table={} cf={}", new Object[]{htd.getTableName(), hcd.getNameAsString(), e});
                    }
                    catch (InterruptedException ee) {
                        Thread.currentThread().interrupt();
                        this.master.reportMobCompactionEnd(htd.getTableName());
                        LOG.warn("Failed to compact table={} cf={}", new Object[]{htd.getTableName(), hcd.getNameAsString(), ee});
                        if (admin != null) {
                            if (var3_4 != null) {
                                try {
                                    admin.close();
                                }
                                catch (Throwable throwable) {
                                    var3_4.addSuppressed(throwable);
                                }
                            } else {
                                admin.close();
                            }
                        }
                        return;
                    }
                }
                if (!reported) continue;
                this.master.reportMobCompactionEnd(htd.getTableName());
                reported = false;
            }
        }
        catch (IOException e) {
            LOG.error("Failed to compact", (Throwable)e);
        }
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*(/src/test/.*|MobFileCompactionChore).java")
    public void performMajorCompactionInBatches(Admin admin, TableDescriptor htd, ColumnFamilyDescriptor hcd) throws IOException, InterruptedException {
        List regions = admin.getRegions(htd.getTableName());
        if (regions.size() <= this.regionBatchSize) {
            LOG.debug("Table={} cf={} - performing major MOB compaction in non-batched mode,regions={}, batch size={}", new Object[]{htd.getTableName(), hcd.getNameAsString(), regions.size(), this.regionBatchSize});
            admin.majorCompact(htd.getTableName(), hcd.getName());
            return;
        }
        Collections.shuffle(regions);
        ArrayList toCompact = new ArrayList(this.regionBatchSize);
        for (int i = 0; i < this.regionBatchSize; ++i) {
            toCompact.add(regions.remove(0));
        }
        for (RegionInfo ri : toCompact) {
            this.startCompaction(admin, htd.getTableName(), ri, hcd.getName());
        }
        ArrayList<RegionInfo> compacted = new ArrayList<RegionInfo>(toCompact.size());
        ArrayList<RegionInfo> failed = new ArrayList<RegionInfo>();
        int totalCompacted = 0;
        while (!toCompact.isEmpty()) {
            for (RegionInfo ri : toCompact) {
                try {
                    if (admin.getCompactionStateForRegion(ri.getRegionName()) != CompactionState.NONE) continue;
                    LOG.info("Finished major MOB compaction: table={} cf={} region={} compacted regions={}", new Object[]{htd.getTableName(), hcd.getNameAsString(), ri.getRegionNameAsString(), ++totalCompacted});
                    compacted.add(ri);
                }
                catch (IOException e) {
                    LOG.error("Could not get compaction state for table={} cf={} region={}, compaction will aborted for the region.", new Object[]{htd.getTableName(), hcd.getNameAsString(), ri.getEncodedName()});
                    LOG.error("Because of:", (Throwable)e);
                    failed.add(ri);
                }
            }
            toCompact.removeAll(failed);
            failed.clear();
            for (RegionInfo ri : compacted) {
                toCompact.remove(ri);
                if (regions.size() <= 0) continue;
                RegionInfo region = (RegionInfo)regions.remove(0);
                toCompact.add(region);
                this.startCompaction(admin, htd.getTableName(), region, hcd.getName());
            }
            compacted.clear();
            LOG.debug("Table={}  cf={}. Wait for 10 sec, toCompact size={} regions left={} compacted so far={}", new Object[]{htd.getTableName(), hcd.getNameAsString(), toCompact.size(), regions.size(), totalCompacted});
            Thread.sleep(10000L);
        }
        LOG.info("Finished major MOB compacting table={}. cf={}", (Object)htd.getTableName(), (Object)hcd.getNameAsString());
    }

    private void startCompaction(Admin admin, TableName table, RegionInfo region, byte[] cf) throws IOException, InterruptedException {
        LOG.info("Started major compaction: table={} cf={} region={}", new Object[]{table, Bytes.toString((byte[])cf), region.getRegionNameAsString()});
        admin.majorCompactRegion(region.getRegionName(), cf);
        long waitTime = 300000L;
        long startTime = EnvironmentEdgeManager.currentTime();
        while (admin.getCompactionStateForRegion(region.getRegionName()) == CompactionState.NONE) {
            Thread.sleep(1000L);
            if (EnvironmentEdgeManager.currentTime() - startTime <= waitTime) continue;
            LOG.warn("Waited for {} ms to start major MOB compaction on table={} cf={} region={}. Stopped waiting for request confirmation. This is not an ERROR, continue next region.", new Object[]{waitTime, table.getNameAsString(), Bytes.toString((byte[])cf), region.getRegionNameAsString()});
            break;
        }
    }
}

