/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.type;

import com.thoughtworks.qdox.library.ClassLibrary;
import com.thoughtworks.qdox.model.JavaClass;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TypeResolver {
    private static final Set<String> PRIMITIVE_TYPES = new HashSet<String>();
    private final Map<String, String> resolvedTypeCache = new HashMap<String, String>();
    private final String pckg;
    private final String declaringClass;
    private final ClassLibrary classLibrary;
    private final Collection<String> imports;

    private TypeResolver(String pckg, String declaringClass, ClassLibrary classLibrary, Collection<String> imports) {
        this.pckg = pckg;
        this.declaringClass = declaringClass;
        this.classLibrary = classLibrary;
        this.imports = imports != null ? imports : Collections.emptyList();
    }

    public static TypeResolver byPackageName(String binaryName, ClassLibrary classLibrary, Collection<String> imports) {
        return new TypeResolver(binaryName, null, classLibrary, imports);
    }

    public static TypeResolver byClassName(String binaryName, ClassLibrary classLibrary, Collection<String> imports) {
        int dotIndex = binaryName.lastIndexOf(46);
        String pckg = dotIndex > 0 ? binaryName.substring(0, dotIndex) : null;
        return new TypeResolver(pckg, binaryName, classLibrary, imports);
    }

    public JavaClass resolveJavaClass(String typeName) {
        return this.classLibrary.getJavaClass(this.resolveType(typeName));
    }

    public JavaClass getJavaClass(String binaryName) {
        return this.classLibrary.getJavaClass(binaryName);
    }

    public String resolveType(String typeName) {
        String result = this.resolvedTypeCache.get(typeName);
        if (result == null) {
            if (this.declaringClass != null) {
                int dollarIndex = this.declaringClass.indexOf(36);
                while (result == null && dollarIndex > 0) {
                    String subType = this.declaringClass.substring(0, dollarIndex + 1) + typeName;
                    result = this.resolveFromLibrary(subType);
                    dollarIndex = this.declaringClass.indexOf(36, dollarIndex + 1);
                }
                if (result == null) {
                    String nestedBinaryName = this.declaringClass + '$' + typeName.replace('.', '$');
                    result = this.resolveFromLibrary(nestedBinaryName);
                }
            }
            if (result == null) {
                result = this.resolveTypeInternal(typeName);
            }
            if (result != null) {
                this.resolvedTypeCache.put(typeName, result);
            }
        }
        return result;
    }

    private String resolveTypeInternal(String typeName) {
        String resolvedName = null;
        if (PRIMITIVE_TYPES.contains(typeName)) {
            resolvedName = typeName;
        } else {
            String outerName = typeName;
            String nestedName = typeName.replace('.', '$');
            int dotpos = typeName.indexOf(46);
            if (dotpos >= 0) {
                outerName = typeName.substring(0, dotpos);
            }
            if ((resolvedName = this.resolveImportedType(typeName, nestedName, true)) != null || (resolvedName = this.resolveImportedType(outerName, nestedName, false)) != null || this.pckg != null && (resolvedName = this.resolveFullyQualifiedType(this.pckg + '.' + typeName)) != null || (resolvedName = this.resolveFullyQualifiedType(typeName)) != null || this.pckg != null && (resolvedName = this.resolveFromLibrary(this.pckg + "$" + nestedName)) != null || (resolvedName = this.resolveFromLibrary("java.lang." + nestedName)) != null || (resolvedName = this.resolveImportedType("*", nestedName, false)) == null) {
                // empty if block
            }
        }
        return resolvedName;
    }

    private String resolveImportedType(String importSpec, String typeName, boolean fullMatch) {
        String resolvedName = null;
        String dotSuffix = "." + importSpec;
        for (String imprt : this.imports) {
            if (imprt.startsWith("static ")) {
                imprt = imprt.substring(7);
            }
            if (!imprt.equals(importSpec) && (fullMatch || !imprt.endsWith(dotSuffix))) continue;
            String candidateName = imprt.equals(importSpec) ? imprt : imprt.substring(0, imprt.length() - importSpec.length()) + typeName;
            resolvedName = this.resolveFullyQualifiedType(candidateName);
            if (resolvedName == null && !"*".equals(importSpec)) {
                resolvedName = candidateName;
            }
            if (resolvedName == null) continue;
            break;
        }
        return resolvedName;
    }

    private String resolveFromLibrary(String typeName) {
        return this.classLibrary.hasClassReference(typeName) ? typeName : null;
    }

    private String resolveFullyQualifiedType(String typeName) {
        int indexOfLastDot = typeName.lastIndexOf(46);
        if (indexOfLastDot >= 0) {
            String root = typeName.substring(0, indexOfLastDot);
            String leaf = typeName.substring(indexOfLastDot + 1);
            String resolvedTypeName = this.resolveFullyQualifiedType(root + '$' + leaf);
            if (resolvedTypeName != null) {
                return resolvedTypeName;
            }
        }
        if (this.classLibrary.hasClassReference(typeName)) {
            return typeName;
        }
        return null;
    }

    static {
        PRIMITIVE_TYPES.add("boolean");
        PRIMITIVE_TYPES.add("byte");
        PRIMITIVE_TYPES.add("char");
        PRIMITIVE_TYPES.add("double");
        PRIMITIVE_TYPES.add("float");
        PRIMITIVE_TYPES.add("int");
        PRIMITIVE_TYPES.add("long");
        PRIMITIVE_TYPES.add("short");
        PRIMITIVE_TYPES.add("void");
    }
}

