/*
 * Decompiled with CFR 0.152.
 */
package groovy.test;

import groovy.lang.Closure;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovyShell;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;

public class GroovyAssert {
    private static final int MAX_NESTED_EXCEPTIONS = 10;
    private static final AtomicInteger counter = new AtomicInteger(0);
    public static final String TEST_SCRIPT_NAME_PREFIX = "TestScript";
    private static final ThreadLocal<Boolean> notYetImplementedFlag = new ThreadLocal();

    protected static String genericScriptName() {
        return TEST_SCRIPT_NAME_PREFIX + counter.getAndIncrement() + ".groovy";
    }

    public static void assertScript(String script) {
        GroovyAssert.assertScript(new GroovyShell(), script);
    }

    public static void assertScript(GroovyShell shell, String script) {
        shell.evaluate(script, GroovyAssert.genericScriptName());
    }

    public static void fail(String message) {
        if (message == null) {
            throw new AssertionError();
        }
        throw new AssertionError((Object)message);
    }

    public static Throwable shouldFail(String script) {
        return GroovyAssert.shouldFail(new GroovyShell(), script);
    }

    public static Throwable shouldFail(GroovyShell shell, String script) {
        Throwable th = null;
        try {
            shell.evaluate(script, GroovyAssert.genericScriptName());
        }
        catch (GroovyRuntimeException gre) {
            th = ScriptBytecodeAdapter.unwrap((GroovyRuntimeException)gre);
        }
        catch (Throwable t) {
            th = t;
        }
        if (th == null) {
            GroovyAssert.fail("Script should have failed");
        }
        return th;
    }

    public static <T extends Throwable> T shouldFail(Class<T> clazz, String script) {
        return GroovyAssert.shouldFail(new GroovyShell(), clazz, script);
    }

    public static <T extends Throwable> T shouldFail(GroovyShell shell, Class<T> clazz, String script) {
        Throwable th = null;
        try {
            shell.evaluate(script, GroovyAssert.genericScriptName());
        }
        catch (GroovyRuntimeException gre) {
            th = ScriptBytecodeAdapter.unwrap((GroovyRuntimeException)gre);
        }
        catch (Throwable t) {
            th = t;
        }
        if (th == null) {
            GroovyAssert.fail("Script should have failed with an exception of type " + clazz.getName());
        } else if (!clazz.isInstance(th)) {
            GroovyAssert.fail("Script should have failed with an exception of type " + clazz.getName() + ", instead got Exception " + th);
        }
        Throwable t = th;
        return (T)t;
    }

    public static Throwable shouldFail(Closure<?> code) {
        Throwable th = null;
        try {
            code.call();
        }
        catch (GroovyRuntimeException gre) {
            th = ScriptBytecodeAdapter.unwrap((GroovyRuntimeException)gre);
        }
        catch (Throwable t) {
            th = t;
        }
        if (th == null) {
            GroovyAssert.fail("Closure " + code + " should have failed");
        }
        return th;
    }

    public static <T extends Throwable> T shouldFail(Class<T> type, Closure<?> code) {
        Throwable th = null;
        try {
            code.call();
        }
        catch (GroovyRuntimeException gre) {
            th = ScriptBytecodeAdapter.unwrap((GroovyRuntimeException)gre);
        }
        catch (Throwable t) {
            th = t;
        }
        if (th == null) {
            GroovyAssert.fail("Closure " + code + " should have failed with an exception of type " + type.getName());
        } else if (!type.isInstance(th)) {
            GroovyAssert.fail("Closure " + code + " should have failed with an exception of type " + type.getName() + ", but got: " + th);
        }
        Throwable t = th;
        return (T)t;
    }

    public static <T extends Throwable> T shouldFailWithCause(Class<T> type, Closure<?> code) {
        Throwable th = null;
        try {
            code.call();
        }
        catch (GroovyRuntimeException gre) {
            th = ScriptBytecodeAdapter.unwrap((GroovyRuntimeException)gre);
        }
        catch (Throwable t) {
            th = t;
        }
        if (th == null) {
            GroovyAssert.fail("Closure " + code + " should have failed with an exception having a nested cause of type " + type.getName());
        } else if (th.getCause() == null) {
            GroovyAssert.fail("Closure " + code + " should have failed with an exception having a nested cause of type " + type.getName() + " but instead got a direct exception of type " + th.getClass().getName() + " with no cause. Code under test has a bug or perhaps you meant shouldFail?");
        }
        for (int level = 0; th != th.getCause() && level < 10 && (th = th.getCause()) != null && !type.isInstance(th); ++level) {
        }
        if (th == null || !type.isInstance(th)) {
            GroovyAssert.fail("Closure " + code + " should have failed with an exception having a nested cause of type " + type.getName() + ", instead found these exceptions:\n" + GroovyAssert.buildExceptionList(th));
        }
        Throwable t = th;
        return (T)t;
    }

    private static String buildExceptionList(Throwable th) {
        StringBuilder sb = new StringBuilder();
        int level = 0;
        while (th != null) {
            if (level > 1) {
                sb.append("   ".repeat(level - 1));
            }
            if (level > 0) {
                sb.append("-> ");
            }
            if (level > 10) {
                sb.append("...");
                break;
            }
            sb.append(th.getClass().getName()).append(": ").append(th.getMessage()).append("\n");
            if (th == th.getCause()) break;
            th = th.getCause();
            ++level;
        }
        return sb.toString();
    }

    private static Method findRunningJUnitTestMethod(Class<?> caller) {
        Class[] args = new Class[]{};
        StackTraceElement[] stackTrace = new Exception().getStackTrace();
        for (int i = stackTrace.length - 1; i >= 0; --i) {
            StackTraceElement element = stackTrace[i];
            if (!element.getClassName().equals(caller.getName())) continue;
            try {
                Method m = caller.getMethod(element.getMethodName(), args);
                if (!GroovyAssert.isPublicTestMethod(m)) continue;
                return m;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new RuntimeException("No JUnit test case method found in call stack");
    }

    private static boolean isPublicTestMethod(Method method) {
        String name = method.getName();
        Class<?>[] parameters = method.getParameterTypes();
        Class<?> returnType = method.getReturnType();
        return parameters.length == 0 && (name.startsWith("test") || GroovyAssert.hasTestAnnotation(method)) && returnType.equals(Void.TYPE) && Modifier.isPublic(method.getModifiers());
    }

    private static boolean hasTestAnnotation(Method method) {
        for (Annotation annotation : method.getAnnotations()) {
            if (!"org.junit.Test".equals(annotation.annotationType().getName())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean notYetImplemented(Object caller) {
        if (notYetImplementedFlag.get() != null) {
            return false;
        }
        notYetImplementedFlag.set(Boolean.TRUE);
        Logger log = Logger.getLogger(GroovyAssert.class.getName());
        Method testMethod = GroovyAssert.findRunningJUnitTestMethod(caller.getClass());
        try {
            log.info("Running " + testMethod.getName() + " as not yet implemented");
            testMethod.invoke(caller, (Object[])new Class[0]);
            GroovyAssert.fail(testMethod.getName() + " is marked as not yet implemented but passes unexpectedly");
        }
        catch (Exception e) {
            log.info(testMethod.getName() + " fails which is expected as it is not yet implemented");
        }
        finally {
            notYetImplementedFlag.remove();
        }
        return true;
    }

    public static boolean isAtLeastJdk(String specVersion) {
        boolean result = false;
        try {
            result = DefaultGroovyMethods.isAtLeast((BigDecimal)new BigDecimal(System.getProperty("java.specification.version")), (String)specVersion);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

