/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.gravitino.shaded.com.google.common.collect.ImmutableSet;
import org.apache.gravitino.utils.MapUtils;

public class GravitinoClientConfiguration {
    public static final String POSITIVE_NUMBER_ERROR_MSG = "The value must be a positive number";
    public static final String GRAVITINO_CLIENT_CONFIG_PREFIX = "gravitino.client.";
    public static final long CLIENT_CONNECTION_TIMEOUT_MS_DEFAULT = 180000L;
    public static final int CLIENT_SOCKET_TIMEOUT_MS_DEFAULT = 180000;
    public static final String CLIENT_CONNECTION_TIMEOUT_MS = "gravitino.client.connectionTimeoutMs";
    public static final String CLIENT_SOCKET_TIMEOUT_MS = "gravitino.client.socketTimeoutMs";
    private static final Set<String> SUPPORT_CLIENT_CONFIG_KEYS = ImmutableSet.of("gravitino.client.connectionTimeoutMs", "gravitino.client.socketTimeoutMs");
    private Map<String, String> properties;

    private GravitinoClientConfiguration(Map<String, String> properties) {
        this.properties = properties;
    }

    public static GravitinoClientConfiguration buildFromProperties(Map<String, String> properties) {
        for (String key : properties.keySet()) {
            if (SUPPORT_CLIENT_CONFIG_KEYS.contains(key)) continue;
            throw new IllegalArgumentException(String.format("Invalid property for client: %s", key));
        }
        return new GravitinoClientConfiguration(properties);
    }

    public long getClientConnectionTimeoutMs() {
        long connectionTimeoutMillis = MapUtils.propertyAsLong(this.properties, CLIENT_CONNECTION_TIMEOUT_MS, 180000L);
        GravitinoClientConfiguration.checkValue(value -> value >= 0L, CLIENT_CONNECTION_TIMEOUT_MS, connectionTimeoutMillis, POSITIVE_NUMBER_ERROR_MSG);
        return connectionTimeoutMillis;
    }

    public int getClientSocketTimeoutMs() {
        int socketTimeoutMillis = MapUtils.propertyAsInt(this.properties, CLIENT_SOCKET_TIMEOUT_MS, 180000);
        GravitinoClientConfiguration.checkValue(value -> value >= 0, CLIENT_SOCKET_TIMEOUT_MS, socketTimeoutMillis, POSITIVE_NUMBER_ERROR_MSG);
        return socketTimeoutMillis;
    }

    private static <T> void checkValue(Function<T, Boolean> checkValueFunc, String key, T value, String errorMsg) {
        if (!checkValueFunc.apply(value).booleanValue()) {
            throw new IllegalArgumentException(String.format("%s in %s is invalid. %s", value, key, errorMsg));
        }
    }
}

