/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.responses;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.gravitino.dto.responses.BaseResponse;
import org.apache.gravitino.dto.stats.StatisticDTO;

public class StatisticListResponse
extends BaseResponse {
    @JsonProperty(value="statistics")
    private StatisticDTO[] statistics;

    public StatisticListResponse(StatisticDTO[] statistics) {
        super(0);
        this.statistics = statistics;
    }

    public StatisticListResponse() {
        this(null);
    }

    @Override
    public void validate() throws IllegalArgumentException {
        Preconditions.checkArgument((this.statistics != null ? 1 : 0) != 0, (Object)"\"statistics\" must not be null");
        for (StatisticDTO statistic : this.statistics) {
            Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"\"statistic\" must not be null");
            statistic.validate();
        }
    }

    public StatisticDTO[] getStatistics() {
        return this.statistics;
    }

    @Override
    public String toString() {
        return "StatisticListResponse(statistics=" + Arrays.deepToString(this.getStatistics()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatisticListResponse)) {
            return false;
        }
        StatisticListResponse other = (StatisticListResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.deepEquals(this.getStatistics(), other.getStatistics());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof StatisticListResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.deepHashCode(this.getStatistics());
        return result;
    }
}

