/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.service.rest;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import com.google.common.annotations.VisibleForTesting;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.gravitino.iceberg.service.IcebergExceptionMapper;
import org.apache.gravitino.iceberg.service.IcebergRestUtils;
import org.apache.gravitino.iceberg.service.dispatcher.IcebergViewOperationDispatcher;
import org.apache.gravitino.listener.api.event.IcebergRequestContext;
import org.apache.gravitino.server.web.Utils;
import org.apache.iceberg.rest.requests.RenameTableRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/{prefix:([^/]*/)?}views/rename")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class IcebergViewRenameOperations {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergViewRenameOperations.class);
    @Context
    private HttpServletRequest httpRequest;
    private IcebergViewOperationDispatcher viewOperationDispatcher;

    @Inject
    public IcebergViewRenameOperations(IcebergViewOperationDispatcher viewOperationDispatcher) {
        this.viewOperationDispatcher = viewOperationDispatcher;
    }

    @POST
    @Produces(value={"application/json"})
    @Timed(name="rename-view.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="rename-view", absolute=true)
    public Response renameView(@PathParam(value="prefix") String prefix, RenameTableRequest renameViewRequest) {
        String catalogName = IcebergRestUtils.getCatalogName(prefix);
        LOG.info("Rename Iceberg view, catalog: {}, source: {}, destination: {}.", new Object[]{catalogName, renameViewRequest.source(), renameViewRequest.destination()});
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                IcebergRequestContext context = new IcebergRequestContext(this.httpServletRequest(), catalogName);
                this.viewOperationDispatcher.renameView(context, renameViewRequest);
                return IcebergRestUtils.noContent();
            });
        }
        catch (Exception e) {
            return IcebergExceptionMapper.toRESTResponse(e);
        }
    }

    @VisibleForTesting
    HttpServletRequest httpServletRequest() {
        return this.httpRequest;
    }
}

