/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.service.dispatcher;

import java.util.Optional;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.iceberg.service.IcebergRestUtils;
import org.apache.gravitino.iceberg.service.dispatcher.IcebergTableOperationDispatcher;
import org.apache.gravitino.listener.EventBus;
import org.apache.gravitino.listener.api.event.BaseEvent;
import org.apache.gravitino.listener.api.event.IcebergCreateTableEvent;
import org.apache.gravitino.listener.api.event.IcebergCreateTableFailureEvent;
import org.apache.gravitino.listener.api.event.IcebergCreateTablePreEvent;
import org.apache.gravitino.listener.api.event.IcebergDropTableEvent;
import org.apache.gravitino.listener.api.event.IcebergDropTableFailureEvent;
import org.apache.gravitino.listener.api.event.IcebergDropTablePreEvent;
import org.apache.gravitino.listener.api.event.IcebergListTableEvent;
import org.apache.gravitino.listener.api.event.IcebergListTableFailureEvent;
import org.apache.gravitino.listener.api.event.IcebergListTablePreEvent;
import org.apache.gravitino.listener.api.event.IcebergLoadTableEvent;
import org.apache.gravitino.listener.api.event.IcebergLoadTableFailureEvent;
import org.apache.gravitino.listener.api.event.IcebergLoadTablePreEvent;
import org.apache.gravitino.listener.api.event.IcebergRenameTableEvent;
import org.apache.gravitino.listener.api.event.IcebergRenameTableFailureEvent;
import org.apache.gravitino.listener.api.event.IcebergRenameTablePreEvent;
import org.apache.gravitino.listener.api.event.IcebergRequestContext;
import org.apache.gravitino.listener.api.event.IcebergTableExistsEvent;
import org.apache.gravitino.listener.api.event.IcebergTableExistsFailureEvent;
import org.apache.gravitino.listener.api.event.IcebergTableExistsPreEvent;
import org.apache.gravitino.listener.api.event.IcebergUpdateTableEvent;
import org.apache.gravitino.listener.api.event.IcebergUpdateTableFailureEvent;
import org.apache.gravitino.listener.api.event.IcebergUpdateTablePreEvent;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.rest.requests.RenameTableRequest;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;

public class IcebergTableEventDispatcher
implements IcebergTableOperationDispatcher {
    private IcebergTableOperationDispatcher icebergTableOperationDispatcher;
    private EventBus eventBus;
    private String metalakeName;

    public IcebergTableEventDispatcher(IcebergTableOperationDispatcher icebergTableOperationDispatcher, EventBus eventBus, String metalakeName) {
        this.icebergTableOperationDispatcher = icebergTableOperationDispatcher;
        this.eventBus = eventBus;
        this.metalakeName = metalakeName;
    }

    @Override
    public LoadTableResponse createTable(IcebergRequestContext context, Namespace namespace, CreateTableRequest createTableRequest) {
        LoadTableResponse loadTableResponse;
        TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)namespace, (String)createTableRequest.name());
        NameIdentifier nameIdentifier = IcebergRestUtils.getGravitinoNameIdentifier(this.metalakeName, context.catalogName(), tableIdentifier);
        Optional transformedEvent = this.eventBus.dispatchEvent((BaseEvent)new IcebergCreateTablePreEvent(context, nameIdentifier, createTableRequest));
        IcebergCreateTablePreEvent transformedCreateEvent = (IcebergCreateTablePreEvent)((Object)transformedEvent.get());
        try {
            loadTableResponse = this.icebergTableOperationDispatcher.createTable(context, namespace, transformedCreateEvent.createTableRequest());
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent((BaseEvent)new IcebergCreateTableFailureEvent(context, nameIdentifier, transformedCreateEvent.createTableRequest(), e));
            throw e;
        }
        this.eventBus.dispatchEvent((BaseEvent)new IcebergCreateTableEvent(context, nameIdentifier, transformedCreateEvent.createTableRequest(), loadTableResponse));
        return loadTableResponse;
    }

    @Override
    public LoadTableResponse updateTable(IcebergRequestContext context, TableIdentifier tableIdentifier, UpdateTableRequest updateTableRequest) {
        LoadTableResponse loadTableResponse;
        NameIdentifier gravitinoNameIdentifier = IcebergRestUtils.getGravitinoNameIdentifier(this.metalakeName, context.catalogName(), tableIdentifier);
        Optional transformedEvent = this.eventBus.dispatchEvent((BaseEvent)new IcebergUpdateTablePreEvent(context, gravitinoNameIdentifier, updateTableRequest));
        IcebergUpdateTablePreEvent transformedUpdateEvent = (IcebergUpdateTablePreEvent)((Object)transformedEvent.get());
        try {
            loadTableResponse = this.icebergTableOperationDispatcher.updateTable(context, tableIdentifier, transformedUpdateEvent.updateTableRequest());
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent((BaseEvent)new IcebergUpdateTableFailureEvent(context, gravitinoNameIdentifier, transformedUpdateEvent.updateTableRequest(), e));
            throw e;
        }
        this.eventBus.dispatchEvent((BaseEvent)new IcebergUpdateTableEvent(context, gravitinoNameIdentifier, transformedUpdateEvent.updateTableRequest(), loadTableResponse));
        return loadTableResponse;
    }

    @Override
    public void dropTable(IcebergRequestContext context, TableIdentifier tableIdentifier, boolean purgeRequested) {
        NameIdentifier gravitinoNameIdentifier = IcebergRestUtils.getGravitinoNameIdentifier(this.metalakeName, context.catalogName(), tableIdentifier);
        this.eventBus.dispatchEvent((BaseEvent)new IcebergDropTablePreEvent(context, gravitinoNameIdentifier, purgeRequested));
        try {
            this.icebergTableOperationDispatcher.dropTable(context, tableIdentifier, purgeRequested);
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent((BaseEvent)new IcebergDropTableFailureEvent(context, gravitinoNameIdentifier, purgeRequested, e));
            throw e;
        }
        this.eventBus.dispatchEvent((BaseEvent)new IcebergDropTableEvent(context, gravitinoNameIdentifier, purgeRequested));
    }

    @Override
    public LoadTableResponse loadTable(IcebergRequestContext context, TableIdentifier tableIdentifier) {
        LoadTableResponse loadTableResponse;
        NameIdentifier gravitinoNameIdentifier = IcebergRestUtils.getGravitinoNameIdentifier(this.metalakeName, context.catalogName(), tableIdentifier);
        this.eventBus.dispatchEvent((BaseEvent)new IcebergLoadTablePreEvent(context, gravitinoNameIdentifier));
        try {
            loadTableResponse = this.icebergTableOperationDispatcher.loadTable(context, tableIdentifier);
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent((BaseEvent)new IcebergLoadTableFailureEvent(context, gravitinoNameIdentifier, e));
            throw e;
        }
        this.eventBus.dispatchEvent((BaseEvent)new IcebergLoadTableEvent(context, gravitinoNameIdentifier, loadTableResponse));
        return loadTableResponse;
    }

    @Override
    public ListTablesResponse listTable(IcebergRequestContext context, Namespace namespace) {
        ListTablesResponse listTablesResponse;
        NameIdentifier gravitinoNameIdentifier = IcebergRestUtils.getGravitinoNameIdentifier(this.metalakeName, context.catalogName(), namespace);
        this.eventBus.dispatchEvent((BaseEvent)new IcebergListTablePreEvent(context, gravitinoNameIdentifier));
        try {
            listTablesResponse = this.icebergTableOperationDispatcher.listTable(context, namespace);
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent((BaseEvent)new IcebergListTableFailureEvent(context, gravitinoNameIdentifier, e));
            throw e;
        }
        this.eventBus.dispatchEvent((BaseEvent)new IcebergListTableEvent(context, gravitinoNameIdentifier));
        return listTablesResponse;
    }

    @Override
    public boolean tableExists(IcebergRequestContext context, TableIdentifier tableIdentifier) {
        boolean isExists;
        NameIdentifier gravitinoNameIdentifier = IcebergRestUtils.getGravitinoNameIdentifier(this.metalakeName, context.catalogName(), tableIdentifier);
        this.eventBus.dispatchEvent((BaseEvent)new IcebergTableExistsPreEvent(context, gravitinoNameIdentifier));
        try {
            isExists = this.icebergTableOperationDispatcher.tableExists(context, tableIdentifier);
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent((BaseEvent)new IcebergTableExistsFailureEvent(context, gravitinoNameIdentifier, e));
            throw e;
        }
        this.eventBus.dispatchEvent((BaseEvent)new IcebergTableExistsEvent(context, gravitinoNameIdentifier, isExists));
        return isExists;
    }

    @Override
    public void renameTable(IcebergRequestContext context, RenameTableRequest renameTableRequest) {
        TableIdentifier sourceTable = renameTableRequest.source();
        NameIdentifier gravitinoNameIdentifier = IcebergRestUtils.getGravitinoNameIdentifier(this.metalakeName, context.catalogName(), sourceTable);
        this.eventBus.dispatchEvent((BaseEvent)new IcebergRenameTablePreEvent(context, gravitinoNameIdentifier, renameTableRequest));
        try {
            this.icebergTableOperationDispatcher.renameTable(context, renameTableRequest);
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent((BaseEvent)new IcebergRenameTableFailureEvent(context, gravitinoNameIdentifier, renameTableRequest, e));
            throw e;
        }
        this.eventBus.dispatchEvent((BaseEvent)new IcebergRenameTableEvent(context, gravitinoNameIdentifier, renameTableRequest));
    }
}

