/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.authorization.jcasbin;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Configs;
import org.apache.gravitino.Entity;
import org.apache.gravitino.EntityStore;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.MetadataObjects;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.SupportsRelationOperations;
import org.apache.gravitino.authorization.AuthorizationRequestContext;
import org.apache.gravitino.authorization.GravitinoAuthorizer;
import org.apache.gravitino.authorization.Privilege;
import org.apache.gravitino.authorization.SecurableObject;
import org.apache.gravitino.meta.RoleEntity;
import org.apache.gravitino.meta.UserEntity;
import org.apache.gravitino.server.authorization.MetadataIdConverter;
import org.apache.gravitino.server.authorization.jcasbin.GravitinoAdapter;
import org.apache.gravitino.utils.MetadataObjectUtil;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.PrincipalUtils;
import org.casbin.jcasbin.main.Enforcer;
import org.casbin.jcasbin.main.SyncedEnforcer;
import org.casbin.jcasbin.model.Model;
import org.casbin.jcasbin.persist.Adapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcasbinAuthorizer
implements GravitinoAuthorizer {
    private static final Logger LOG = LoggerFactory.getLogger(JcasbinAuthorizer.class);
    private Enforcer allowEnforcer;
    private Enforcer denyEnforcer;
    private InternalAuthorizer allowInternalAuthorizer;
    private InternalAuthorizer denyInternalAuthorizer;
    private Set<Long> loadedRoles = ConcurrentHashMap.newKeySet();
    private Set<Long> loadedOwners = ConcurrentHashMap.newKeySet();
    private Map<Long, Long> ownerRel = new ConcurrentHashMap<Long, Long>();
    private Executor executor = null;

    public void initialize() {
        this.executor = Executors.newFixedThreadPool((Integer)GravitinoEnv.getInstance().config().get(Configs.GRAVITINO_AUTHORIZATION_THREAD_POOL_SIZE), runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName("GravitinoAuthorizer-ThreadPool-" + thread.getId());
            return thread;
        });
        this.allowEnforcer = new SyncedEnforcer(this.getModel("/jcasbin_model.conf"), (Adapter)new GravitinoAdapter());
        this.allowInternalAuthorizer = new InternalAuthorizer(this.allowEnforcer);
        this.denyEnforcer = new SyncedEnforcer(this.getModel("/jcasbin_model.conf"), (Adapter)new GravitinoAdapter());
        this.denyInternalAuthorizer = new InternalAuthorizer(this.denyEnforcer);
    }

    private Model getModel(String modelFilePath) {
        Model model = new Model();
        try (InputStream modelStream = JcasbinAuthorizer.class.getResourceAsStream(modelFilePath);){
            Preconditions.checkNotNull((Object)modelStream, (Object)"Jcasbin model file can not found.");
            String modelData = IOUtils.toString((InputStream)modelStream, (Charset)StandardCharsets.UTF_8);
            model.loadModelFromText(modelData);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return model;
    }

    public boolean authorize(Principal principal, String metalake, MetadataObject metadataObject, Privilege.Name privilege, AuthorizationRequestContext requestContext) {
        boolean result = requestContext.authorizeAllow(principal, metalake, metadataObject, privilege, authorizationKey -> this.allowInternalAuthorizer.authorizeInternal(authorizationKey.getPrincipal().getName(), authorizationKey.getMetalake(), authorizationKey.getMetadataObject(), authorizationKey.getPrivilege().name(), requestContext));
        LOG.debug("principal {},metalake {},metadata object {},privilege {}, result {}", new Object[]{principal, metalake, metadataObject, privilege, result});
        return result;
    }

    public boolean deny(Principal principal, String metalake, MetadataObject metadataObject, Privilege.Name privilege, AuthorizationRequestContext requestContext) {
        boolean result = requestContext.authorizeDeny(principal, metalake, metadataObject, privilege, authorizationKey -> this.denyInternalAuthorizer.authorizeInternal(authorizationKey.getPrincipal().getName(), authorizationKey.getMetalake(), authorizationKey.getMetadataObject(), authorizationKey.getPrivilege().name(), requestContext));
        LOG.debug("principal {},metalake {},metadata object {},privilege {},deny result {}", new Object[]{principal, metalake, metadataObject, privilege, result});
        return result;
    }

    public boolean isOwner(Principal principal, String metalake, MetadataObject metadataObject) {
        boolean result;
        try {
            Long metadataId = MetadataIdConverter.getID(metadataObject, metalake);
            this.loadOwnerPolicy(metalake, metadataObject, metadataId);
            UserEntity userEntity = JcasbinAuthorizer.getUserEntity(principal.getName(), metalake);
            Long userId = userEntity.id();
            metadataId = MetadataIdConverter.getID(metadataObject, metalake);
            result = Objects.equals(userId, this.ownerRel.get(metadataId));
        }
        catch (Exception e) {
            LOG.debug("Can not get entity id", (Throwable)e);
            result = false;
        }
        LOG.debug("principal {},metalake {},metadata object {},privilege {},deny result {}", new Object[]{principal, metalake, metadataObject, "OWNER", result});
        return result;
    }

    public boolean isServiceAdmin() {
        return GravitinoEnv.getInstance().accessControlDispatcher().isServiceAdmin(PrincipalUtils.getCurrentUserName());
    }

    public boolean isMetalakeUser(String metalake) {
        String currentUserName = PrincipalUtils.getCurrentUserName();
        if (StringUtils.isBlank((CharSequence)currentUserName)) {
            return false;
        }
        try {
            return GravitinoEnv.getInstance().entityStore().get(NameIdentifierUtil.ofUser((String)metalake, (String)currentUserName), Entity.EntityType.USER, UserEntity.class) != null;
        }
        catch (Exception e) {
            LOG.warn("Can not get user {} in metalake {}", new Object[]{currentUserName, metalake, e});
            return false;
        }
    }

    public boolean isSelf(Entity.EntityType type, NameIdentifier nameIdentifier) {
        String metalake = nameIdentifier.namespace().level(0);
        String currentUserName = PrincipalUtils.getCurrentUserName();
        if (Entity.EntityType.USER == type) {
            return Objects.equals(nameIdentifier.name(), currentUserName);
        }
        if (Entity.EntityType.ROLE == type) {
            try {
                Long roleId = MetadataIdConverter.getID(NameIdentifierUtil.toMetadataObject((NameIdentifier)nameIdentifier, (Entity.EntityType)type), metalake);
                EntityStore entityStore = GravitinoEnv.getInstance().entityStore();
                NameIdentifier userNameIdentifier = NameIdentifierUtil.ofUser((String)metalake, (String)PrincipalUtils.getCurrentUserName());
                List entities = entityStore.relationOperations().listEntitiesByRelation(SupportsRelationOperations.Type.ROLE_USER_REL, userNameIdentifier, Entity.EntityType.USER);
                return entities.stream().anyMatch(roleEntity -> Objects.equals(roleEntity.id(), roleId));
            }
            catch (Exception e) {
                LOG.warn("can not get user id or role id.", (Throwable)e);
                return false;
            }
        }
        throw new UnsupportedOperationException("Unsupported Entity Type.");
    }

    public boolean hasSetOwnerPermission(String metalake, String type, String fullName, AuthorizationRequestContext requestContext) {
        MetadataObject metalakeObject;
        Principal currentPrincipal = PrincipalUtils.getCurrentPrincipal();
        if (this.isOwner(currentPrincipal, metalake, metalakeObject = MetadataObjects.of((List)ImmutableList.of((Object)metalake), (MetadataObject.Type)MetadataObject.Type.METALAKE))) {
            return true;
        }
        MetadataObject.Type metadataType = MetadataObject.Type.valueOf((String)type.toUpperCase());
        MetadataObject metadataObject = MetadataObjects.of(Arrays.asList(fullName.split("\\.")), (MetadataObject.Type)metadataType);
        do {
            if (!this.isOwner(currentPrincipal, metalake, metadataObject)) continue;
            MetadataObject.Type tempType = metadataObject.type();
            if (tempType == MetadataObject.Type.SCHEMA) {
                boolean hasCatalogUseCatalog = this.authorize(currentPrincipal, metalake, MetadataObjects.parent((MetadataObject)metadataObject), Privilege.Name.USE_CATALOG, requestContext);
                boolean hasMetalakeUseCatalog = this.authorize(currentPrincipal, metalake, metalakeObject, Privilege.Name.USE_CATALOG, requestContext);
                return hasCatalogUseCatalog || hasMetalakeUseCatalog;
            }
            if (tempType == MetadataObject.Type.TABLE || tempType == MetadataObject.Type.TOPIC || tempType == MetadataObject.Type.FILESET || tempType == MetadataObject.Type.MODEL) {
                boolean hasMetalakeUseSchema = this.authorize(currentPrincipal, metalake, metalakeObject, Privilege.Name.USE_SCHEMA, requestContext);
                MetadataObject schemaObject = MetadataObjects.parent((MetadataObject)metadataObject);
                boolean hasCatalogUseSchema = this.authorize(currentPrincipal, metalake, MetadataObjects.parent((MetadataObject)schemaObject), Privilege.Name.USE_SCHEMA, requestContext);
                boolean hasSchemaUseSchema = this.authorize(currentPrincipal, metalake, schemaObject, Privilege.Name.USE_SCHEMA, requestContext);
                return hasMetalakeUseSchema || hasCatalogUseSchema || hasSchemaUseSchema;
            }
            return true;
        } while ((metadataObject = MetadataObjects.parent((MetadataObject)metadataObject)) != null);
        return false;
    }

    public boolean hasMetadataPrivilegePermission(String metalake, String type, String fullName, AuthorizationRequestContext requestContext) {
        MetadataObject metalakeMetadataObject;
        Principal currentPrincipal = PrincipalUtils.getCurrentPrincipal();
        return this.authorize(currentPrincipal, metalake, metalakeMetadataObject = MetadataObjects.of((List)ImmutableList.of((Object)metalake), (MetadataObject.Type)MetadataObject.Type.METALAKE), Privilege.Name.MANAGE_GRANTS, requestContext) || this.hasSetOwnerPermission(metalake, type, fullName, requestContext);
    }

    public void handleRolePrivilegeChange(Long roleId) {
        this.loadedRoles.remove(roleId);
        this.allowEnforcer.deleteRole(String.valueOf(roleId));
        this.denyEnforcer.deleteRole(String.valueOf(roleId));
    }

    public void handleMetadataOwnerChange(String metalake, Long oldOwnerId, NameIdentifier nameIdentifier, Entity.EntityType type) {
        MetadataObject metadataObject = NameIdentifierUtil.toMetadataObject((NameIdentifier)nameIdentifier, (Entity.EntityType)type);
        Long metadataId = MetadataIdConverter.getID(metadataObject, metalake);
        this.ownerRel.remove(metadataId);
        this.loadedOwners.remove(metadataId);
    }

    public void close() throws IOException {
        if (this.executor != null && this.executor instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)this.executor;
            threadPoolExecutor.shutdown();
        }
    }

    private static UserEntity getUserEntity(String username, String metalake) throws IOException {
        EntityStore entityStore = GravitinoEnv.getInstance().entityStore();
        UserEntity userEntity = (UserEntity)entityStore.get(NameIdentifierUtil.ofUser((String)metalake, (String)username), Entity.EntityType.USER, UserEntity.class);
        return userEntity;
    }

    private void loadRolePrivilege(String metalake, String username, Long userId, AuthorizationRequestContext requestContext) {
        requestContext.loadRole(() -> {
            EntityStore entityStore = GravitinoEnv.getInstance().entityStore();
            NameIdentifier userNameIdentifier = NameIdentifierUtil.ofUser((String)metalake, (String)username);
            try {
                List entities = entityStore.relationOperations().listEntitiesByRelation(SupportsRelationOperations.Type.ROLE_USER_REL, userNameIdentifier, Entity.EntityType.USER);
                ArrayList<CompletionStage> loadRoleFutures = new ArrayList<CompletionStage>();
                for (RoleEntity role : entities) {
                    Long roleId = role.id();
                    this.allowEnforcer.addRoleForUser(String.valueOf(userId), String.valueOf(roleId));
                    this.denyEnforcer.addRoleForUser(String.valueOf(userId), String.valueOf(roleId));
                    if (this.loadedRoles.contains(roleId)) continue;
                    CompletionStage loadRoleFuture = CompletableFuture.supplyAsync(() -> {
                        try {
                            return (RoleEntity)entityStore.get(NameIdentifierUtil.ofRole((String)metalake, (String)role.name()), Entity.EntityType.ROLE, RoleEntity.class);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Failed to load role: " + role.name(), e);
                        }
                    }, this.executor).thenAcceptAsync(roleEntity -> {
                        this.loadPolicyByRoleEntity((RoleEntity)roleEntity);
                        this.loadedRoles.add(roleId);
                    }, this.executor);
                    loadRoleFutures.add(loadRoleFuture);
                }
                CompletableFuture.allOf(loadRoleFutures.toArray(new CompletableFuture[0])).join();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void loadOwnerPolicy(String metalake, MetadataObject metadataObject, Long metadataId) {
        if (this.loadedOwners.contains(metadataId)) {
            LOG.debug("Metadata {} OWNER has bean loaded.", (Object)metadataId);
            return;
        }
        try {
            NameIdentifier entityIdent = MetadataObjectUtil.toEntityIdent((String)metalake, (MetadataObject)metadataObject);
            EntityStore entityStore = GravitinoEnv.getInstance().entityStore();
            List owners = entityStore.relationOperations().listEntitiesByRelation(SupportsRelationOperations.Type.OWNER_REL, entityIdent, Entity.EntityType.valueOf((String)metadataObject.type().name()));
            for (Entity ownerEntity : owners) {
                if (!(ownerEntity instanceof UserEntity)) continue;
                UserEntity user = (UserEntity)ownerEntity;
                this.ownerRel.put(metadataId, user.id());
                this.loadedOwners.add(metadataId);
            }
        }
        catch (IOException e) {
            LOG.warn("Can not load metadata owner", (Throwable)e);
        }
    }

    private void loadPolicyByRoleEntity(RoleEntity roleEntity) {
        String metalake = NameIdentifierUtil.getMetalake((NameIdentifier)roleEntity.nameIdentifier());
        List securableObjects = roleEntity.securableObjects();
        for (SecurableObject securableObject : securableObjects) {
            for (Privilege privilege : securableObject.privileges()) {
                Privilege.Condition condition = privilege.condition();
                if ("deny".equalsIgnoreCase(condition.name())) {
                    this.denyEnforcer.addPolicy(new String[]{String.valueOf(roleEntity.id()), securableObject.type().name(), String.valueOf(MetadataIdConverter.getID((MetadataObject)securableObject, metalake)), privilege.name().name().toUpperCase(), "allow"});
                }
                this.allowEnforcer.addPolicy(new String[]{String.valueOf(roleEntity.id()), securableObject.type().name(), String.valueOf(MetadataIdConverter.getID((MetadataObject)securableObject, metalake)), privilege.name().name().toUpperCase(), condition.name().toLowerCase()});
            }
        }
    }

    private class InternalAuthorizer {
        Enforcer enforcer;

        public InternalAuthorizer(Enforcer enforcer) {
            this.enforcer = enforcer;
        }

        private boolean authorizeInternal(String username, String metalake, MetadataObject metadataObject, String privilege, AuthorizationRequestContext requestContext) {
            return this.loadPrivilegeAndAuthorize(username, metalake, metadataObject, privilege, requestContext);
        }

        private boolean loadPrivilegeAndAuthorize(String username, String metalake, MetadataObject metadataObject, String privilege, AuthorizationRequestContext requestContext) {
            Long metadataId;
            Long userId;
            try {
                UserEntity userEntity = JcasbinAuthorizer.getUserEntity(username, metalake);
                userId = userEntity.id();
                metadataId = MetadataIdConverter.getID(metadataObject, metalake);
            }
            catch (Exception e) {
                LOG.debug("Can not get entity id", (Throwable)e);
                return false;
            }
            JcasbinAuthorizer.this.loadRolePrivilege(metalake, username, userId, requestContext);
            return this.authorizeByJcasbin(userId, metadataObject, metadataId, privilege);
        }

        private boolean authorizeByJcasbin(Long userId, MetadataObject metadataObject, Long metadataId, String privilege) {
            if ("OWNER".equals(privilege)) {
                return Objects.equals(userId, JcasbinAuthorizer.this.ownerRel.get(metadataId));
            }
            return this.enforcer.enforce(new Object[]{String.valueOf(userId), String.valueOf(metadataObject.type()), String.valueOf(metadataId), privilege});
        }
    }
}

