/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.options.ExpireConfig;
import org.apache.paimon.utils.DateTimeUtils;
import org.apache.paimon.utils.ParameterUtils;
import org.apache.paimon.utils.StringUtils;

public class ProcedureUtils {
    public static Map<String, String> fillInPartitionOptions(String expireStrategy, String timestampFormatter, String timestampPattern, String expirationTime, Integer maxExpires, String options) {
        HashMap<String, String> dynamicOptions = new HashMap<String, String>();
        ProcedureUtils.putAllOptions(dynamicOptions, options);
        ProcedureUtils.putIfNotEmpty(dynamicOptions, CoreOptions.PARTITION_EXPIRATION_STRATEGY.key(), expireStrategy);
        ProcedureUtils.putIfNotEmpty(dynamicOptions, CoreOptions.PARTITION_TIMESTAMP_FORMATTER.key(), timestampFormatter);
        ProcedureUtils.putIfNotEmpty(dynamicOptions, CoreOptions.PARTITION_TIMESTAMP_PATTERN.key(), timestampPattern);
        ProcedureUtils.putIfNotEmpty(dynamicOptions, CoreOptions.PARTITION_EXPIRATION_TIME.key(), expirationTime);
        ProcedureUtils.putIfNotEmpty(dynamicOptions, CoreOptions.PARTITION_EXPIRATION_CHECK_INTERVAL.key(), "0");
        ProcedureUtils.putIfNotEmpty(dynamicOptions, CoreOptions.PARTITION_EXPIRATION_MAX_NUM.key(), maxExpires == null ? null : String.valueOf(maxExpires));
        return dynamicOptions;
    }

    public static void putAllOptions(HashMap<String, String> dynamicOptions, String options) {
        if (!StringUtils.isNullOrWhitespaceOnly((String)options)) {
            dynamicOptions.putAll(ParameterUtils.parseCommaSeparatedKeyValues(options));
        }
    }

    public static void putIfNotEmpty(HashMap<String, String> dynamicOptions, String key, String value) {
        if (!StringUtils.isNullOrWhitespaceOnly((String)value)) {
            dynamicOptions.put(key, value);
        }
    }

    public static ExpireConfig.Builder fillInSnapshotOptions(CoreOptions tableOptions, Integer retainMax, Integer retainMin, String olderThanStr, Integer maxDeletes) {
        ExpireConfig.Builder builder = ExpireConfig.builder();
        builder.snapshotRetainMax(Optional.ofNullable(retainMax).orElse(tableOptions.snapshotNumRetainMax()).intValue()).snapshotRetainMin(Optional.ofNullable(retainMin).orElse(tableOptions.snapshotNumRetainMin()).intValue()).snapshotMaxDeletes(Optional.ofNullable(maxDeletes).orElse(tableOptions.snapshotExpireLimit()).intValue()).snapshotTimeRetain(tableOptions.snapshotTimeRetain());
        if (!StringUtils.isNullOrWhitespaceOnly((String)olderThanStr)) {
            long olderThanMills = DateTimeUtils.parseTimestampData(olderThanStr, 3, TimeZone.getDefault()).getMillisecond();
            builder.snapshotTimeRetain(Duration.ofMillis(System.currentTimeMillis() - olderThanMills));
        }
        return builder;
    }
}

