/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.fs;

import java.io.EOFException;
import java.io.IOException;
import java.util.List;
import org.apache.paimon.fs.FileRange;
import org.apache.paimon.fs.VectoredReadUtils;

public interface VectoredReadable {
    public int pread(long var1, byte[] var3, int var4, int var5) throws IOException;

    default public void preadFully(long position, byte[] buffer, int offset, int length) throws IOException {
        int readBytes = 0;
        while (readBytes < length) {
            int readBytesCurr = this.pread(position, buffer, offset + readBytes, length - readBytes);
            if (readBytesCurr < 0) {
                throw new EOFException(String.format("Input Stream closed before all bytes were read. Expected %,d bytes but only read %,d bytes. Current position %,d", length, readBytes, position));
            }
            readBytes += readBytesCurr;
            position += (long)readBytesCurr;
        }
    }

    default public int minSeekForVectorReads() {
        return 262144;
    }

    default public int batchSizeForVectorReads() {
        return 0x400000;
    }

    default public int parallelismForVectorReads() {
        return 4;
    }

    default public void readVectored(List<? extends FileRange> ranges) throws IOException {
        VectoredReadUtils.readVectored(this, ranges);
    }
}

