/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data.columnar.heap;

import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.columnar.ColumnVector;
import org.apache.paimon.data.columnar.ColumnarMap;
import org.apache.paimon.data.columnar.MapColumnVector;
import org.apache.paimon.data.columnar.heap.HeapMapVector;

public class CastedMapColumnVector
implements MapColumnVector {
    private final HeapMapVector heapMapVector;
    private final ColumnVector[] children;

    public CastedMapColumnVector(HeapMapVector heapMapVector, ColumnVector[] children) {
        this.heapMapVector = heapMapVector;
        this.children = children;
    }

    @Override
    public InternalMap getMap(int i) {
        long offset = this.heapMapVector.offsets[i];
        long length = this.heapMapVector.lengths[i];
        return new ColumnarMap(this.children[0], this.children[1], (int)offset, (int)length);
    }

    @Override
    public boolean isNullAt(int i) {
        return this.heapMapVector.isNullAt(i);
    }

    @Override
    public int getCapacity() {
        return this.heapMapVector.getCapacity();
    }

    @Override
    public ColumnVector[] getChildren() {
        return this.children;
    }
}

