/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.casting;

import org.apache.paimon.casting.AbstractCastRule;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.casting.CastRulePredicate;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeFamily;
import org.apache.paimon.utils.BinaryStringUtils;

class StringToNumericPrimitiveCastRule
extends AbstractCastRule<BinaryString, Number> {
    static final StringToNumericPrimitiveCastRule INSTANCE = new StringToNumericPrimitiveCastRule();

    private StringToNumericPrimitiveCastRule() {
        super(CastRulePredicate.builder().input(DataTypeFamily.CHARACTER_STRING).target(DataTypeFamily.INTEGER_NUMERIC).target(DataTypeFamily.APPROXIMATE_NUMERIC).build());
    }

    @Override
    public CastExecutor<BinaryString, Number> create(DataType inputType, DataType targetType) {
        switch (targetType.getTypeRoot()) {
            case TINYINT: {
                return BinaryStringUtils::toByte;
            }
            case SMALLINT: {
                return BinaryStringUtils::toShort;
            }
            case INTEGER: {
                return BinaryStringUtils::toInt;
            }
            case BIGINT: {
                return BinaryStringUtils::toLong;
            }
            case FLOAT: {
                return BinaryStringUtils::toFloat;
            }
            case DOUBLE: {
                return BinaryStringUtils::toDouble;
            }
        }
        return null;
    }
}

