/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.iceberg.io.MultiBufferInputStream;
import org.apache.iceberg.io.SeekableInputStream;
import org.apache.iceberg.io.SingleBufferInputStream;

public abstract class ByteBufferInputStream
extends SeekableInputStream {
    public static ByteBufferInputStream wrap(ByteBuffer ... buffers) {
        if (buffers.length == 1) {
            return new SingleBufferInputStream(buffers[0]);
        }
        return new MultiBufferInputStream(Arrays.asList(buffers));
    }

    public static ByteBufferInputStream wrap(List<ByteBuffer> buffers) {
        if (buffers.size() == 1) {
            return new SingleBufferInputStream(buffers.get(0));
        }
        return new MultiBufferInputStream(buffers);
    }

    public void skipFully(long length) throws IOException {
        long skipped = this.skip(length);
        if (skipped < length) {
            throw new EOFException("Not enough bytes to skip: " + skipped + " < " + length);
        }
    }

    public abstract int read(ByteBuffer var1);

    public abstract ByteBuffer slice(int var1) throws EOFException;

    public abstract List<ByteBuffer> sliceBuffers(long var1) throws EOFException;

    public ByteBufferInputStream sliceStream(long length) throws EOFException {
        return ByteBufferInputStream.wrap(this.sliceBuffers(length));
    }

    public abstract List<ByteBuffer> remainingBuffers();

    public ByteBufferInputStream remainingStream() {
        return ByteBufferInputStream.wrap(this.remainingBuffers());
    }
}

