/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.meta;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.gravitino.Auditable;
import org.apache.gravitino.Entity;
import org.apache.gravitino.Field;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.meta.AuditInfo;

public class ModelEntity
implements Entity,
Auditable,
HasIdentifier {
    public static final Field ID = Field.required("id", Long.class, "The unique id of the model entity.");
    public static final Field NAME = Field.required("name", String.class, "The name of the model entity.");
    public static final Field COMMENT = Field.optional("comment", String.class, "The comment or description of the model entity.");
    public static final Field LATEST_VERSION = Field.required("latest_version", Integer.class, "The latest version of the model entity.");
    public static final Field PROPERTIES = Field.optional("properties", Map.class, "The properties of the model entity.");
    public static final Field AUDIT_INFO = Field.required("audit_info", AuditInfo.class, "The audit details of the model entity.");
    private Long id;
    private String name;
    private Namespace namespace;
    private String comment;
    private Integer latestVersion;
    private AuditInfo auditInfo;
    private Map<String, String> properties;

    private ModelEntity() {
    }

    @Override
    public Map<Field, Object> fields() {
        HashMap fields = Maps.newHashMap();
        fields.put(ID, this.id);
        fields.put(NAME, this.name);
        fields.put(COMMENT, this.comment);
        fields.put(LATEST_VERSION, this.latestVersion);
        fields.put(PROPERTIES, this.properties);
        fields.put(AUDIT_INFO, this.auditInfo);
        return Collections.unmodifiableMap(fields);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Long id() {
        return this.id;
    }

    @Override
    public Namespace namespace() {
        return this.namespace;
    }

    public String comment() {
        return this.comment;
    }

    public Integer latestVersion() {
        return this.latestVersion;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public AuditInfo auditInfo() {
        return this.auditInfo;
    }

    @Override
    public Entity.EntityType type() {
        return Entity.EntityType.MODEL;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModelEntity)) {
            return false;
        }
        ModelEntity that = (ModelEntity)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.comment, that.comment) && Objects.equals(this.latestVersion, that.latestVersion) && Objects.equals(this.properties, that.properties) && Objects.equals(this.auditInfo, that.auditInfo);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.comment, this.latestVersion, this.properties, this.auditInfo);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "ModelEntity(id=" + this.id + ", name=" + this.name + ", namespace=" + String.valueOf(this.namespace) + ", comment=" + this.comment + ", latestVersion=" + this.latestVersion + ", auditInfo=" + String.valueOf(this.auditInfo) + ", properties=" + String.valueOf(this.properties) + ")";
    }

    public static class Builder {
        private final ModelEntity model = new ModelEntity();

        private Builder() {
        }

        public Builder withId(Long id) {
            this.model.id = id;
            return this;
        }

        public Builder withName(String name) {
            this.model.name = name;
            return this;
        }

        public Builder withNamespace(Namespace namespace) {
            this.model.namespace = namespace;
            return this;
        }

        public Builder withComment(String comment) {
            this.model.comment = comment;
            return this;
        }

        public Builder withLatestVersion(Integer latestVersion) {
            this.model.latestVersion = latestVersion;
            return this;
        }

        public Builder withProperties(Map<String, String> properties) {
            this.model.properties = properties;
            return this;
        }

        public Builder withAuditInfo(AuditInfo auditInfo) {
            this.model.auditInfo = auditInfo;
            return this;
        }

        public ModelEntity build() {
            this.model.validate();
            return this.model;
        }
    }
}

