/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.hive;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.gravitino.catalog.hive.HiveTable;
import org.apache.gravitino.connector.TableOperations;
import org.apache.gravitino.exceptions.NoSuchPartitionException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.exceptions.PartitionAlreadyExistsException;
import org.apache.gravitino.rel.SupportsPartitions;
import org.apache.gravitino.rel.expressions.literals.Literal;
import org.apache.gravitino.rel.expressions.literals.Literals;
import org.apache.gravitino.rel.expressions.transforms.Transforms;
import org.apache.gravitino.rel.partitions.IdentityPartition;
import org.apache.gravitino.rel.partitions.Partition;
import org.apache.gravitino.rel.partitions.Partitions;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveTableOperations
implements TableOperations,
SupportsPartitions {
    public static final Logger LOG = LoggerFactory.getLogger(HiveTableOperations.class);
    private static final String PARTITION_NAME_DELIMITER = "/";
    private static final String PARTITION_VALUE_DELIMITER = "=";
    private final HiveTable table;

    public HiveTableOperations(HiveTable table) {
        Preconditions.checkArgument((table != null ? 1 : 0) != 0, (Object)"table must not be null");
        this.table = table;
    }

    public String[] listPartitionNames() {
        try {
            return (String[])this.table.clientPool().run(c -> c.listPartitionNames(this.table.schemaName(), this.table.name(), (short)-1).toArray(new String[0]));
        }
        catch (InterruptedException | TException e) {
            throw new RuntimeException("Failed to list partition names of table " + this.table.name() + "from Hive Metastore", e);
        }
    }

    public Partition[] listPartitions() {
        List partitions;
        try {
            partitions = (List)this.table.clientPool().run(c -> c.listPartitions(this.table.schemaName(), this.table.name(), (short)-1));
        }
        catch (InterruptedException | TException e) {
            throw new RuntimeException(e);
        }
        List partCols = this.table.buildPartitionKeys().stream().map(FieldSchema::getName).collect(Collectors.toList());
        return (Partition[])partitions.stream().map(partition -> this.fromHivePartition(FileUtils.makePartName((List)partCols, (List)partition.getValues()), (org.apache.hadoop.hive.metastore.api.Partition)partition)).toArray(Partition[]::new);
    }

    public Partition getPartition(String partitionName) throws NoSuchPartitionException {
        try {
            org.apache.hadoop.hive.metastore.api.Partition partition = (org.apache.hadoop.hive.metastore.api.Partition)this.table.clientPool().run(c -> c.getPartition(this.table.schemaName(), this.table.name(), partitionName));
            return this.fromHivePartition(partitionName, partition);
        }
        catch (UnknownTableException e) {
            throw new NoSuchTableException((Throwable)e, "Hive table %s does not exist in Hive Metastore", new Object[]{this.table.name()});
        }
        catch (NoSuchObjectException e) {
            throw new NoSuchPartitionException((Throwable)e, "Hive partition %s does not exist in Hive Metastore", new Object[]{partitionName});
        }
        catch (InterruptedException | TException e) {
            throw new RuntimeException("Failed to get partition " + partitionName + " of table " + this.table.name() + "from Hive Metastore", e);
        }
    }

    private Partition fromHivePartition(String partitionName, org.apache.hadoop.hive.metastore.api.Partition partition) {
        String[][] fieldNames = this.getFieldNames(partitionName);
        Literal[] values = (Literal[])partition.getValues().stream().map(Literals::stringLiteral).toArray(Literal[]::new);
        return Partitions.identity((String)partitionName, (String[][])fieldNames, (Literal[])values, (Map)partition.getParameters());
    }

    /*
     * Exception decompiling
     */
    private String[][] getFieldNames(String partitionName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Partition addPartition(Partition partition) throws PartitionAlreadyExistsException {
        if ("*".equals(partition.name())) {
            throw new IllegalArgumentException("Can't create a catalog with with reserved partition `*`");
        }
        Preconditions.checkArgument((boolean)(partition instanceof IdentityPartition), (Object)"Hive only supports identity partition");
        IdentityPartition identityPartition = (IdentityPartition)partition;
        Set transformFields = Arrays.stream(this.table.partitioning()).map(t -> ((Transforms.IdentityTransform)t).fieldName()[0]).collect(Collectors.toSet());
        Preconditions.checkArgument((transformFields.size() == identityPartition.fieldNames().length ? 1 : 0) != 0, (String)"Hive partition field names must be the same as table partitioning field names: %s, but got %s", (Object)String.join((CharSequence)",", transformFields), (Object)String.join((CharSequence)",", Arrays.stream(identityPartition.fieldNames()).map(f -> String.join((CharSequence)".", f)).collect(Collectors.toList())));
        Arrays.stream(identityPartition.fieldNames()).forEach(f -> Preconditions.checkArgument((boolean)transformFields.contains(f[0]), (String)"Hive partition field name must be in table partitioning field names: %s, but got %s", (Object)String.join((CharSequence)",", transformFields), (Object)f[0]));
        try {
            org.apache.hadoop.hive.metastore.api.Partition createdPartition = (org.apache.hadoop.hive.metastore.api.Partition)this.table.clientPool().run(c -> c.add_partition(this.toHivePartition(identityPartition)));
            return this.fromHivePartition(this.generatePartitionName((IdentityPartition)partition), createdPartition);
        }
        catch (InterruptedException | TException e) {
            throw new RuntimeException(e);
        }
    }

    private String generatePartitionName(IdentityPartition partition) {
        Arrays.stream(partition.fieldNames()).forEach(fieldName -> Preconditions.checkArgument((((String[])fieldName).length == 1 ? 1 : 0) != 0, (Object)"Hive catalog does not support nested partition field names"));
        return IntStream.range(0, partition.fieldNames().length).mapToObj(i -> partition.fieldNames()[i][0] + PARTITION_VALUE_DELIMITER + partition.values()[i].value().toString()).collect(Collectors.joining(PARTITION_NAME_DELIMITER));
    }

    private org.apache.hadoop.hive.metastore.api.Partition toHivePartition(IdentityPartition partition) {
        StorageDescriptor sd;
        org.apache.hadoop.hive.metastore.api.Partition hivePartition = new org.apache.hadoop.hive.metastore.api.Partition();
        hivePartition.setDbName(this.table.schemaName());
        hivePartition.setTableName(this.table.name());
        if (this.table.storageDescriptor() == null) {
            sd = new StorageDescriptor();
            sd.setSerdeInfo(new SerDeInfo());
        } else {
            sd = this.table.storageDescriptor().deepCopy();
            sd.setLocation(null);
        }
        hivePartition.setSd(sd);
        hivePartition.setParameters(partition.properties());
        hivePartition.setValues(Arrays.stream(partition.values()).map(l -> l.value().toString()).collect(Collectors.toList()));
        return hivePartition;
    }

    public boolean dropPartition(String partitionName) {
        try {
            Table hiveTable = (Table)this.table.clientPool().run(c -> c.getTable(this.table.schemaName(), this.table.name()));
            List partitions = (List)this.table.clientPool().run(c -> c.listPartitions(this.table.schemaName(), this.table.name(), this.getFilterPartitionValueList(hiveTable, partitionName), (short)-1));
            if (partitions.isEmpty()) {
                throw new NoSuchPartitionException("Hive partition %s does not exist in Hive Metastore", new Object[]{partitionName});
            }
            for (org.apache.hadoop.hive.metastore.api.Partition partition : partitions) {
                this.table.clientPool().run(c -> c.dropPartition(partition.getDbName(), partition.getTableName(), partition.getValues(), false));
            }
        }
        catch (NoSuchPartitionException e) {
            return false;
        }
        catch (UnknownTableException e) {
            throw new NoSuchTableException((Throwable)e, "Hive table %s does not exist in Hive Metastore", new Object[]{this.table.name()});
        }
        catch (InterruptedException | TException e) {
            throw new RuntimeException("Failed to get partition " + partitionName + " of table " + this.table.name() + "from Hive Metastore", e);
        }
        return true;
    }

    private List<String> getFilterPartitionValueList(Table dropTable, String partitionSpec) throws NoSuchPartitionException, IllegalArgumentException {
        List partitionKeys = dropTable.getPartitionKeys().stream().map(FieldSchema::getName).collect(Collectors.toList());
        Map<String, String> partSpecMap = Arrays.stream(partitionSpec.split(PARTITION_NAME_DELIMITER)).map(part -> {
            String[] keyValue = part.split(PARTITION_VALUE_DELIMITER, 2);
            if (keyValue.length != 2) {
                throw new IllegalArgumentException("Error partition format: " + partitionSpec);
            }
            if (!partitionKeys.contains(keyValue[0])) {
                throw new NoSuchPartitionException("Hive partition %s does not exist in Hive Metastore", new Object[]{partitionSpec});
            }
            return keyValue;
        }).collect(Collectors.toMap(keyValue -> keyValue[0], keyValue -> keyValue[1]));
        List<String> partitionValues = partitionKeys.stream().map(key -> partSpecMap.getOrDefault(key, "")).collect(Collectors.toList());
        return partitionValues;
    }

    public void close() throws IOException {
        this.table.close();
    }

    private static /* synthetic */ String[][] lambda$getFieldNames$7(int x$0) {
        return new String[x$0][];
    }
}

