/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.transports;

import io.openlineage.client.OpenLineage;
import io.openlineage.client.OpenLineageClientUtils;
import io.openlineage.client.transports.FileConfig;
import io.openlineage.client.transports.Transport;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTransport
extends Transport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileTransport.class);
    File file;

    public FileTransport(@NonNull FileConfig fileConfig) {
        if (fileConfig == null) {
            throw new NullPointerException("fileConfig is marked non-null but is null");
        }
        this.file = new File(fileConfig.getLocation());
    }

    @Override
    public void emit(@NonNull OpenLineage.RunEvent runEvent) {
        if (runEvent == null) {
            throw new NullPointerException("runEvent is marked non-null but is null");
        }
        this.emit(OpenLineageClientUtils.toJson(runEvent));
    }

    @Override
    public void emit(@NonNull OpenLineage.DatasetEvent datasetEvent) {
        if (datasetEvent == null) {
            throw new NullPointerException("datasetEvent is marked non-null but is null");
        }
        this.emit(OpenLineageClientUtils.toJson(datasetEvent));
    }

    @Override
    public void emit(@NonNull OpenLineage.JobEvent jobEvent) {
        if (jobEvent == null) {
            throw new NullPointerException("jobEvent is marked non-null but is null");
        }
        this.emit(OpenLineageClientUtils.toJson(jobEvent));
    }

    private void emit(String eventAsJson) {
        try {
            Files.createDirectories(this.file.getParentFile().toPath(), new FileAttribute[0]);
            Files.write(this.file.toPath(), (eventAsJson.replace(System.lineSeparator(), "") + System.lineSeparator()).getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            log.debug("emitted event: " + eventAsJson);
        }
        catch (IOException | IllegalArgumentException e) {
            log.error("Writing event to a file {} failed: {}", (Object)this.file.getPath(), (Object)e);
        }
    }
}

