/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.ranger.plugin.util.ScriptEngineCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraalScriptEngineCreator
implements ScriptEngineCreator {
    private static final Logger LOG = LoggerFactory.getLogger(GraalScriptEngineCreator.class);
    static final String ENGINE_NAME = "graal.js";

    @Override
    public ScriptEngine getScriptEngine(ClassLoader clsLoader) {
        ScriptEngine ret = null;
        if (clsLoader == null) {
            clsLoader = Thread.currentThread().getContextClassLoader();
        }
        try {
            ScriptEngineManager mgr = new ScriptEngineManager(clsLoader);
            ret = mgr.getEngineByName(ENGINE_NAME);
            if (ret != null) {
                ret.getBindings(100).put("polyglot.js.allowHostAccess", (Object)Boolean.TRUE);
            }
        }
        catch (Throwable t) {
            LOG.debug("GraalScriptEngineCreator.getScriptEngine(): failed to create engine type {}", (Object)ENGINE_NAME, (Object)t);
        }
        if (ret == null) {
            LOG.debug("GraalScriptEngineCreator.getScriptEngine(): failed to create engine type {}", (Object)ENGINE_NAME);
        }
        return ret;
    }
}

