/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.responses;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.gravitino.dto.responses.BaseResponse;
import org.apache.gravitino.dto.stats.PartitionStatisticsDTO;

public class PartitionStatisticsListResponse
extends BaseResponse {
    @JsonProperty(value="partitionStatistics")
    private PartitionStatisticsDTO[] partitionStatistics;

    public PartitionStatisticsListResponse(PartitionStatisticsDTO[] partitionStatistics) {
        super(0);
        this.partitionStatistics = partitionStatistics;
    }

    public PartitionStatisticsListResponse() {
        this(null);
    }

    @Override
    public void validate() throws IllegalArgumentException {
        super.validate();
        Preconditions.checkArgument(this.partitionStatistics != null, "\"partitionStatistics\" must not be null");
        for (PartitionStatisticsDTO partitionStat : this.partitionStatistics) {
            Preconditions.checkArgument(partitionStat != null, "Each partition statistic must not be null");
            partitionStat.validate();
        }
    }

    public PartitionStatisticsDTO[] getPartitionStatistics() {
        return this.partitionStatistics;
    }

    @Override
    public String toString() {
        return "PartitionStatisticsListResponse(partitionStatistics=" + Arrays.deepToString(this.getPartitionStatistics()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PartitionStatisticsListResponse)) {
            return false;
        }
        PartitionStatisticsListResponse other = (PartitionStatisticsListResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.deepEquals(this.getPartitionStatistics(), other.getPartitionStatistics());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PartitionStatisticsListResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.deepHashCode(this.getPartitionStatistics());
        return result;
    }
}

