/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.writer;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.paimon.format.parquet.writer.PositionOutputStreamAdapter;
import org.apache.paimon.fs.PositionOutputStream;
import org.apache.paimon.shade.org.apache.parquet.io.OutputFile;
import org.apache.paimon.utils.Preconditions;

public class StreamOutputFile
implements OutputFile {
    private static final long DEFAULT_BLOCK_SIZE = 0x4000000L;
    private final PositionOutputStream stream;
    private final AtomicBoolean used;

    public StreamOutputFile(PositionOutputStream stream) {
        this.stream = (PositionOutputStream)Preconditions.checkNotNull((Object)stream);
        this.used = new AtomicBoolean(false);
    }

    @Override
    public org.apache.paimon.shade.org.apache.parquet.io.PositionOutputStream create(long blockSizeHint) {
        if (this.used.compareAndSet(false, true)) {
            return new PositionOutputStreamAdapter(this.stream);
        }
        throw new IllegalStateException("A stream against this file was already created.");
    }

    @Override
    public org.apache.paimon.shade.org.apache.parquet.io.PositionOutputStream createOrOverwrite(long blockSizeHint) {
        return this.create(blockSizeHint);
    }

    @Override
    public boolean supportsBlockSize() {
        return false;
    }

    @Override
    public long defaultBlockSize() {
        return 0x4000000L;
    }
}

