/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization.ranger;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.gravitino.authorization.ranger.RangerAuthorizationHDFSPlugin;
import org.apache.gravitino.authorization.ranger.RangerAuthorizationHadoopSQLPlugin;
import org.apache.gravitino.connector.authorization.AuthorizationPlugin;
import org.apache.gravitino.connector.authorization.BaseAuthorization;

public class RangerAuthorization
extends BaseAuthorization<RangerAuthorization> {
    public String shortName() {
        return "ranger";
    }

    public AuthorizationPlugin newPlugin(String metalake, String catalogProvider, Map<String, String> properties) {
        String serviceType;
        Preconditions.checkArgument((boolean)properties.containsKey("authorization.ranger.service.type"), (Object)String.format("%s is required", "authorization.ranger.service.type"));
        switch (serviceType = properties.get("authorization.ranger.service.type").toUpperCase()) {
            case "HADOOPSQL": {
                return new RangerAuthorizationHadoopSQLPlugin(metalake, properties);
            }
            case "HDFS": {
                return new RangerAuthorizationHDFSPlugin(metalake, properties);
            }
        }
        throw new IllegalArgumentException("Unsupported service type: " + serviceType);
    }
}

