/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.index;

import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Index {
    private final UUID uuid;
    private final List<Integer> fields;
    private final String name;
    private final long datasetVersion;
    private final byte[] fragmentBitmap;
    private final byte[] indexDetails;
    private final int indexVersion;
    private final Instant createdAt;

    private Index(UUID uuid, List<Integer> fields, String name, long datasetVersion, byte[] fragmentBitmap, byte[] indexDetails, int indexVersion, Instant createdAt) {
        this.uuid = uuid;
        this.fields = fields;
        this.name = name;
        this.datasetVersion = datasetVersion;
        this.fragmentBitmap = fragmentBitmap;
        this.indexDetails = indexDetails;
        this.indexVersion = indexVersion;
        this.createdAt = createdAt;
    }

    public UUID uuid() {
        return this.uuid;
    }

    public List<Integer> fields() {
        return this.fields;
    }

    public String name() {
        return this.name;
    }

    public long datasetVersion() {
        return this.datasetVersion;
    }

    public Optional<byte[]> fragmentBitmap() {
        return Optional.ofNullable(this.fragmentBitmap);
    }

    public Optional<byte[]> indexDetails() {
        return Optional.ofNullable(this.indexDetails);
    }

    public int indexVersion() {
        return this.indexVersion;
    }

    public Optional<Instant> createdAt() {
        return Optional.ofNullable(this.createdAt);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Index index = (Index)o;
        return this.datasetVersion == index.datasetVersion && this.indexVersion == index.indexVersion && Objects.equals(this.uuid, index.uuid) && Objects.equals(this.fields, index.fields) && Objects.equals(this.name, index.name) && Arrays.equals(this.fragmentBitmap, index.fragmentBitmap) && Arrays.equals(this.indexDetails, index.indexDetails) && Objects.equals(this.createdAt, index.createdAt);
    }

    public int hashCode() {
        int result = Objects.hash(this.uuid, this.fields, this.name, this.datasetVersion, this.indexVersion, this.createdAt);
        result = 31 * result + Arrays.hashCode(this.fragmentBitmap);
        result = 31 * result + Arrays.hashCode(this.indexDetails);
        return result;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("uuid", (Object)this.uuid).append("fields", this.fields).append("name", (Object)this.name).append("datasetVersion", this.datasetVersion).append("indexVersion", this.indexVersion).append("createdAt", (Object)this.createdAt).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private UUID uuid;
        private List<Integer> fields;
        private String name;
        private long datasetVersion;
        private byte[] fragmentBitmap;
        private byte[] indexDetails;
        private int indexVersion;
        private Instant createdAt;

        private Builder() {
        }

        public Builder uuid(UUID uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder fields(List<Integer> fields) {
            this.fields = fields;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder datasetVersion(long datasetVersion) {
            this.datasetVersion = datasetVersion;
            return this;
        }

        public Builder fragmentBitmap(byte[] fragmentBitmap) {
            this.fragmentBitmap = fragmentBitmap;
            return this;
        }

        public Builder indexDetails(byte[] indexDetails) {
            this.indexDetails = indexDetails;
            return this;
        }

        public Builder indexVersion(int indexVersion) {
            this.indexVersion = indexVersion;
            return this;
        }

        public Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Index build() {
            return new Index(this.uuid, this.fields, this.name, this.datasetVersion, this.fragmentBitmap, this.indexDetails, this.indexVersion, this.createdAt);
        }
    }
}

