/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.server.preauth.token;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.List;
import org.apache.kerby.kerberos.kerb.KrbCodec;
import org.apache.kerby.kerberos.kerb.KrbErrorCode;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.KrbRuntime;
import org.apache.kerby.kerberos.kerb.common.EncryptionUtil;
import org.apache.kerby.kerberos.kerb.common.PrivateKeyReader;
import org.apache.kerby.kerberos.kerb.common.PublicKeyReader;
import org.apache.kerby.kerberos.kerb.preauth.PluginRequestContext;
import org.apache.kerby.kerberos.kerb.preauth.PreauthPluginMeta;
import org.apache.kerby.kerberos.kerb.preauth.token.TokenPreauthMeta;
import org.apache.kerby.kerberos.kerb.provider.TokenDecoder;
import org.apache.kerby.kerberos.kerb.server.preauth.AbstractPreauthPlugin;
import org.apache.kerby.kerberos.kerb.server.request.KdcRequest;
import org.apache.kerby.kerberos.kerb.type.base.AuthToken;
import org.apache.kerby.kerberos.kerb.type.base.EncryptedData;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.kerby.kerberos.kerb.type.base.KeyUsage;
import org.apache.kerby.kerberos.kerb.type.base.KrbTokenBase;
import org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import org.apache.kerby.kerberos.kerb.type.pa.PaDataEntry;
import org.apache.kerby.kerberos.kerb.type.pa.PaDataType;
import org.apache.kerby.kerberos.kerb.type.pa.token.PaTokenRequest;
import org.apache.kerby.kerberos.kerb.type.pa.token.TokenInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenPreauth
extends AbstractPreauthPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(TokenPreauth.class);

    public TokenPreauth() {
        super((PreauthPluginMeta)new TokenPreauthMeta());
    }

    @Override
    public boolean verify(KdcRequest kdcRequest, PluginRequestContext requestContext, PaDataEntry paData) throws KrbException {
        if (!kdcRequest.getKdcContext().getConfig().isAllowTokenPreauth()) {
            throw new KrbException(KrbErrorCode.TOKEN_PREAUTH_NOT_ALLOWED, "Token preauth is not allowed.");
        }
        if (paData.getPaDataType() == PaDataType.TOKEN_REQUEST) {
            AuthToken authToken;
            PaTokenRequest paTokenRequest;
            if (kdcRequest.isHttps()) {
                paTokenRequest = (PaTokenRequest)KrbCodec.decode((byte[])paData.getPaDataValue(), PaTokenRequest.class);
            } else {
                EncryptedData encData = (EncryptedData)KrbCodec.decode((byte[])paData.getPaDataValue(), EncryptedData.class);
                EncryptionKey clientKey = kdcRequest.getArmorKey();
                kdcRequest.setClientKey(clientKey);
                paTokenRequest = (PaTokenRequest)EncryptionUtil.unseal((EncryptedData)encData, (EncryptionKey)clientKey, (KeyUsage)KeyUsage.PA_TOKEN, PaTokenRequest.class);
            }
            KrbTokenBase token = paTokenRequest.getToken();
            List<String> issuers = kdcRequest.getKdcContext().getConfig().getIssuers();
            TokenInfo tokenInfo = paTokenRequest.getTokenInfo();
            String issuer = tokenInfo.getTokenVendor();
            if (!issuers.contains(issuer)) {
                throw new KrbException("Unconfigured issuer: " + issuer);
            }
            TokenDecoder tokenDecoder = KrbRuntime.getTokenProvider((String)"JWT").createTokenDecoder();
            this.configureKeys(tokenDecoder, kdcRequest, issuer);
            try {
                authToken = tokenDecoder.decodeFromBytes(token.getTokenValue());
                if (!tokenDecoder.isSigned() && !kdcRequest.isHttps()) {
                    throw new KrbException("Token should be signed.");
                }
            }
            catch (IOException e) {
                throw new KrbException("Decoding failed", (Throwable)e);
            }
            if (authToken == null) {
                throw new KrbException("Token Decoding failed");
            }
            List audiences = authToken.getAudiences();
            PrincipalName serverPrincipal = kdcRequest.getKdcReq().getReqBody().getSname();
            serverPrincipal.setRealm(kdcRequest.getKdcReq().getReqBody().getRealm());
            kdcRequest.setServerPrincipal(serverPrincipal);
            if (audiences == null || !audiences.contains(serverPrincipal.getName())) {
                throw new KrbException("The token audience does not match with the target server principal! Server principal is: " + serverPrincipal);
            }
            kdcRequest.setToken(authToken);
            return true;
        }
        return false;
    }

    private void configureKeys(TokenDecoder tokenDecoder, KdcRequest kdcRequest, String issuer) {
        String decryptionKeyPath;
        String verifyKeyPath = kdcRequest.getKdcContext().getConfig().getVerifyKeyConfig();
        if (verifyKeyPath != null) {
            try (InputStream verifyKeyFile = this.getKeyFileStream(verifyKeyPath, issuer);){
                if (verifyKeyFile != null) {
                    PublicKey verifyKey = PublicKeyReader.loadPublicKey((InputStream)verifyKeyFile);
                    tokenDecoder.setVerifyKey(verifyKey);
                }
            }
            catch (FileNotFoundException e) {
                LOG.error("The verify key path is wrong. " + e.getMessage());
            }
            catch (Exception e) {
                LOG.error("Failed to load public key. " + e.getMessage());
            }
        }
        if ((decryptionKeyPath = kdcRequest.getKdcContext().getConfig().getDecryptionKeyConfig()) != null) {
            try (InputStream decryptionKeyFile = this.getKeyFileStream(decryptionKeyPath, issuer);){
                if (decryptionKeyFile != null) {
                    PrivateKey decryptionKey = PrivateKeyReader.loadPrivateKey((InputStream)decryptionKeyFile);
                    tokenDecoder.setDecryptionKey(decryptionKey);
                }
            }
            catch (FileNotFoundException e) {
                LOG.error("The decryption key path is wrong. " + e);
            }
            catch (Exception e) {
                LOG.error("Fail to load private key. " + e);
            }
        }
    }

    private InputStream getKeyFileStream(String path, String issuer) throws IOException {
        File file = new File(path);
        if (file.isDirectory()) {
            File[] listOfFiles = file.listFiles();
            File verifyKeyFile = null;
            if (listOfFiles == null) {
                throw new FileNotFoundException("The key path is incorrect");
            }
            for (File f : listOfFiles) {
                if (!f.isFile() || !f.getName().contains(issuer)) continue;
                verifyKeyFile = f;
                break;
            }
            if (verifyKeyFile == null) {
                throw new FileNotFoundException("No key found that matches the issuer name");
            }
            return Files.newInputStream(verifyKeyFile.toPath(), new OpenOption[0]);
        }
        if (file.isFile()) {
            return Files.newInputStream(file.toPath(), new OpenOption[0]);
        }
        return this.getClass().getClassLoader().getResourceAsStream(path);
    }
}

