/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.lock;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.lock.LockType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeLockNode {
    public static final Logger LOG = LoggerFactory.getLogger(TreeLockNode.class);
    private final String name;
    private final ReentrantReadWriteLock readWriteLock;
    @VisibleForTesting
    final Map<String, TreeLockNode> childMap;
    private final Map<ThreadIdentifier, Long> holdingThreadTimestamp = new ConcurrentHashMap<ThreadIdentifier, Long>();
    private final AtomicLong referenceCount = new AtomicLong();

    protected TreeLockNode(String name) {
        this.name = name;
        this.readWriteLock = new ReentrantReadWriteLock();
        this.childMap = new ConcurrentHashMap<String, TreeLockNode>();
    }

    public String getName() {
        return this.name;
    }

    Map<ThreadIdentifier, Long> getHoldingThreadTimestamp() {
        return this.holdingThreadTimestamp;
    }

    void addHoldingThreadTimestamp(Thread currentThread, NameIdentifier identifier, long timestamp) {
        this.holdingThreadTimestamp.put(ThreadIdentifier.of(currentThread, identifier), timestamp);
    }

    long removeHoldingThreadTimestamp(Thread currentThread, NameIdentifier identifier) {
        return this.holdingThreadTimestamp.remove(ThreadIdentifier.of(currentThread, identifier));
    }

    synchronized void addReference() {
        this.referenceCount.getAndIncrement();
    }

    synchronized void decReference() {
        this.referenceCount.getAndDecrement();
    }

    long getReference() {
        return this.referenceCount.get();
    }

    void lock(LockType lockType) {
        if (lockType == LockType.READ) {
            this.readWriteLock.readLock().lock();
        } else {
            this.readWriteLock.writeLock().lock();
        }
    }

    void unlock(LockType lockType) {
        if (lockType == LockType.READ) {
            this.readWriteLock.readLock().unlock();
        } else {
            this.readWriteLock.writeLock().unlock();
        }
        this.referenceCount.decrementAndGet();
    }

    Pair<TreeLockNode, Boolean> getOrCreateChild(String name) {
        boolean[] newCreated = new boolean[]{false};
        TreeLockNode childNode = this.childMap.computeIfAbsent(name, k -> {
            TreeLockNode newNode = new TreeLockNode(name);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Create tree lock node '{}' as a child of '{}'", (Object)name, (Object)this.name);
            }
            newCreated[0] = true;
            return newNode;
        });
        childNode.addReference();
        return Pair.of((Object)childNode, (Object)newCreated[0]);
    }

    synchronized List<TreeLockNode> getAllChildren() {
        ArrayList children = Lists.newArrayList(this.childMap.values());
        Collections.shuffle(children);
        return Collections.unmodifiableList(children);
    }

    void removeChild(String name) {
        this.childMap.remove(name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TreeLockNode{");
        sb.append("ident=").append(this.name).append(",");
        sb.append("hashCode=").append(this.hashCode());
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TreeLockNode)) {
            return false;
        }
        TreeLockNode that = (TreeLockNode)o;
        return Objects.equal((Object)this.name, (Object)that.name);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name});
    }

    static class ThreadIdentifier {
        private final Thread thread;
        private final NameIdentifier ident;

        public ThreadIdentifier(Thread thread, NameIdentifier ident) {
            this.thread = thread;
            this.ident = ident;
        }

        static ThreadIdentifier of(Thread thread, NameIdentifier identifier) {
            return new ThreadIdentifier(thread, identifier);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ThreadIdentifier)) {
                return false;
            }
            ThreadIdentifier that = (ThreadIdentifier)o;
            return Objects.equal((Object)this.thread, (Object)that.thread) && Objects.equal((Object)this.ident, (Object)that.ident);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.thread, this.ident});
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("ThreadIdentifier{");
            sb.append("thread=").append(this.thread);
            sb.append(", ident=").append(this.ident);
            sb.append('}');
            return sb.toString();
        }
    }
}

