/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization.jdbc;

import java.util.List;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.authorization.AuthorizationPrivilege;
import org.apache.gravitino.authorization.AuthorizationSecurableObject;
import org.apache.gravitino.authorization.jdbc.JdbcMetadataObject;

public class JdbcSecurableObject
extends JdbcMetadataObject
implements AuthorizationSecurableObject {
    public static final String ALL = "*";
    List<AuthorizationPrivilege> privileges;

    private JdbcSecurableObject(String parent, String name, JdbcMetadataObject.Type type, List<AuthorizationPrivilege> privileges) {
        super(parent, name, type);
        this.privileges = privileges;
    }

    public static JdbcSecurableObject create(String schema, String table, List<AuthorizationPrivilege> privileges) {
        String parent = table == null ? null : schema;
        String name = table == null ? schema : table;
        JdbcMetadataObject.Type type = table == null ? JdbcMetadataObject.Type.fromMetadataType(MetadataObject.Type.SCHEMA) : JdbcMetadataObject.Type.fromMetadataType(MetadataObject.Type.TABLE);
        JdbcSecurableObject object = new JdbcSecurableObject(parent, name, type, privileges);
        object.validateAuthorizationMetadataObject();
        return object;
    }

    public List<AuthorizationPrivilege> privileges() {
        return this.privileges;
    }
}

