/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.partition.actions;

import java.io.Closeable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.partition.actions.AddDonePartitionAction;
import org.apache.paimon.partition.actions.HttpReportMarkDoneAction;
import org.apache.paimon.partition.actions.MarkPartitionDoneEventAction;
import org.apache.paimon.partition.actions.SuccessFileMarkDoneAction;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.PartitionHandler;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.StringUtils;

public interface PartitionMarkDoneAction
extends Closeable {
    default public void open(FileStoreTable fileStoreTable, CoreOptions options) {
    }

    public void markDone(String var1) throws Exception;

    public static List<PartitionMarkDoneAction> createActions(ClassLoader cl, FileStoreTable fileStoreTable, CoreOptions options) {
        return options.partitionMarkDoneActions().stream().map(action -> {
            PartitionMarkDoneAction instance;
            switch (action) {
                case SUCCESS_FILE: {
                    instance = new SuccessFileMarkDoneAction(fileStoreTable.fileIO(), fileStoreTable.location());
                    break;
                }
                case DONE_PARTITION: {
                    instance = new AddDonePartitionAction(PartitionMarkDoneAction.createPartitionHandler(fileStoreTable, options));
                    break;
                }
                case MARK_EVENT: {
                    instance = new MarkPartitionDoneEventAction(PartitionMarkDoneAction.createPartitionHandler(fileStoreTable, options));
                    break;
                }
                case HTTP_REPORT: {
                    instance = new HttpReportMarkDoneAction();
                    break;
                }
                case CUSTOM: {
                    instance = PartitionMarkDoneAction.generateCustomMarkDoneAction(cl, options);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(action.toString());
                }
            }
            instance.open(fileStoreTable, options);
            return instance;
        }).collect(Collectors.toList());
    }

    public static PartitionMarkDoneAction generateCustomMarkDoneAction(ClassLoader cl, CoreOptions options) {
        if (StringUtils.isNullOrWhitespaceOnly((String)options.partitionMarkDoneCustomClass())) {
            throw new IllegalArgumentException(String.format("You need to set [%s] when you add [%s] mark done action in your property [%s].", CoreOptions.PARTITION_MARK_DONE_CUSTOM_CLASS.key(), CoreOptions.PartitionMarkDoneAction.CUSTOM, CoreOptions.PARTITION_MARK_DONE_ACTION.key()));
        }
        String customClass = options.partitionMarkDoneCustomClass();
        try {
            return (PartitionMarkDoneAction)cl.loadClass(customClass).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Can not create new instance for custom class from " + customClass, e);
        }
    }

    public static PartitionHandler createPartitionHandler(FileStoreTable table, CoreOptions options) {
        PartitionHandler partitionHandler = table.catalogEnvironment().partitionHandler();
        if (((String)options.toConfiguration().get(CoreOptions.PARTITION_MARK_DONE_ACTION)).contains("done-partition")) {
            Preconditions.checkNotNull((Object)partitionHandler, (String)"Cannot mark done partition for table without metastore.");
            Preconditions.checkArgument((boolean)options.partitionedTableInMetastore(), (String)"Table should enable %s", (Object[])new Object[]{CoreOptions.METASTORE_PARTITIONED_TABLE.key()});
        }
        return partitionHandler;
    }
}

