/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.structured;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.boot.json.JsonWriter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ContextPairs {
    private final boolean include;
    private final String prefix;

    ContextPairs(boolean include, String prefix) {
        this.include = include;
        this.prefix = prefix != null ? prefix : "";
    }

    public <T> BiConsumer<T, BiConsumer<String, Object>> flat(String delimeter, Consumer<Pairs<T>> pairs) {
        return this.flat(this.joinWith(delimeter), pairs);
    }

    public <T> BiConsumer<T, BiConsumer<String, Object>> flat(BinaryOperator<String> joiner, Consumer<Pairs<T>> pairs) {
        return !this.include ? this.none() : new Pairs<T>(joiner, pairs)::flat;
    }

    public <T> BiConsumer<T, BiConsumer<String, Object>> nested(Consumer<Pairs<T>> pairs) {
        return !this.include ? this.none() : new Pairs<T>(this.joinWith("."), pairs)::nested;
    }

    private <T, V> BiConsumer<T, BiConsumer<String, V>> none() {
        return (item, pairs) -> {};
    }

    private BinaryOperator<String> joinWith(String delimeter) {
        return (prefix, name) -> {
            StringBuilder joined = new StringBuilder(prefix.length() + delimeter.length() + name.length());
            joined.append((String)prefix);
            if (!(prefix.isEmpty() || prefix.endsWith(delimeter) || name.startsWith(delimeter))) {
                joined.append(delimeter);
            }
            joined.append((String)name);
            return joined.toString();
        };
    }

    public class Pairs<T> {
        private final BinaryOperator<String> joiner;
        private final List<BiConsumer<T, BiConsumer<String, ?>>> addedPairs;

        Pairs(BinaryOperator<String> joiner, Consumer<Pairs<T>> pairs) {
            this.joiner = joiner;
            this.addedPairs = new ArrayList();
            pairs.accept(this);
        }

        public <K, V> void addMapEntries(Function<T, Map<String, V>> extractor) {
            this.add(extractor.andThen(Map::entrySet), Map.Entry::getKey, Map.Entry::getValue);
        }

        public <E, V> void add(Function<T, Iterable<E>> elementsExtractor, JsonWriter.PairExtractor<E> pairExtractor) {
            this.add(elementsExtractor, pairExtractor::getName, pairExtractor::getValue);
        }

        public <E, V> void add(Function<T, Iterable<E>> elementsExtractor, Function<E, String> nameExtractor, Function<E, V> valueExtractor) {
            this.add((item, pairs) -> {
                Iterable elements = (Iterable)elementsExtractor.apply(item);
                if (elements != null) {
                    elements.forEach(element -> {
                        String name = (String)nameExtractor.apply(element);
                        Object value = valueExtractor.apply(element);
                        pairs.accept(name, value);
                    });
                }
            });
        }

        public <V> void add(BiConsumer<T, BiConsumer<String, V>> pairs) {
            this.addedPairs.add(pairs);
        }

        void flat(T item, BiConsumer<String, Object> pairs) {
            this.addedPairs.forEach(action -> action.accept(item, this.joining(pairs)));
        }

        void nested(T item, BiConsumer<String, Object> pairs) {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            this.addedPairs.forEach(addedPair -> addedPair.accept(item, this.joining((name, value) -> {
                List<String> nameParts = List.of(name.split("\\."));
                Map destination = result;
                for (int i2 = 0; i2 < nameParts.size() - 1; ++i2) {
                    Object existing = destination.computeIfAbsent(nameParts.get(i2), key -> new LinkedHashMap());
                    if (!(existing instanceof Map)) {
                        String common = nameParts.subList(0, i2 + 1).stream().collect(Collectors.joining("."));
                        throw new IllegalStateException("Duplicate nested pairs added under '%s'".formatted(common));
                    }
                    destination = (Map)existing;
                }
                Object previous = destination.put(nameParts.get(nameParts.size() - 1), value);
                Assert.state(previous == null, () -> "Duplicate nested pairs added under '%s'".formatted(name));
            })));
            result.forEach(pairs::accept);
        }

        private <V> BiConsumer<String, V> joining(BiConsumer<String, V> pairs) {
            return (name, value) -> {
                if (StringUtils.hasLength(name = (String)this.joiner.apply(ContextPairs.this.prefix, name != null ? name : ""))) {
                    pairs.accept((String)name, (Object)value);
                }
            };
        }
    }
}

