/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.feature.build.gradle;

import jakarta.inject.Singleton;
import org.grails.forge.application.ApplicationType;
import org.grails.forge.application.generator.GeneratorContext;
import org.grails.forge.build.dependencies.CoordinateResolver;
import org.grails.forge.build.gradle.GradleBuild;
import org.grails.forge.build.gradle.GradleBuildCreator;
import org.grails.forge.feature.build.gradle.GradleBuildSrcFeature;
import org.grails.forge.feature.build.gradle.templates.buildSrcBuildGradle;
import org.grails.forge.options.BuildTool;
import org.grails.forge.template.RockerTemplate;
import org.grails.forge.util.VersionInfo;

@Singleton
public class GradleBuildSrc
implements GradleBuildSrcFeature {
    private final GradleBuildCreator dependencyResolver;
    private final CoordinateResolver resolver;

    public GradleBuildSrc(GradleBuildCreator dependencyResolver, CoordinateResolver resolver) {
        this.dependencyResolver = dependencyResolver;
        this.resolver = resolver;
    }

    @Override
    public String getName() {
        return "gradle-build-src";
    }

    @Override
    public String getTitle() {
        return "Gradle buildSrc";
    }

    @Override
    public String getDescription() {
        return "Add a Gradle buildSrc/build.gradle file instead of the buildscript block in the main build.gradle.";
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public void apply(GeneratorContext generatorContext) {
        BuildTool buildTool = BuildTool.DEFAULT_OPTION;
        GradleBuild build = this.dependencyResolver.create(generatorContext);
        generatorContext.addTemplate("buildSrc/build", new RockerTemplate("buildSrc/" + buildTool.getBuildFileName(), buildSrcBuildGradle.template(generatorContext.getApplicationType(), generatorContext.getProject(), generatorContext.getFeatures(), build, VersionInfo.getGrailsVersion())));
    }

    @Override
    public boolean supports(ApplicationType applicationType) {
        return true;
    }
}

