/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.14.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.fineract.client.models.CurrencyData;
import org.apache.fineract.client.models.LoanSchedulePeriodData;

/**
 * LoanScheduleData
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class LoanScheduleData {
  public static final String SERIALIZED_NAME_CURRENCY = "currency";
  @SerializedName(SERIALIZED_NAME_CURRENCY)
  private CurrencyData currency;

  public static final String SERIALIZED_NAME_FUTURE_PERIODS = "futurePeriods";
  @SerializedName(SERIALIZED_NAME_FUTURE_PERIODS)
  private List<LoanSchedulePeriodData> futurePeriods;

  public static final String SERIALIZED_NAME_LOAN_TERM_IN_DAYS = "loanTermInDays";
  @SerializedName(SERIALIZED_NAME_LOAN_TERM_IN_DAYS)
  private Integer loanTermInDays;

  public static final String SERIALIZED_NAME_PERIODS = "periods";
  @SerializedName(SERIALIZED_NAME_PERIODS)
  private List<LoanSchedulePeriodData> periods;

  public static final String SERIALIZED_NAME_TOTAL_CREDITS = "totalCredits";
  @SerializedName(SERIALIZED_NAME_TOTAL_CREDITS)
  private BigDecimal totalCredits;

  public static final String SERIALIZED_NAME_TOTAL_FEE_CHARGES_CHARGED = "totalFeeChargesCharged";
  @SerializedName(SERIALIZED_NAME_TOTAL_FEE_CHARGES_CHARGED)
  private BigDecimal totalFeeChargesCharged;

  public static final String SERIALIZED_NAME_TOTAL_INTEREST_CHARGED = "totalInterestCharged";
  @SerializedName(SERIALIZED_NAME_TOTAL_INTEREST_CHARGED)
  private BigDecimal totalInterestCharged;

  public static final String SERIALIZED_NAME_TOTAL_OUTSTANDING = "totalOutstanding";
  @SerializedName(SERIALIZED_NAME_TOTAL_OUTSTANDING)
  private BigDecimal totalOutstanding;

  public static final String SERIALIZED_NAME_TOTAL_PAID_IN_ADVANCE = "totalPaidInAdvance";
  @SerializedName(SERIALIZED_NAME_TOTAL_PAID_IN_ADVANCE)
  private BigDecimal totalPaidInAdvance;

  public static final String SERIALIZED_NAME_TOTAL_PAID_LATE = "totalPaidLate";
  @SerializedName(SERIALIZED_NAME_TOTAL_PAID_LATE)
  private BigDecimal totalPaidLate;

  public static final String SERIALIZED_NAME_TOTAL_PENALTY_CHARGES_CHARGED = "totalPenaltyChargesCharged";
  @SerializedName(SERIALIZED_NAME_TOTAL_PENALTY_CHARGES_CHARGED)
  private BigDecimal totalPenaltyChargesCharged;

  public static final String SERIALIZED_NAME_TOTAL_PRINCIPAL_DISBURSED = "totalPrincipalDisbursed";
  @SerializedName(SERIALIZED_NAME_TOTAL_PRINCIPAL_DISBURSED)
  private BigDecimal totalPrincipalDisbursed;

  public static final String SERIALIZED_NAME_TOTAL_PRINCIPAL_EXPECTED = "totalPrincipalExpected";
  @SerializedName(SERIALIZED_NAME_TOTAL_PRINCIPAL_EXPECTED)
  private BigDecimal totalPrincipalExpected;

  public static final String SERIALIZED_NAME_TOTAL_PRINCIPAL_PAID = "totalPrincipalPaid";
  @SerializedName(SERIALIZED_NAME_TOTAL_PRINCIPAL_PAID)
  private BigDecimal totalPrincipalPaid;

  public static final String SERIALIZED_NAME_TOTAL_REPAYMENT = "totalRepayment";
  @SerializedName(SERIALIZED_NAME_TOTAL_REPAYMENT)
  private BigDecimal totalRepayment;

  public static final String SERIALIZED_NAME_TOTAL_REPAYMENT_EXPECTED = "totalRepaymentExpected";
  @SerializedName(SERIALIZED_NAME_TOTAL_REPAYMENT_EXPECTED)
  private BigDecimal totalRepaymentExpected;

  public static final String SERIALIZED_NAME_TOTAL_WAIVED = "totalWaived";
  @SerializedName(SERIALIZED_NAME_TOTAL_WAIVED)
  private BigDecimal totalWaived;

  public static final String SERIALIZED_NAME_TOTAL_WRITTEN_OFF = "totalWrittenOff";
  @SerializedName(SERIALIZED_NAME_TOTAL_WRITTEN_OFF)
  private BigDecimal totalWrittenOff;

  public LoanScheduleData() {
  }

  public LoanScheduleData currency(CurrencyData currency) {
    
    this.currency = currency;
    return this;
  }

  /**
   * Get currency
   * @return currency
   */
  @javax.annotation.Nullable

  public CurrencyData getCurrency() {
    return currency;
  }


  public void setCurrency(CurrencyData currency) {
    this.currency = currency;
  }

  public LoanScheduleData futurePeriods(List<LoanSchedulePeriodData> futurePeriods) {
    
    this.futurePeriods = futurePeriods;
    return this;
  }

  public LoanScheduleData addFuturePeriodsItem(LoanSchedulePeriodData futurePeriodsItem) {
    if (this.futurePeriods == null) {
      this.futurePeriods = new ArrayList<>();
    }
    this.futurePeriods.add(futurePeriodsItem);
    return this;
  }

  /**
   * Get futurePeriods
   * @return futurePeriods
   */
  @javax.annotation.Nullable

  public List<LoanSchedulePeriodData> getFuturePeriods() {
    return futurePeriods;
  }


  public void setFuturePeriods(List<LoanSchedulePeriodData> futurePeriods) {
    this.futurePeriods = futurePeriods;
  }

  public LoanScheduleData loanTermInDays(Integer loanTermInDays) {
    
    this.loanTermInDays = loanTermInDays;
    return this;
  }

  /**
   * Get loanTermInDays
   * @return loanTermInDays
   */
  @javax.annotation.Nullable

  public Integer getLoanTermInDays() {
    return loanTermInDays;
  }


  public void setLoanTermInDays(Integer loanTermInDays) {
    this.loanTermInDays = loanTermInDays;
  }

  public LoanScheduleData periods(List<LoanSchedulePeriodData> periods) {
    
    this.periods = periods;
    return this;
  }

  public LoanScheduleData addPeriodsItem(LoanSchedulePeriodData periodsItem) {
    if (this.periods == null) {
      this.periods = new ArrayList<>();
    }
    this.periods.add(periodsItem);
    return this;
  }

  /**
   * Get periods
   * @return periods
   */
  @javax.annotation.Nullable

  public List<LoanSchedulePeriodData> getPeriods() {
    return periods;
  }


  public void setPeriods(List<LoanSchedulePeriodData> periods) {
    this.periods = periods;
  }

  public LoanScheduleData totalCredits(BigDecimal totalCredits) {
    
    this.totalCredits = totalCredits;
    return this;
  }

  /**
   * Get totalCredits
   * @return totalCredits
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalCredits() {
    return totalCredits;
  }


  public void setTotalCredits(BigDecimal totalCredits) {
    this.totalCredits = totalCredits;
  }

  public LoanScheduleData totalFeeChargesCharged(BigDecimal totalFeeChargesCharged) {
    
    this.totalFeeChargesCharged = totalFeeChargesCharged;
    return this;
  }

  /**
   * Get totalFeeChargesCharged
   * @return totalFeeChargesCharged
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalFeeChargesCharged() {
    return totalFeeChargesCharged;
  }


  public void setTotalFeeChargesCharged(BigDecimal totalFeeChargesCharged) {
    this.totalFeeChargesCharged = totalFeeChargesCharged;
  }

  public LoanScheduleData totalInterestCharged(BigDecimal totalInterestCharged) {
    
    this.totalInterestCharged = totalInterestCharged;
    return this;
  }

  /**
   * Get totalInterestCharged
   * @return totalInterestCharged
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalInterestCharged() {
    return totalInterestCharged;
  }


  public void setTotalInterestCharged(BigDecimal totalInterestCharged) {
    this.totalInterestCharged = totalInterestCharged;
  }

  public LoanScheduleData totalOutstanding(BigDecimal totalOutstanding) {
    
    this.totalOutstanding = totalOutstanding;
    return this;
  }

  /**
   * Get totalOutstanding
   * @return totalOutstanding
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalOutstanding() {
    return totalOutstanding;
  }


  public void setTotalOutstanding(BigDecimal totalOutstanding) {
    this.totalOutstanding = totalOutstanding;
  }

  public LoanScheduleData totalPaidInAdvance(BigDecimal totalPaidInAdvance) {
    
    this.totalPaidInAdvance = totalPaidInAdvance;
    return this;
  }

  /**
   * Get totalPaidInAdvance
   * @return totalPaidInAdvance
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalPaidInAdvance() {
    return totalPaidInAdvance;
  }


  public void setTotalPaidInAdvance(BigDecimal totalPaidInAdvance) {
    this.totalPaidInAdvance = totalPaidInAdvance;
  }

  public LoanScheduleData totalPaidLate(BigDecimal totalPaidLate) {
    
    this.totalPaidLate = totalPaidLate;
    return this;
  }

  /**
   * Get totalPaidLate
   * @return totalPaidLate
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalPaidLate() {
    return totalPaidLate;
  }


  public void setTotalPaidLate(BigDecimal totalPaidLate) {
    this.totalPaidLate = totalPaidLate;
  }

  public LoanScheduleData totalPenaltyChargesCharged(BigDecimal totalPenaltyChargesCharged) {
    
    this.totalPenaltyChargesCharged = totalPenaltyChargesCharged;
    return this;
  }

  /**
   * Get totalPenaltyChargesCharged
   * @return totalPenaltyChargesCharged
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalPenaltyChargesCharged() {
    return totalPenaltyChargesCharged;
  }


  public void setTotalPenaltyChargesCharged(BigDecimal totalPenaltyChargesCharged) {
    this.totalPenaltyChargesCharged = totalPenaltyChargesCharged;
  }

  public LoanScheduleData totalPrincipalDisbursed(BigDecimal totalPrincipalDisbursed) {
    
    this.totalPrincipalDisbursed = totalPrincipalDisbursed;
    return this;
  }

  /**
   * Get totalPrincipalDisbursed
   * @return totalPrincipalDisbursed
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalPrincipalDisbursed() {
    return totalPrincipalDisbursed;
  }


  public void setTotalPrincipalDisbursed(BigDecimal totalPrincipalDisbursed) {
    this.totalPrincipalDisbursed = totalPrincipalDisbursed;
  }

  public LoanScheduleData totalPrincipalExpected(BigDecimal totalPrincipalExpected) {
    
    this.totalPrincipalExpected = totalPrincipalExpected;
    return this;
  }

  /**
   * Get totalPrincipalExpected
   * @return totalPrincipalExpected
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalPrincipalExpected() {
    return totalPrincipalExpected;
  }


  public void setTotalPrincipalExpected(BigDecimal totalPrincipalExpected) {
    this.totalPrincipalExpected = totalPrincipalExpected;
  }

  public LoanScheduleData totalPrincipalPaid(BigDecimal totalPrincipalPaid) {
    
    this.totalPrincipalPaid = totalPrincipalPaid;
    return this;
  }

  /**
   * Get totalPrincipalPaid
   * @return totalPrincipalPaid
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalPrincipalPaid() {
    return totalPrincipalPaid;
  }


  public void setTotalPrincipalPaid(BigDecimal totalPrincipalPaid) {
    this.totalPrincipalPaid = totalPrincipalPaid;
  }

  public LoanScheduleData totalRepayment(BigDecimal totalRepayment) {
    
    this.totalRepayment = totalRepayment;
    return this;
  }

  /**
   * Get totalRepayment
   * @return totalRepayment
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalRepayment() {
    return totalRepayment;
  }


  public void setTotalRepayment(BigDecimal totalRepayment) {
    this.totalRepayment = totalRepayment;
  }

  public LoanScheduleData totalRepaymentExpected(BigDecimal totalRepaymentExpected) {
    
    this.totalRepaymentExpected = totalRepaymentExpected;
    return this;
  }

  /**
   * Get totalRepaymentExpected
   * @return totalRepaymentExpected
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalRepaymentExpected() {
    return totalRepaymentExpected;
  }


  public void setTotalRepaymentExpected(BigDecimal totalRepaymentExpected) {
    this.totalRepaymentExpected = totalRepaymentExpected;
  }

  public LoanScheduleData totalWaived(BigDecimal totalWaived) {
    
    this.totalWaived = totalWaived;
    return this;
  }

  /**
   * Get totalWaived
   * @return totalWaived
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalWaived() {
    return totalWaived;
  }


  public void setTotalWaived(BigDecimal totalWaived) {
    this.totalWaived = totalWaived;
  }

  public LoanScheduleData totalWrittenOff(BigDecimal totalWrittenOff) {
    
    this.totalWrittenOff = totalWrittenOff;
    return this;
  }

  /**
   * Get totalWrittenOff
   * @return totalWrittenOff
   */
  @javax.annotation.Nullable

  public BigDecimal getTotalWrittenOff() {
    return totalWrittenOff;
  }


  public void setTotalWrittenOff(BigDecimal totalWrittenOff) {
    this.totalWrittenOff = totalWrittenOff;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LoanScheduleData loanScheduleData = (LoanScheduleData) o;
    return Objects.equals(this.currency, loanScheduleData.currency) &&
        Objects.equals(this.futurePeriods, loanScheduleData.futurePeriods) &&
        Objects.equals(this.loanTermInDays, loanScheduleData.loanTermInDays) &&
        Objects.equals(this.periods, loanScheduleData.periods) &&
        Objects.equals(this.totalCredits, loanScheduleData.totalCredits) &&
        Objects.equals(this.totalFeeChargesCharged, loanScheduleData.totalFeeChargesCharged) &&
        Objects.equals(this.totalInterestCharged, loanScheduleData.totalInterestCharged) &&
        Objects.equals(this.totalOutstanding, loanScheduleData.totalOutstanding) &&
        Objects.equals(this.totalPaidInAdvance, loanScheduleData.totalPaidInAdvance) &&
        Objects.equals(this.totalPaidLate, loanScheduleData.totalPaidLate) &&
        Objects.equals(this.totalPenaltyChargesCharged, loanScheduleData.totalPenaltyChargesCharged) &&
        Objects.equals(this.totalPrincipalDisbursed, loanScheduleData.totalPrincipalDisbursed) &&
        Objects.equals(this.totalPrincipalExpected, loanScheduleData.totalPrincipalExpected) &&
        Objects.equals(this.totalPrincipalPaid, loanScheduleData.totalPrincipalPaid) &&
        Objects.equals(this.totalRepayment, loanScheduleData.totalRepayment) &&
        Objects.equals(this.totalRepaymentExpected, loanScheduleData.totalRepaymentExpected) &&
        Objects.equals(this.totalWaived, loanScheduleData.totalWaived) &&
        Objects.equals(this.totalWrittenOff, loanScheduleData.totalWrittenOff);
  }

  @Override
  public int hashCode() {
    return Objects.hash(currency, futurePeriods, loanTermInDays, periods, totalCredits, totalFeeChargesCharged, totalInterestCharged, totalOutstanding, totalPaidInAdvance, totalPaidLate, totalPenaltyChargesCharged, totalPrincipalDisbursed, totalPrincipalExpected, totalPrincipalPaid, totalRepayment, totalRepaymentExpected, totalWaived, totalWrittenOff);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LoanScheduleData {\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    futurePeriods: ").append(toIndentedString(futurePeriods)).append("\n");
    sb.append("    loanTermInDays: ").append(toIndentedString(loanTermInDays)).append("\n");
    sb.append("    periods: ").append(toIndentedString(periods)).append("\n");
    sb.append("    totalCredits: ").append(toIndentedString(totalCredits)).append("\n");
    sb.append("    totalFeeChargesCharged: ").append(toIndentedString(totalFeeChargesCharged)).append("\n");
    sb.append("    totalInterestCharged: ").append(toIndentedString(totalInterestCharged)).append("\n");
    sb.append("    totalOutstanding: ").append(toIndentedString(totalOutstanding)).append("\n");
    sb.append("    totalPaidInAdvance: ").append(toIndentedString(totalPaidInAdvance)).append("\n");
    sb.append("    totalPaidLate: ").append(toIndentedString(totalPaidLate)).append("\n");
    sb.append("    totalPenaltyChargesCharged: ").append(toIndentedString(totalPenaltyChargesCharged)).append("\n");
    sb.append("    totalPrincipalDisbursed: ").append(toIndentedString(totalPrincipalDisbursed)).append("\n");
    sb.append("    totalPrincipalExpected: ").append(toIndentedString(totalPrincipalExpected)).append("\n");
    sb.append("    totalPrincipalPaid: ").append(toIndentedString(totalPrincipalPaid)).append("\n");
    sb.append("    totalRepayment: ").append(toIndentedString(totalRepayment)).append("\n");
    sb.append("    totalRepaymentExpected: ").append(toIndentedString(totalRepaymentExpected)).append("\n");
    sb.append("    totalWaived: ").append(toIndentedString(totalWaived)).append("\n");
    sb.append("    totalWrittenOff: ").append(toIndentedString(totalWrittenOff)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

