/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.14.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.fineract.client.models.Charge;
import org.apache.fineract.client.models.DelinquencyBucket;
import org.apache.fineract.client.models.ExternalId;
import org.apache.fineract.client.models.Fund;
import org.apache.fineract.client.models.LoanProductBorrowerCycleVariations;
import org.apache.fineract.client.models.LoanProductConfigurableAttributes;
import org.apache.fineract.client.models.LoanProductCreditAllocationRule;
import org.apache.fineract.client.models.LoanProductFloatingRates;
import org.apache.fineract.client.models.LoanProductGuaranteeDetails;
import org.apache.fineract.client.models.LoanProductInterestRecalculationDetails;
import org.apache.fineract.client.models.LoanProductMinMaxConstraints;
import org.apache.fineract.client.models.LoanProductPaymentAllocationRule;
import org.apache.fineract.client.models.LoanProductRelatedDetail;
import org.apache.fineract.client.models.LoanProductTrancheDetails;
import org.apache.fineract.client.models.LoanProductVariableInstallmentConfig;
import org.apache.fineract.client.models.MonetaryCurrency;
import org.apache.fineract.client.models.Money;
import org.apache.fineract.client.models.Rate;

/**
 * LoanProduct
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class LoanProduct {
  public static final String SERIALIZED_NAME_ACCOUNT_MOVES_OUT_OF_N_P_A_ONLY_ON_ARREARS_COMPLETION = "accountMovesOutOfNPAOnlyOnArrearsCompletion";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_MOVES_OUT_OF_N_P_A_ONLY_ON_ARREARS_COMPLETION)
  private Boolean accountMovesOutOfNPAOnlyOnArrearsCompletion;

  public static final String SERIALIZED_NAME_ACCOUNTING_DISABLED = "accountingDisabled";
  @SerializedName(SERIALIZED_NAME_ACCOUNTING_DISABLED)
  private Boolean accountingDisabled;

  /**
   * Gets or Sets accountingRule
   */
  @JsonAdapter(AccountingRuleEnum.Adapter.class)
  public enum AccountingRuleEnum {
    NONE("NONE"),
    
    CASH_BASED("CASH BASED"),
    
    ACCRUAL_PERIODIC("ACCRUAL PERIODIC"),
    
    ACCRUAL_UPFRONT("ACCRUAL UPFRONT");

    private String value;

    AccountingRuleEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static AccountingRuleEnum fromValue(String value) {
      for (AccountingRuleEnum b : AccountingRuleEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<AccountingRuleEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final AccountingRuleEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public AccountingRuleEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return AccountingRuleEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_ACCOUNTING_RULE = "accountingRule";
  @SerializedName(SERIALIZED_NAME_ACCOUNTING_RULE)
  private AccountingRuleEnum accountingRule;

  public static final String SERIALIZED_NAME_ALLOW_APPROVED_DISBURSED_AMOUNTS_OVER_APPLIED = "allowApprovedDisbursedAmountsOverApplied";
  @SerializedName(SERIALIZED_NAME_ALLOW_APPROVED_DISBURSED_AMOUNTS_OVER_APPLIED)
  private Boolean allowApprovedDisbursedAmountsOverApplied;

  public static final String SERIALIZED_NAME_ALLOW_FULL_TERM_FOR_TRANCHE = "allowFullTermForTranche";
  @SerializedName(SERIALIZED_NAME_ALLOW_FULL_TERM_FOR_TRANCHE)
  private Boolean allowFullTermForTranche;

  public static final String SERIALIZED_NAME_ALLOW_VARIABE_INSTALLMENTS = "allowVariabeInstallments";
  @SerializedName(SERIALIZED_NAME_ALLOW_VARIABE_INSTALLMENTS)
  private Boolean allowVariabeInstallments;

  public static final String SERIALIZED_NAME_ARREARS_BASED_ON_ORIGINAL_SCHEDULE = "arrearsBasedOnOriginalSchedule";
  @SerializedName(SERIALIZED_NAME_ARREARS_BASED_ON_ORIGINAL_SCHEDULE)
  private Boolean arrearsBasedOnOriginalSchedule;

  public static final String SERIALIZED_NAME_BORROWER_CYCLE_VARIATIONS = "borrowerCycleVariations";
  @SerializedName(SERIALIZED_NAME_BORROWER_CYCLE_VARIATIONS)
  private Set<LoanProductBorrowerCycleVariations> borrowerCycleVariations;

  public static final String SERIALIZED_NAME_CAN_DEFINE_INSTALLMENT_AMOUNT = "canDefineInstallmentAmount";
  @SerializedName(SERIALIZED_NAME_CAN_DEFINE_INSTALLMENT_AMOUNT)
  private Boolean canDefineInstallmentAmount;

  public static final String SERIALIZED_NAME_CAN_USE_FOR_TOPUP = "canUseForTopup";
  @SerializedName(SERIALIZED_NAME_CAN_USE_FOR_TOPUP)
  private Boolean canUseForTopup;

  public static final String SERIALIZED_NAME_CASH_BASED_ACCOUNTING_ENABLED = "cashBasedAccountingEnabled";
  @SerializedName(SERIALIZED_NAME_CASH_BASED_ACCOUNTING_ENABLED)
  private Boolean cashBasedAccountingEnabled;

  public static final String SERIALIZED_NAME_CHARGES = "charges";
  @SerializedName(SERIALIZED_NAME_CHARGES)
  private List<Charge> charges;

  public static final String SERIALIZED_NAME_CLOSE_DATE = "closeDate";
  @SerializedName(SERIALIZED_NAME_CLOSE_DATE)
  private LocalDate closeDate;

  public static final String SERIALIZED_NAME_CREDIT_ALLOCATION_RULES = "creditAllocationRules";
  @SerializedName(SERIALIZED_NAME_CREDIT_ALLOCATION_RULES)
  private List<LoanProductCreditAllocationRule> creditAllocationRules;

  public static final String SERIALIZED_NAME_CURRENCY = "currency";
  @SerializedName(SERIALIZED_NAME_CURRENCY)
  private MonetaryCurrency currency;

  public static final String SERIALIZED_NAME_DELINQUENCY_BUCKET = "delinquencyBucket";
  @SerializedName(SERIALIZED_NAME_DELINQUENCY_BUCKET)
  private DelinquencyBucket delinquencyBucket;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_DISALLOW_EXPECTED_DISBURSEMENTS = "disallowExpectedDisbursements";
  @SerializedName(SERIALIZED_NAME_DISALLOW_EXPECTED_DISBURSEMENTS)
  private Boolean disallowExpectedDisbursements;

  public static final String SERIALIZED_NAME_DUE_DAYS_FOR_REPAYMENT_EVENT = "dueDaysForRepaymentEvent";
  @SerializedName(SERIALIZED_NAME_DUE_DAYS_FOR_REPAYMENT_EVENT)
  private Integer dueDaysForRepaymentEvent;

  public static final String SERIALIZED_NAME_ENABLE_INSTALLMENT_LEVEL_DELINQUENCY = "enableInstallmentLevelDelinquency";
  @SerializedName(SERIALIZED_NAME_ENABLE_INSTALLMENT_LEVEL_DELINQUENCY)
  private Boolean enableInstallmentLevelDelinquency;

  public static final String SERIALIZED_NAME_EQUAL_AMORTIZATION = "equalAmortization";
  @SerializedName(SERIALIZED_NAME_EQUAL_AMORTIZATION)
  private Boolean equalAmortization;

  public static final String SERIALIZED_NAME_EXTERNAL_ID = "externalId";
  @SerializedName(SERIALIZED_NAME_EXTERNAL_ID)
  private ExternalId externalId;

  public static final String SERIALIZED_NAME_FIXED_PRINCIPAL_PERCENTAGE_PER_INSTALLMENT = "fixedPrincipalPercentagePerInstallment";
  @SerializedName(SERIALIZED_NAME_FIXED_PRINCIPAL_PERCENTAGE_PER_INSTALLMENT)
  private BigDecimal fixedPrincipalPercentagePerInstallment;

  public static final String SERIALIZED_NAME_FLOATING_RATES = "floatingRates";
  @SerializedName(SERIALIZED_NAME_FLOATING_RATES)
  private LoanProductFloatingRates floatingRates;

  public static final String SERIALIZED_NAME_FUND = "fund";
  @SerializedName(SERIALIZED_NAME_FUND)
  private Fund fund;

  public static final String SERIALIZED_NAME_HOLD_GUARANTEE_FUNDS = "holdGuaranteeFunds";
  @SerializedName(SERIALIZED_NAME_HOLD_GUARANTEE_FUNDS)
  private Boolean holdGuaranteeFunds;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Long id;

  public static final String SERIALIZED_NAME_INCLUDE_IN_BORROWER_CYCLE = "includeInBorrowerCycle";
  @SerializedName(SERIALIZED_NAME_INCLUDE_IN_BORROWER_CYCLE)
  private Boolean includeInBorrowerCycle;

  /**
   * Gets or Sets interestPeriodFrequencyType
   */
  @JsonAdapter(InterestPeriodFrequencyTypeEnum.Adapter.class)
  public enum InterestPeriodFrequencyTypeEnum {
    DAYS("DAYS"),
    
    WEEKS("WEEKS"),
    
    MONTHS("MONTHS"),
    
    YEARS("YEARS"),
    
    WHOLE_TERM("WHOLE_TERM"),
    
    INVALID("INVALID");

    private String value;

    InterestPeriodFrequencyTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static InterestPeriodFrequencyTypeEnum fromValue(String value) {
      for (InterestPeriodFrequencyTypeEnum b : InterestPeriodFrequencyTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<InterestPeriodFrequencyTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final InterestPeriodFrequencyTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public InterestPeriodFrequencyTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return InterestPeriodFrequencyTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_INTEREST_PERIOD_FREQUENCY_TYPE = "interestPeriodFrequencyType";
  @SerializedName(SERIALIZED_NAME_INTEREST_PERIOD_FREQUENCY_TYPE)
  private InterestPeriodFrequencyTypeEnum interestPeriodFrequencyType;

  public static final String SERIALIZED_NAME_INTEREST_RECALCULATION_ENABLED = "interestRecalculationEnabled";
  @SerializedName(SERIALIZED_NAME_INTEREST_RECALCULATION_ENABLED)
  private Boolean interestRecalculationEnabled;

  public static final String SERIALIZED_NAME_LINKED_TO_FLOATING_INTEREST_RATE = "linkedToFloatingInterestRate";
  @SerializedName(SERIALIZED_NAME_LINKED_TO_FLOATING_INTEREST_RATE)
  private Boolean linkedToFloatingInterestRate;

  public static final String SERIALIZED_NAME_LOAN_CONFIGURABLE_ATTRIBUTES = "loanConfigurableAttributes";
  @SerializedName(SERIALIZED_NAME_LOAN_CONFIGURABLE_ATTRIBUTES)
  private LoanProductConfigurableAttributes loanConfigurableAttributes;

  public static final String SERIALIZED_NAME_LOAN_PRODUCT_GUARANTEE_DETAILS = "loanProductGuaranteeDetails";
  @SerializedName(SERIALIZED_NAME_LOAN_PRODUCT_GUARANTEE_DETAILS)
  private LoanProductGuaranteeDetails loanProductGuaranteeDetails;

  public static final String SERIALIZED_NAME_LOAN_PRODUCT_MIN_MAX_CONSTRAINTS = "loanProductMinMaxConstraints";
  @SerializedName(SERIALIZED_NAME_LOAN_PRODUCT_MIN_MAX_CONSTRAINTS)
  private LoanProductMinMaxConstraints loanProductMinMaxConstraints;

  public static final String SERIALIZED_NAME_LOAN_PRODUCT_RELATED_DETAIL = "loanProductRelatedDetail";
  @SerializedName(SERIALIZED_NAME_LOAN_PRODUCT_RELATED_DETAIL)
  private LoanProductRelatedDetail loanProductRelatedDetail;

  public static final String SERIALIZED_NAME_LOAN_PRODUCT_TRANCHE_DETAILS = "loanProductTrancheDetails";
  @SerializedName(SERIALIZED_NAME_LOAN_PRODUCT_TRANCHE_DETAILS)
  private LoanProductTrancheDetails loanProductTrancheDetails;

  public static final String SERIALIZED_NAME_MAX_NOMINAL_INTEREST_RATE_PER_PERIOD = "maxNominalInterestRatePerPeriod";
  @SerializedName(SERIALIZED_NAME_MAX_NOMINAL_INTEREST_RATE_PER_PERIOD)
  private BigDecimal maxNominalInterestRatePerPeriod;

  public static final String SERIALIZED_NAME_MAX_NUMBER_OF_REPAYMENTS = "maxNumberOfRepayments";
  @SerializedName(SERIALIZED_NAME_MAX_NUMBER_OF_REPAYMENTS)
  private Integer maxNumberOfRepayments;

  public static final String SERIALIZED_NAME_MAX_PRINCIPAL_AMOUNT = "maxPrincipalAmount";
  @SerializedName(SERIALIZED_NAME_MAX_PRINCIPAL_AMOUNT)
  private Money maxPrincipalAmount;

  public static final String SERIALIZED_NAME_MIN_NOMINAL_INTEREST_RATE_PER_PERIOD = "minNominalInterestRatePerPeriod";
  @SerializedName(SERIALIZED_NAME_MIN_NOMINAL_INTEREST_RATE_PER_PERIOD)
  private BigDecimal minNominalInterestRatePerPeriod;

  public static final String SERIALIZED_NAME_MIN_NUMBER_OF_REPAYMENTS = "minNumberOfRepayments";
  @SerializedName(SERIALIZED_NAME_MIN_NUMBER_OF_REPAYMENTS)
  private Integer minNumberOfRepayments;

  public static final String SERIALIZED_NAME_MIN_PRINCIPAL_AMOUNT = "minPrincipalAmount";
  @SerializedName(SERIALIZED_NAME_MIN_PRINCIPAL_AMOUNT)
  private Money minPrincipalAmount;

  public static final String SERIALIZED_NAME_MINIMUM_DAYS_BETWEEN_DISBURSAL_AND_FIRST_REPAYMENT = "minimumDaysBetweenDisbursalAndFirstRepayment";
  @SerializedName(SERIALIZED_NAME_MINIMUM_DAYS_BETWEEN_DISBURSAL_AND_FIRST_REPAYMENT)
  private Integer minimumDaysBetweenDisbursalAndFirstRepayment;

  public static final String SERIALIZED_NAME_MULTI_DISBURSE_LOAN = "multiDisburseLoan";
  @SerializedName(SERIALIZED_NAME_MULTI_DISBURSE_LOAN)
  private Boolean multiDisburseLoan;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_NEW = "new";
  @SerializedName(SERIALIZED_NAME_NEW)
  private Boolean _new;

  public static final String SERIALIZED_NAME_NOMINAL_INTEREST_RATE_PER_PERIOD = "nominalInterestRatePerPeriod";
  @SerializedName(SERIALIZED_NAME_NOMINAL_INTEREST_RATE_PER_PERIOD)
  private BigDecimal nominalInterestRatePerPeriod;

  public static final String SERIALIZED_NAME_NUMBER_OF_REPAYMENTS = "numberOfRepayments";
  @SerializedName(SERIALIZED_NAME_NUMBER_OF_REPAYMENTS)
  private Integer numberOfRepayments;

  public static final String SERIALIZED_NAME_OVER_APPLIED_CALCULATION_TYPE = "overAppliedCalculationType";
  @SerializedName(SERIALIZED_NAME_OVER_APPLIED_CALCULATION_TYPE)
  private String overAppliedCalculationType;

  public static final String SERIALIZED_NAME_OVER_APPLIED_NUMBER = "overAppliedNumber";
  @SerializedName(SERIALIZED_NAME_OVER_APPLIED_NUMBER)
  private Integer overAppliedNumber;

  public static final String SERIALIZED_NAME_OVER_DUE_DAYS_FOR_REPAYMENT_EVENT = "overDueDaysForRepaymentEvent";
  @SerializedName(SERIALIZED_NAME_OVER_DUE_DAYS_FOR_REPAYMENT_EVENT)
  private Integer overDueDaysForRepaymentEvent;

  public static final String SERIALIZED_NAME_OVERDUE_DAYS_FOR_N_P_A = "overdueDaysForNPA";
  @SerializedName(SERIALIZED_NAME_OVERDUE_DAYS_FOR_N_P_A)
  private Integer overdueDaysForNPA;

  public static final String SERIALIZED_NAME_PAYMENT_ALLOCATION_RULES = "paymentAllocationRules";
  @SerializedName(SERIALIZED_NAME_PAYMENT_ALLOCATION_RULES)
  private List<LoanProductPaymentAllocationRule> paymentAllocationRules;

  public static final String SERIALIZED_NAME_PERIODIC_ACCRUAL_ACCOUNTING_ENABLED = "periodicAccrualAccountingEnabled";
  @SerializedName(SERIALIZED_NAME_PERIODIC_ACCRUAL_ACCOUNTING_ENABLED)
  private Boolean periodicAccrualAccountingEnabled;

  public static final String SERIALIZED_NAME_PRINCIPAL_AMOUNT = "principalAmount";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL_AMOUNT)
  private Money principalAmount;

  public static final String SERIALIZED_NAME_PRINCIPAL_THRESHOLD_FOR_LAST_INSTALLMENT = "principalThresholdForLastInstallment";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL_THRESHOLD_FOR_LAST_INSTALLMENT)
  private BigDecimal principalThresholdForLastInstallment;

  public static final String SERIALIZED_NAME_PRODUCT_INTEREST_RECALCULATION_DETAILS = "productInterestRecalculationDetails";
  @SerializedName(SERIALIZED_NAME_PRODUCT_INTEREST_RECALCULATION_DETAILS)
  private LoanProductInterestRecalculationDetails productInterestRecalculationDetails;

  public static final String SERIALIZED_NAME_RATES = "rates";
  @SerializedName(SERIALIZED_NAME_RATES)
  private List<Rate> rates;

  /**
   * Gets or Sets repaymentStartDateType
   */
  @JsonAdapter(RepaymentStartDateTypeEnum.Adapter.class)
  public enum RepaymentStartDateTypeEnum {
    INVALID("INVALID"),
    
    DISBURSEMENT_DATE("DISBURSEMENT_DATE"),
    
    SUBMITTED_ON_DATE("SUBMITTED_ON_DATE");

    private String value;

    RepaymentStartDateTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static RepaymentStartDateTypeEnum fromValue(String value) {
      for (RepaymentStartDateTypeEnum b : RepaymentStartDateTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<RepaymentStartDateTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final RepaymentStartDateTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public RepaymentStartDateTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return RepaymentStartDateTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_REPAYMENT_START_DATE_TYPE = "repaymentStartDateType";
  @SerializedName(SERIALIZED_NAME_REPAYMENT_START_DATE_TYPE)
  private RepaymentStartDateTypeEnum repaymentStartDateType;

  public static final String SERIALIZED_NAME_SHORT_NAME = "shortName";
  @SerializedName(SERIALIZED_NAME_SHORT_NAME)
  private String shortName;

  public static final String SERIALIZED_NAME_START_DATE = "startDate";
  @SerializedName(SERIALIZED_NAME_START_DATE)
  private LocalDate startDate;

  public static final String SERIALIZED_NAME_SYNC_EXPECTED_WITH_DISBURSEMENT_DATE = "syncExpectedWithDisbursementDate";
  @SerializedName(SERIALIZED_NAME_SYNC_EXPECTED_WITH_DISBURSEMENT_DATE)
  private Boolean syncExpectedWithDisbursementDate;

  public static final String SERIALIZED_NAME_TRANSACTION_PROCESSING_STRATEGY_CODE = "transactionProcessingStrategyCode";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_PROCESSING_STRATEGY_CODE)
  private String transactionProcessingStrategyCode;

  public static final String SERIALIZED_NAME_TRANSACTION_PROCESSING_STRATEGY_NAME = "transactionProcessingStrategyName";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_PROCESSING_STRATEGY_NAME)
  private String transactionProcessingStrategyName;

  public static final String SERIALIZED_NAME_UPFRONT_ACCRUAL_ACCOUNTING_ENABLED = "upfrontAccrualAccountingEnabled";
  @SerializedName(SERIALIZED_NAME_UPFRONT_ACCRUAL_ACCOUNTING_ENABLED)
  private Boolean upfrontAccrualAccountingEnabled;

  public static final String SERIALIZED_NAME_USE_BORROWER_CYCLE = "useBorrowerCycle";
  @SerializedName(SERIALIZED_NAME_USE_BORROWER_CYCLE)
  private Boolean useBorrowerCycle;

  public static final String SERIALIZED_NAME_VARIABLE_INSTALLMENT_CONFIG = "variableInstallmentConfig";
  @SerializedName(SERIALIZED_NAME_VARIABLE_INSTALLMENT_CONFIG)
  private LoanProductVariableInstallmentConfig variableInstallmentConfig;

  public LoanProduct() {
  }

  public LoanProduct accountMovesOutOfNPAOnlyOnArrearsCompletion(Boolean accountMovesOutOfNPAOnlyOnArrearsCompletion) {
    
    this.accountMovesOutOfNPAOnlyOnArrearsCompletion = accountMovesOutOfNPAOnlyOnArrearsCompletion;
    return this;
  }

  /**
   * Get accountMovesOutOfNPAOnlyOnArrearsCompletion
   * @return accountMovesOutOfNPAOnlyOnArrearsCompletion
   */
  @javax.annotation.Nullable

  public Boolean getAccountMovesOutOfNPAOnlyOnArrearsCompletion() {
    return accountMovesOutOfNPAOnlyOnArrearsCompletion;
  }


  public void setAccountMovesOutOfNPAOnlyOnArrearsCompletion(Boolean accountMovesOutOfNPAOnlyOnArrearsCompletion) {
    this.accountMovesOutOfNPAOnlyOnArrearsCompletion = accountMovesOutOfNPAOnlyOnArrearsCompletion;
  }

  public LoanProduct accountingDisabled(Boolean accountingDisabled) {
    
    this.accountingDisabled = accountingDisabled;
    return this;
  }

  /**
   * Get accountingDisabled
   * @return accountingDisabled
   */
  @javax.annotation.Nullable

  public Boolean getAccountingDisabled() {
    return accountingDisabled;
  }


  public void setAccountingDisabled(Boolean accountingDisabled) {
    this.accountingDisabled = accountingDisabled;
  }

  public LoanProduct accountingRule(AccountingRuleEnum accountingRule) {
    
    this.accountingRule = accountingRule;
    return this;
  }

  /**
   * Get accountingRule
   * @return accountingRule
   */
  @javax.annotation.Nullable

  public AccountingRuleEnum getAccountingRule() {
    return accountingRule;
  }


  public void setAccountingRule(AccountingRuleEnum accountingRule) {
    this.accountingRule = accountingRule;
  }

  public LoanProduct allowApprovedDisbursedAmountsOverApplied(Boolean allowApprovedDisbursedAmountsOverApplied) {
    
    this.allowApprovedDisbursedAmountsOverApplied = allowApprovedDisbursedAmountsOverApplied;
    return this;
  }

  /**
   * Get allowApprovedDisbursedAmountsOverApplied
   * @return allowApprovedDisbursedAmountsOverApplied
   */
  @javax.annotation.Nullable

  public Boolean getAllowApprovedDisbursedAmountsOverApplied() {
    return allowApprovedDisbursedAmountsOverApplied;
  }


  public void setAllowApprovedDisbursedAmountsOverApplied(Boolean allowApprovedDisbursedAmountsOverApplied) {
    this.allowApprovedDisbursedAmountsOverApplied = allowApprovedDisbursedAmountsOverApplied;
  }

  public LoanProduct allowFullTermForTranche(Boolean allowFullTermForTranche) {
    
    this.allowFullTermForTranche = allowFullTermForTranche;
    return this;
  }

  /**
   * Get allowFullTermForTranche
   * @return allowFullTermForTranche
   */
  @javax.annotation.Nullable

  public Boolean getAllowFullTermForTranche() {
    return allowFullTermForTranche;
  }


  public void setAllowFullTermForTranche(Boolean allowFullTermForTranche) {
    this.allowFullTermForTranche = allowFullTermForTranche;
  }

  public LoanProduct allowVariabeInstallments(Boolean allowVariabeInstallments) {
    
    this.allowVariabeInstallments = allowVariabeInstallments;
    return this;
  }

  /**
   * Get allowVariabeInstallments
   * @return allowVariabeInstallments
   */
  @javax.annotation.Nullable

  public Boolean getAllowVariabeInstallments() {
    return allowVariabeInstallments;
  }


  public void setAllowVariabeInstallments(Boolean allowVariabeInstallments) {
    this.allowVariabeInstallments = allowVariabeInstallments;
  }

  public LoanProduct arrearsBasedOnOriginalSchedule(Boolean arrearsBasedOnOriginalSchedule) {
    
    this.arrearsBasedOnOriginalSchedule = arrearsBasedOnOriginalSchedule;
    return this;
  }

  /**
   * Get arrearsBasedOnOriginalSchedule
   * @return arrearsBasedOnOriginalSchedule
   */
  @javax.annotation.Nullable

  public Boolean getArrearsBasedOnOriginalSchedule() {
    return arrearsBasedOnOriginalSchedule;
  }


  public void setArrearsBasedOnOriginalSchedule(Boolean arrearsBasedOnOriginalSchedule) {
    this.arrearsBasedOnOriginalSchedule = arrearsBasedOnOriginalSchedule;
  }

  public LoanProduct borrowerCycleVariations(Set<LoanProductBorrowerCycleVariations> borrowerCycleVariations) {
    
    this.borrowerCycleVariations = borrowerCycleVariations;
    return this;
  }

  public LoanProduct addBorrowerCycleVariationsItem(LoanProductBorrowerCycleVariations borrowerCycleVariationsItem) {
    if (this.borrowerCycleVariations == null) {
      this.borrowerCycleVariations = new LinkedHashSet<>();
    }
    this.borrowerCycleVariations.add(borrowerCycleVariationsItem);
    return this;
  }

  /**
   * Get borrowerCycleVariations
   * @return borrowerCycleVariations
   */
  @javax.annotation.Nullable

  public Set<LoanProductBorrowerCycleVariations> getBorrowerCycleVariations() {
    return borrowerCycleVariations;
  }


  public void setBorrowerCycleVariations(Set<LoanProductBorrowerCycleVariations> borrowerCycleVariations) {
    this.borrowerCycleVariations = borrowerCycleVariations;
  }

  public LoanProduct canDefineInstallmentAmount(Boolean canDefineInstallmentAmount) {
    
    this.canDefineInstallmentAmount = canDefineInstallmentAmount;
    return this;
  }

  /**
   * Get canDefineInstallmentAmount
   * @return canDefineInstallmentAmount
   */
  @javax.annotation.Nullable

  public Boolean getCanDefineInstallmentAmount() {
    return canDefineInstallmentAmount;
  }


  public void setCanDefineInstallmentAmount(Boolean canDefineInstallmentAmount) {
    this.canDefineInstallmentAmount = canDefineInstallmentAmount;
  }

  public LoanProduct canUseForTopup(Boolean canUseForTopup) {
    
    this.canUseForTopup = canUseForTopup;
    return this;
  }

  /**
   * Get canUseForTopup
   * @return canUseForTopup
   */
  @javax.annotation.Nullable

  public Boolean getCanUseForTopup() {
    return canUseForTopup;
  }


  public void setCanUseForTopup(Boolean canUseForTopup) {
    this.canUseForTopup = canUseForTopup;
  }

  public LoanProduct cashBasedAccountingEnabled(Boolean cashBasedAccountingEnabled) {
    
    this.cashBasedAccountingEnabled = cashBasedAccountingEnabled;
    return this;
  }

  /**
   * Get cashBasedAccountingEnabled
   * @return cashBasedAccountingEnabled
   */
  @javax.annotation.Nullable

  public Boolean getCashBasedAccountingEnabled() {
    return cashBasedAccountingEnabled;
  }


  public void setCashBasedAccountingEnabled(Boolean cashBasedAccountingEnabled) {
    this.cashBasedAccountingEnabled = cashBasedAccountingEnabled;
  }

  public LoanProduct charges(List<Charge> charges) {
    
    this.charges = charges;
    return this;
  }

  public LoanProduct addChargesItem(Charge chargesItem) {
    if (this.charges == null) {
      this.charges = new ArrayList<>();
    }
    this.charges.add(chargesItem);
    return this;
  }

  /**
   * Get charges
   * @return charges
   */
  @javax.annotation.Nullable

  public List<Charge> getCharges() {
    return charges;
  }


  public void setCharges(List<Charge> charges) {
    this.charges = charges;
  }

  public LoanProduct closeDate(LocalDate closeDate) {
    
    this.closeDate = closeDate;
    return this;
  }

  /**
   * Get closeDate
   * @return closeDate
   */
  @javax.annotation.Nullable

  public LocalDate getCloseDate() {
    return closeDate;
  }


  public void setCloseDate(LocalDate closeDate) {
    this.closeDate = closeDate;
  }

  public LoanProduct creditAllocationRules(List<LoanProductCreditAllocationRule> creditAllocationRules) {
    
    this.creditAllocationRules = creditAllocationRules;
    return this;
  }

  public LoanProduct addCreditAllocationRulesItem(LoanProductCreditAllocationRule creditAllocationRulesItem) {
    if (this.creditAllocationRules == null) {
      this.creditAllocationRules = new ArrayList<>();
    }
    this.creditAllocationRules.add(creditAllocationRulesItem);
    return this;
  }

  /**
   * Get creditAllocationRules
   * @return creditAllocationRules
   */
  @javax.annotation.Nullable

  public List<LoanProductCreditAllocationRule> getCreditAllocationRules() {
    return creditAllocationRules;
  }


  public void setCreditAllocationRules(List<LoanProductCreditAllocationRule> creditAllocationRules) {
    this.creditAllocationRules = creditAllocationRules;
  }

  public LoanProduct currency(MonetaryCurrency currency) {
    
    this.currency = currency;
    return this;
  }

  /**
   * Get currency
   * @return currency
   */
  @javax.annotation.Nullable

  public MonetaryCurrency getCurrency() {
    return currency;
  }


  public void setCurrency(MonetaryCurrency currency) {
    this.currency = currency;
  }

  public LoanProduct delinquencyBucket(DelinquencyBucket delinquencyBucket) {
    
    this.delinquencyBucket = delinquencyBucket;
    return this;
  }

  /**
   * Get delinquencyBucket
   * @return delinquencyBucket
   */
  @javax.annotation.Nullable

  public DelinquencyBucket getDelinquencyBucket() {
    return delinquencyBucket;
  }


  public void setDelinquencyBucket(DelinquencyBucket delinquencyBucket) {
    this.delinquencyBucket = delinquencyBucket;
  }

  public LoanProduct description(String description) {
    
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
   */
  @javax.annotation.Nullable

  public String getDescription() {
    return description;
  }


  public void setDescription(String description) {
    this.description = description;
  }

  public LoanProduct disallowExpectedDisbursements(Boolean disallowExpectedDisbursements) {
    
    this.disallowExpectedDisbursements = disallowExpectedDisbursements;
    return this;
  }

  /**
   * Get disallowExpectedDisbursements
   * @return disallowExpectedDisbursements
   */
  @javax.annotation.Nullable

  public Boolean getDisallowExpectedDisbursements() {
    return disallowExpectedDisbursements;
  }


  public void setDisallowExpectedDisbursements(Boolean disallowExpectedDisbursements) {
    this.disallowExpectedDisbursements = disallowExpectedDisbursements;
  }

  public LoanProduct dueDaysForRepaymentEvent(Integer dueDaysForRepaymentEvent) {
    
    this.dueDaysForRepaymentEvent = dueDaysForRepaymentEvent;
    return this;
  }

  /**
   * Get dueDaysForRepaymentEvent
   * @return dueDaysForRepaymentEvent
   */
  @javax.annotation.Nullable

  public Integer getDueDaysForRepaymentEvent() {
    return dueDaysForRepaymentEvent;
  }


  public void setDueDaysForRepaymentEvent(Integer dueDaysForRepaymentEvent) {
    this.dueDaysForRepaymentEvent = dueDaysForRepaymentEvent;
  }

  public LoanProduct enableInstallmentLevelDelinquency(Boolean enableInstallmentLevelDelinquency) {
    
    this.enableInstallmentLevelDelinquency = enableInstallmentLevelDelinquency;
    return this;
  }

  /**
   * Get enableInstallmentLevelDelinquency
   * @return enableInstallmentLevelDelinquency
   */
  @javax.annotation.Nullable

  public Boolean getEnableInstallmentLevelDelinquency() {
    return enableInstallmentLevelDelinquency;
  }


  public void setEnableInstallmentLevelDelinquency(Boolean enableInstallmentLevelDelinquency) {
    this.enableInstallmentLevelDelinquency = enableInstallmentLevelDelinquency;
  }

  public LoanProduct equalAmortization(Boolean equalAmortization) {
    
    this.equalAmortization = equalAmortization;
    return this;
  }

  /**
   * Get equalAmortization
   * @return equalAmortization
   */
  @javax.annotation.Nullable

  public Boolean getEqualAmortization() {
    return equalAmortization;
  }


  public void setEqualAmortization(Boolean equalAmortization) {
    this.equalAmortization = equalAmortization;
  }

  public LoanProduct externalId(ExternalId externalId) {
    
    this.externalId = externalId;
    return this;
  }

  /**
   * Get externalId
   * @return externalId
   */
  @javax.annotation.Nullable

  public ExternalId getExternalId() {
    return externalId;
  }


  public void setExternalId(ExternalId externalId) {
    this.externalId = externalId;
  }

  public LoanProduct fixedPrincipalPercentagePerInstallment(BigDecimal fixedPrincipalPercentagePerInstallment) {
    
    this.fixedPrincipalPercentagePerInstallment = fixedPrincipalPercentagePerInstallment;
    return this;
  }

  /**
   * Get fixedPrincipalPercentagePerInstallment
   * @return fixedPrincipalPercentagePerInstallment
   */
  @javax.annotation.Nullable

  public BigDecimal getFixedPrincipalPercentagePerInstallment() {
    return fixedPrincipalPercentagePerInstallment;
  }


  public void setFixedPrincipalPercentagePerInstallment(BigDecimal fixedPrincipalPercentagePerInstallment) {
    this.fixedPrincipalPercentagePerInstallment = fixedPrincipalPercentagePerInstallment;
  }

  public LoanProduct floatingRates(LoanProductFloatingRates floatingRates) {
    
    this.floatingRates = floatingRates;
    return this;
  }

  /**
   * Get floatingRates
   * @return floatingRates
   */
  @javax.annotation.Nullable

  public LoanProductFloatingRates getFloatingRates() {
    return floatingRates;
  }


  public void setFloatingRates(LoanProductFloatingRates floatingRates) {
    this.floatingRates = floatingRates;
  }

  public LoanProduct fund(Fund fund) {
    
    this.fund = fund;
    return this;
  }

  /**
   * Get fund
   * @return fund
   */
  @javax.annotation.Nullable

  public Fund getFund() {
    return fund;
  }


  public void setFund(Fund fund) {
    this.fund = fund;
  }

  public LoanProduct holdGuaranteeFunds(Boolean holdGuaranteeFunds) {
    
    this.holdGuaranteeFunds = holdGuaranteeFunds;
    return this;
  }

  /**
   * Get holdGuaranteeFunds
   * @return holdGuaranteeFunds
   */
  @javax.annotation.Nullable

  public Boolean getHoldGuaranteeFunds() {
    return holdGuaranteeFunds;
  }


  public void setHoldGuaranteeFunds(Boolean holdGuaranteeFunds) {
    this.holdGuaranteeFunds = holdGuaranteeFunds;
  }

  public LoanProduct id(Long id) {
    
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
   */
  @javax.annotation.Nullable

  public Long getId() {
    return id;
  }


  public void setId(Long id) {
    this.id = id;
  }

  public LoanProduct includeInBorrowerCycle(Boolean includeInBorrowerCycle) {
    
    this.includeInBorrowerCycle = includeInBorrowerCycle;
    return this;
  }

  /**
   * Get includeInBorrowerCycle
   * @return includeInBorrowerCycle
   */
  @javax.annotation.Nullable

  public Boolean getIncludeInBorrowerCycle() {
    return includeInBorrowerCycle;
  }


  public void setIncludeInBorrowerCycle(Boolean includeInBorrowerCycle) {
    this.includeInBorrowerCycle = includeInBorrowerCycle;
  }

  public LoanProduct interestPeriodFrequencyType(InterestPeriodFrequencyTypeEnum interestPeriodFrequencyType) {
    
    this.interestPeriodFrequencyType = interestPeriodFrequencyType;
    return this;
  }

  /**
   * Get interestPeriodFrequencyType
   * @return interestPeriodFrequencyType
   */
  @javax.annotation.Nullable

  public InterestPeriodFrequencyTypeEnum getInterestPeriodFrequencyType() {
    return interestPeriodFrequencyType;
  }


  public void setInterestPeriodFrequencyType(InterestPeriodFrequencyTypeEnum interestPeriodFrequencyType) {
    this.interestPeriodFrequencyType = interestPeriodFrequencyType;
  }

  public LoanProduct interestRecalculationEnabled(Boolean interestRecalculationEnabled) {
    
    this.interestRecalculationEnabled = interestRecalculationEnabled;
    return this;
  }

  /**
   * Get interestRecalculationEnabled
   * @return interestRecalculationEnabled
   */
  @javax.annotation.Nullable

  public Boolean getInterestRecalculationEnabled() {
    return interestRecalculationEnabled;
  }


  public void setInterestRecalculationEnabled(Boolean interestRecalculationEnabled) {
    this.interestRecalculationEnabled = interestRecalculationEnabled;
  }

  public LoanProduct linkedToFloatingInterestRate(Boolean linkedToFloatingInterestRate) {
    
    this.linkedToFloatingInterestRate = linkedToFloatingInterestRate;
    return this;
  }

  /**
   * Get linkedToFloatingInterestRate
   * @return linkedToFloatingInterestRate
   */
  @javax.annotation.Nullable

  public Boolean getLinkedToFloatingInterestRate() {
    return linkedToFloatingInterestRate;
  }


  public void setLinkedToFloatingInterestRate(Boolean linkedToFloatingInterestRate) {
    this.linkedToFloatingInterestRate = linkedToFloatingInterestRate;
  }

  public LoanProduct loanConfigurableAttributes(LoanProductConfigurableAttributes loanConfigurableAttributes) {
    
    this.loanConfigurableAttributes = loanConfigurableAttributes;
    return this;
  }

  /**
   * Get loanConfigurableAttributes
   * @return loanConfigurableAttributes
   */
  @javax.annotation.Nullable

  public LoanProductConfigurableAttributes getLoanConfigurableAttributes() {
    return loanConfigurableAttributes;
  }


  public void setLoanConfigurableAttributes(LoanProductConfigurableAttributes loanConfigurableAttributes) {
    this.loanConfigurableAttributes = loanConfigurableAttributes;
  }

  public LoanProduct loanProductGuaranteeDetails(LoanProductGuaranteeDetails loanProductGuaranteeDetails) {
    
    this.loanProductGuaranteeDetails = loanProductGuaranteeDetails;
    return this;
  }

  /**
   * Get loanProductGuaranteeDetails
   * @return loanProductGuaranteeDetails
   */
  @javax.annotation.Nullable

  public LoanProductGuaranteeDetails getLoanProductGuaranteeDetails() {
    return loanProductGuaranteeDetails;
  }


  public void setLoanProductGuaranteeDetails(LoanProductGuaranteeDetails loanProductGuaranteeDetails) {
    this.loanProductGuaranteeDetails = loanProductGuaranteeDetails;
  }

  public LoanProduct loanProductMinMaxConstraints(LoanProductMinMaxConstraints loanProductMinMaxConstraints) {
    
    this.loanProductMinMaxConstraints = loanProductMinMaxConstraints;
    return this;
  }

  /**
   * Get loanProductMinMaxConstraints
   * @return loanProductMinMaxConstraints
   */
  @javax.annotation.Nullable

  public LoanProductMinMaxConstraints getLoanProductMinMaxConstraints() {
    return loanProductMinMaxConstraints;
  }


  public void setLoanProductMinMaxConstraints(LoanProductMinMaxConstraints loanProductMinMaxConstraints) {
    this.loanProductMinMaxConstraints = loanProductMinMaxConstraints;
  }

  public LoanProduct loanProductRelatedDetail(LoanProductRelatedDetail loanProductRelatedDetail) {
    
    this.loanProductRelatedDetail = loanProductRelatedDetail;
    return this;
  }

  /**
   * Get loanProductRelatedDetail
   * @return loanProductRelatedDetail
   */
  @javax.annotation.Nullable

  public LoanProductRelatedDetail getLoanProductRelatedDetail() {
    return loanProductRelatedDetail;
  }


  public void setLoanProductRelatedDetail(LoanProductRelatedDetail loanProductRelatedDetail) {
    this.loanProductRelatedDetail = loanProductRelatedDetail;
  }

  public LoanProduct loanProductTrancheDetails(LoanProductTrancheDetails loanProductTrancheDetails) {
    
    this.loanProductTrancheDetails = loanProductTrancheDetails;
    return this;
  }

  /**
   * Get loanProductTrancheDetails
   * @return loanProductTrancheDetails
   */
  @javax.annotation.Nullable

  public LoanProductTrancheDetails getLoanProductTrancheDetails() {
    return loanProductTrancheDetails;
  }


  public void setLoanProductTrancheDetails(LoanProductTrancheDetails loanProductTrancheDetails) {
    this.loanProductTrancheDetails = loanProductTrancheDetails;
  }

  public LoanProduct maxNominalInterestRatePerPeriod(BigDecimal maxNominalInterestRatePerPeriod) {
    
    this.maxNominalInterestRatePerPeriod = maxNominalInterestRatePerPeriod;
    return this;
  }

  /**
   * Get maxNominalInterestRatePerPeriod
   * @return maxNominalInterestRatePerPeriod
   */
  @javax.annotation.Nullable

  public BigDecimal getMaxNominalInterestRatePerPeriod() {
    return maxNominalInterestRatePerPeriod;
  }


  public void setMaxNominalInterestRatePerPeriod(BigDecimal maxNominalInterestRatePerPeriod) {
    this.maxNominalInterestRatePerPeriod = maxNominalInterestRatePerPeriod;
  }

  public LoanProduct maxNumberOfRepayments(Integer maxNumberOfRepayments) {
    
    this.maxNumberOfRepayments = maxNumberOfRepayments;
    return this;
  }

  /**
   * Get maxNumberOfRepayments
   * @return maxNumberOfRepayments
   */
  @javax.annotation.Nullable

  public Integer getMaxNumberOfRepayments() {
    return maxNumberOfRepayments;
  }


  public void setMaxNumberOfRepayments(Integer maxNumberOfRepayments) {
    this.maxNumberOfRepayments = maxNumberOfRepayments;
  }

  public LoanProduct maxPrincipalAmount(Money maxPrincipalAmount) {
    
    this.maxPrincipalAmount = maxPrincipalAmount;
    return this;
  }

  /**
   * Get maxPrincipalAmount
   * @return maxPrincipalAmount
   */
  @javax.annotation.Nullable

  public Money getMaxPrincipalAmount() {
    return maxPrincipalAmount;
  }


  public void setMaxPrincipalAmount(Money maxPrincipalAmount) {
    this.maxPrincipalAmount = maxPrincipalAmount;
  }

  public LoanProduct minNominalInterestRatePerPeriod(BigDecimal minNominalInterestRatePerPeriod) {
    
    this.minNominalInterestRatePerPeriod = minNominalInterestRatePerPeriod;
    return this;
  }

  /**
   * Get minNominalInterestRatePerPeriod
   * @return minNominalInterestRatePerPeriod
   */
  @javax.annotation.Nullable

  public BigDecimal getMinNominalInterestRatePerPeriod() {
    return minNominalInterestRatePerPeriod;
  }


  public void setMinNominalInterestRatePerPeriod(BigDecimal minNominalInterestRatePerPeriod) {
    this.minNominalInterestRatePerPeriod = minNominalInterestRatePerPeriod;
  }

  public LoanProduct minNumberOfRepayments(Integer minNumberOfRepayments) {
    
    this.minNumberOfRepayments = minNumberOfRepayments;
    return this;
  }

  /**
   * Get minNumberOfRepayments
   * @return minNumberOfRepayments
   */
  @javax.annotation.Nullable

  public Integer getMinNumberOfRepayments() {
    return minNumberOfRepayments;
  }


  public void setMinNumberOfRepayments(Integer minNumberOfRepayments) {
    this.minNumberOfRepayments = minNumberOfRepayments;
  }

  public LoanProduct minPrincipalAmount(Money minPrincipalAmount) {
    
    this.minPrincipalAmount = minPrincipalAmount;
    return this;
  }

  /**
   * Get minPrincipalAmount
   * @return minPrincipalAmount
   */
  @javax.annotation.Nullable

  public Money getMinPrincipalAmount() {
    return minPrincipalAmount;
  }


  public void setMinPrincipalAmount(Money minPrincipalAmount) {
    this.minPrincipalAmount = minPrincipalAmount;
  }

  public LoanProduct minimumDaysBetweenDisbursalAndFirstRepayment(Integer minimumDaysBetweenDisbursalAndFirstRepayment) {
    
    this.minimumDaysBetweenDisbursalAndFirstRepayment = minimumDaysBetweenDisbursalAndFirstRepayment;
    return this;
  }

  /**
   * Get minimumDaysBetweenDisbursalAndFirstRepayment
   * @return minimumDaysBetweenDisbursalAndFirstRepayment
   */
  @javax.annotation.Nullable

  public Integer getMinimumDaysBetweenDisbursalAndFirstRepayment() {
    return minimumDaysBetweenDisbursalAndFirstRepayment;
  }


  public void setMinimumDaysBetweenDisbursalAndFirstRepayment(Integer minimumDaysBetweenDisbursalAndFirstRepayment) {
    this.minimumDaysBetweenDisbursalAndFirstRepayment = minimumDaysBetweenDisbursalAndFirstRepayment;
  }

  public LoanProduct multiDisburseLoan(Boolean multiDisburseLoan) {
    
    this.multiDisburseLoan = multiDisburseLoan;
    return this;
  }

  /**
   * Get multiDisburseLoan
   * @return multiDisburseLoan
   */
  @javax.annotation.Nullable

  public Boolean getMultiDisburseLoan() {
    return multiDisburseLoan;
  }


  public void setMultiDisburseLoan(Boolean multiDisburseLoan) {
    this.multiDisburseLoan = multiDisburseLoan;
  }

  public LoanProduct name(String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
   */
  @javax.annotation.Nullable

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }

  public LoanProduct _new(Boolean _new) {
    
    this._new = _new;
    return this;
  }

  /**
   * Get _new
   * @return _new
   */
  @javax.annotation.Nullable

  public Boolean getNew() {
    return _new;
  }


  public void setNew(Boolean _new) {
    this._new = _new;
  }

  public LoanProduct nominalInterestRatePerPeriod(BigDecimal nominalInterestRatePerPeriod) {
    
    this.nominalInterestRatePerPeriod = nominalInterestRatePerPeriod;
    return this;
  }

  /**
   * Get nominalInterestRatePerPeriod
   * @return nominalInterestRatePerPeriod
   */
  @javax.annotation.Nullable

  public BigDecimal getNominalInterestRatePerPeriod() {
    return nominalInterestRatePerPeriod;
  }


  public void setNominalInterestRatePerPeriod(BigDecimal nominalInterestRatePerPeriod) {
    this.nominalInterestRatePerPeriod = nominalInterestRatePerPeriod;
  }

  public LoanProduct numberOfRepayments(Integer numberOfRepayments) {
    
    this.numberOfRepayments = numberOfRepayments;
    return this;
  }

  /**
   * Get numberOfRepayments
   * @return numberOfRepayments
   */
  @javax.annotation.Nullable

  public Integer getNumberOfRepayments() {
    return numberOfRepayments;
  }


  public void setNumberOfRepayments(Integer numberOfRepayments) {
    this.numberOfRepayments = numberOfRepayments;
  }

  public LoanProduct overAppliedCalculationType(String overAppliedCalculationType) {
    
    this.overAppliedCalculationType = overAppliedCalculationType;
    return this;
  }

  /**
   * Get overAppliedCalculationType
   * @return overAppliedCalculationType
   */
  @javax.annotation.Nullable

  public String getOverAppliedCalculationType() {
    return overAppliedCalculationType;
  }


  public void setOverAppliedCalculationType(String overAppliedCalculationType) {
    this.overAppliedCalculationType = overAppliedCalculationType;
  }

  public LoanProduct overAppliedNumber(Integer overAppliedNumber) {
    
    this.overAppliedNumber = overAppliedNumber;
    return this;
  }

  /**
   * Get overAppliedNumber
   * @return overAppliedNumber
   */
  @javax.annotation.Nullable

  public Integer getOverAppliedNumber() {
    return overAppliedNumber;
  }


  public void setOverAppliedNumber(Integer overAppliedNumber) {
    this.overAppliedNumber = overAppliedNumber;
  }

  public LoanProduct overDueDaysForRepaymentEvent(Integer overDueDaysForRepaymentEvent) {
    
    this.overDueDaysForRepaymentEvent = overDueDaysForRepaymentEvent;
    return this;
  }

  /**
   * Get overDueDaysForRepaymentEvent
   * @return overDueDaysForRepaymentEvent
   */
  @javax.annotation.Nullable

  public Integer getOverDueDaysForRepaymentEvent() {
    return overDueDaysForRepaymentEvent;
  }


  public void setOverDueDaysForRepaymentEvent(Integer overDueDaysForRepaymentEvent) {
    this.overDueDaysForRepaymentEvent = overDueDaysForRepaymentEvent;
  }

  public LoanProduct overdueDaysForNPA(Integer overdueDaysForNPA) {
    
    this.overdueDaysForNPA = overdueDaysForNPA;
    return this;
  }

  /**
   * Get overdueDaysForNPA
   * @return overdueDaysForNPA
   */
  @javax.annotation.Nullable

  public Integer getOverdueDaysForNPA() {
    return overdueDaysForNPA;
  }


  public void setOverdueDaysForNPA(Integer overdueDaysForNPA) {
    this.overdueDaysForNPA = overdueDaysForNPA;
  }

  public LoanProduct paymentAllocationRules(List<LoanProductPaymentAllocationRule> paymentAllocationRules) {
    
    this.paymentAllocationRules = paymentAllocationRules;
    return this;
  }

  public LoanProduct addPaymentAllocationRulesItem(LoanProductPaymentAllocationRule paymentAllocationRulesItem) {
    if (this.paymentAllocationRules == null) {
      this.paymentAllocationRules = new ArrayList<>();
    }
    this.paymentAllocationRules.add(paymentAllocationRulesItem);
    return this;
  }

  /**
   * Get paymentAllocationRules
   * @return paymentAllocationRules
   */
  @javax.annotation.Nullable

  public List<LoanProductPaymentAllocationRule> getPaymentAllocationRules() {
    return paymentAllocationRules;
  }


  public void setPaymentAllocationRules(List<LoanProductPaymentAllocationRule> paymentAllocationRules) {
    this.paymentAllocationRules = paymentAllocationRules;
  }

  public LoanProduct periodicAccrualAccountingEnabled(Boolean periodicAccrualAccountingEnabled) {
    
    this.periodicAccrualAccountingEnabled = periodicAccrualAccountingEnabled;
    return this;
  }

  /**
   * Get periodicAccrualAccountingEnabled
   * @return periodicAccrualAccountingEnabled
   */
  @javax.annotation.Nullable

  public Boolean getPeriodicAccrualAccountingEnabled() {
    return periodicAccrualAccountingEnabled;
  }


  public void setPeriodicAccrualAccountingEnabled(Boolean periodicAccrualAccountingEnabled) {
    this.periodicAccrualAccountingEnabled = periodicAccrualAccountingEnabled;
  }

  public LoanProduct principalAmount(Money principalAmount) {
    
    this.principalAmount = principalAmount;
    return this;
  }

  /**
   * Get principalAmount
   * @return principalAmount
   */
  @javax.annotation.Nullable

  public Money getPrincipalAmount() {
    return principalAmount;
  }


  public void setPrincipalAmount(Money principalAmount) {
    this.principalAmount = principalAmount;
  }

  public LoanProduct principalThresholdForLastInstallment(BigDecimal principalThresholdForLastInstallment) {
    
    this.principalThresholdForLastInstallment = principalThresholdForLastInstallment;
    return this;
  }

  /**
   * Get principalThresholdForLastInstallment
   * @return principalThresholdForLastInstallment
   */
  @javax.annotation.Nullable

  public BigDecimal getPrincipalThresholdForLastInstallment() {
    return principalThresholdForLastInstallment;
  }


  public void setPrincipalThresholdForLastInstallment(BigDecimal principalThresholdForLastInstallment) {
    this.principalThresholdForLastInstallment = principalThresholdForLastInstallment;
  }

  public LoanProduct productInterestRecalculationDetails(LoanProductInterestRecalculationDetails productInterestRecalculationDetails) {
    
    this.productInterestRecalculationDetails = productInterestRecalculationDetails;
    return this;
  }

  /**
   * Get productInterestRecalculationDetails
   * @return productInterestRecalculationDetails
   */
  @javax.annotation.Nullable

  public LoanProductInterestRecalculationDetails getProductInterestRecalculationDetails() {
    return productInterestRecalculationDetails;
  }


  public void setProductInterestRecalculationDetails(LoanProductInterestRecalculationDetails productInterestRecalculationDetails) {
    this.productInterestRecalculationDetails = productInterestRecalculationDetails;
  }

  public LoanProduct rates(List<Rate> rates) {
    
    this.rates = rates;
    return this;
  }

  public LoanProduct addRatesItem(Rate ratesItem) {
    if (this.rates == null) {
      this.rates = new ArrayList<>();
    }
    this.rates.add(ratesItem);
    return this;
  }

  /**
   * Get rates
   * @return rates
   */
  @javax.annotation.Nullable

  public List<Rate> getRates() {
    return rates;
  }


  public void setRates(List<Rate> rates) {
    this.rates = rates;
  }

  public LoanProduct repaymentStartDateType(RepaymentStartDateTypeEnum repaymentStartDateType) {
    
    this.repaymentStartDateType = repaymentStartDateType;
    return this;
  }

  /**
   * Get repaymentStartDateType
   * @return repaymentStartDateType
   */
  @javax.annotation.Nullable

  public RepaymentStartDateTypeEnum getRepaymentStartDateType() {
    return repaymentStartDateType;
  }


  public void setRepaymentStartDateType(RepaymentStartDateTypeEnum repaymentStartDateType) {
    this.repaymentStartDateType = repaymentStartDateType;
  }

  public LoanProduct shortName(String shortName) {
    
    this.shortName = shortName;
    return this;
  }

  /**
   * Get shortName
   * @return shortName
   */
  @javax.annotation.Nullable

  public String getShortName() {
    return shortName;
  }


  public void setShortName(String shortName) {
    this.shortName = shortName;
  }

  public LoanProduct startDate(LocalDate startDate) {
    
    this.startDate = startDate;
    return this;
  }

  /**
   * Get startDate
   * @return startDate
   */
  @javax.annotation.Nullable

  public LocalDate getStartDate() {
    return startDate;
  }


  public void setStartDate(LocalDate startDate) {
    this.startDate = startDate;
  }

  public LoanProduct syncExpectedWithDisbursementDate(Boolean syncExpectedWithDisbursementDate) {
    
    this.syncExpectedWithDisbursementDate = syncExpectedWithDisbursementDate;
    return this;
  }

  /**
   * Get syncExpectedWithDisbursementDate
   * @return syncExpectedWithDisbursementDate
   */
  @javax.annotation.Nullable

  public Boolean getSyncExpectedWithDisbursementDate() {
    return syncExpectedWithDisbursementDate;
  }


  public void setSyncExpectedWithDisbursementDate(Boolean syncExpectedWithDisbursementDate) {
    this.syncExpectedWithDisbursementDate = syncExpectedWithDisbursementDate;
  }

  public LoanProduct transactionProcessingStrategyCode(String transactionProcessingStrategyCode) {
    
    this.transactionProcessingStrategyCode = transactionProcessingStrategyCode;
    return this;
  }

  /**
   * Get transactionProcessingStrategyCode
   * @return transactionProcessingStrategyCode
   */
  @javax.annotation.Nullable

  public String getTransactionProcessingStrategyCode() {
    return transactionProcessingStrategyCode;
  }


  public void setTransactionProcessingStrategyCode(String transactionProcessingStrategyCode) {
    this.transactionProcessingStrategyCode = transactionProcessingStrategyCode;
  }

  public LoanProduct transactionProcessingStrategyName(String transactionProcessingStrategyName) {
    
    this.transactionProcessingStrategyName = transactionProcessingStrategyName;
    return this;
  }

  /**
   * Get transactionProcessingStrategyName
   * @return transactionProcessingStrategyName
   */
  @javax.annotation.Nullable

  public String getTransactionProcessingStrategyName() {
    return transactionProcessingStrategyName;
  }


  public void setTransactionProcessingStrategyName(String transactionProcessingStrategyName) {
    this.transactionProcessingStrategyName = transactionProcessingStrategyName;
  }

  public LoanProduct upfrontAccrualAccountingEnabled(Boolean upfrontAccrualAccountingEnabled) {
    
    this.upfrontAccrualAccountingEnabled = upfrontAccrualAccountingEnabled;
    return this;
  }

  /**
   * Get upfrontAccrualAccountingEnabled
   * @return upfrontAccrualAccountingEnabled
   */
  @javax.annotation.Nullable

  public Boolean getUpfrontAccrualAccountingEnabled() {
    return upfrontAccrualAccountingEnabled;
  }


  public void setUpfrontAccrualAccountingEnabled(Boolean upfrontAccrualAccountingEnabled) {
    this.upfrontAccrualAccountingEnabled = upfrontAccrualAccountingEnabled;
  }

  public LoanProduct useBorrowerCycle(Boolean useBorrowerCycle) {
    
    this.useBorrowerCycle = useBorrowerCycle;
    return this;
  }

  /**
   * Get useBorrowerCycle
   * @return useBorrowerCycle
   */
  @javax.annotation.Nullable

  public Boolean getUseBorrowerCycle() {
    return useBorrowerCycle;
  }


  public void setUseBorrowerCycle(Boolean useBorrowerCycle) {
    this.useBorrowerCycle = useBorrowerCycle;
  }

  public LoanProduct variableInstallmentConfig(LoanProductVariableInstallmentConfig variableInstallmentConfig) {
    
    this.variableInstallmentConfig = variableInstallmentConfig;
    return this;
  }

  /**
   * Get variableInstallmentConfig
   * @return variableInstallmentConfig
   */
  @javax.annotation.Nullable

  public LoanProductVariableInstallmentConfig getVariableInstallmentConfig() {
    return variableInstallmentConfig;
  }


  public void setVariableInstallmentConfig(LoanProductVariableInstallmentConfig variableInstallmentConfig) {
    this.variableInstallmentConfig = variableInstallmentConfig;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LoanProduct loanProduct = (LoanProduct) o;
    return Objects.equals(this.accountMovesOutOfNPAOnlyOnArrearsCompletion, loanProduct.accountMovesOutOfNPAOnlyOnArrearsCompletion) &&
        Objects.equals(this.accountingDisabled, loanProduct.accountingDisabled) &&
        Objects.equals(this.accountingRule, loanProduct.accountingRule) &&
        Objects.equals(this.allowApprovedDisbursedAmountsOverApplied, loanProduct.allowApprovedDisbursedAmountsOverApplied) &&
        Objects.equals(this.allowFullTermForTranche, loanProduct.allowFullTermForTranche) &&
        Objects.equals(this.allowVariabeInstallments, loanProduct.allowVariabeInstallments) &&
        Objects.equals(this.arrearsBasedOnOriginalSchedule, loanProduct.arrearsBasedOnOriginalSchedule) &&
        Objects.equals(this.borrowerCycleVariations, loanProduct.borrowerCycleVariations) &&
        Objects.equals(this.canDefineInstallmentAmount, loanProduct.canDefineInstallmentAmount) &&
        Objects.equals(this.canUseForTopup, loanProduct.canUseForTopup) &&
        Objects.equals(this.cashBasedAccountingEnabled, loanProduct.cashBasedAccountingEnabled) &&
        Objects.equals(this.charges, loanProduct.charges) &&
        Objects.equals(this.closeDate, loanProduct.closeDate) &&
        Objects.equals(this.creditAllocationRules, loanProduct.creditAllocationRules) &&
        Objects.equals(this.currency, loanProduct.currency) &&
        Objects.equals(this.delinquencyBucket, loanProduct.delinquencyBucket) &&
        Objects.equals(this.description, loanProduct.description) &&
        Objects.equals(this.disallowExpectedDisbursements, loanProduct.disallowExpectedDisbursements) &&
        Objects.equals(this.dueDaysForRepaymentEvent, loanProduct.dueDaysForRepaymentEvent) &&
        Objects.equals(this.enableInstallmentLevelDelinquency, loanProduct.enableInstallmentLevelDelinquency) &&
        Objects.equals(this.equalAmortization, loanProduct.equalAmortization) &&
        Objects.equals(this.externalId, loanProduct.externalId) &&
        Objects.equals(this.fixedPrincipalPercentagePerInstallment, loanProduct.fixedPrincipalPercentagePerInstallment) &&
        Objects.equals(this.floatingRates, loanProduct.floatingRates) &&
        Objects.equals(this.fund, loanProduct.fund) &&
        Objects.equals(this.holdGuaranteeFunds, loanProduct.holdGuaranteeFunds) &&
        Objects.equals(this.id, loanProduct.id) &&
        Objects.equals(this.includeInBorrowerCycle, loanProduct.includeInBorrowerCycle) &&
        Objects.equals(this.interestPeriodFrequencyType, loanProduct.interestPeriodFrequencyType) &&
        Objects.equals(this.interestRecalculationEnabled, loanProduct.interestRecalculationEnabled) &&
        Objects.equals(this.linkedToFloatingInterestRate, loanProduct.linkedToFloatingInterestRate) &&
        Objects.equals(this.loanConfigurableAttributes, loanProduct.loanConfigurableAttributes) &&
        Objects.equals(this.loanProductGuaranteeDetails, loanProduct.loanProductGuaranteeDetails) &&
        Objects.equals(this.loanProductMinMaxConstraints, loanProduct.loanProductMinMaxConstraints) &&
        Objects.equals(this.loanProductRelatedDetail, loanProduct.loanProductRelatedDetail) &&
        Objects.equals(this.loanProductTrancheDetails, loanProduct.loanProductTrancheDetails) &&
        Objects.equals(this.maxNominalInterestRatePerPeriod, loanProduct.maxNominalInterestRatePerPeriod) &&
        Objects.equals(this.maxNumberOfRepayments, loanProduct.maxNumberOfRepayments) &&
        Objects.equals(this.maxPrincipalAmount, loanProduct.maxPrincipalAmount) &&
        Objects.equals(this.minNominalInterestRatePerPeriod, loanProduct.minNominalInterestRatePerPeriod) &&
        Objects.equals(this.minNumberOfRepayments, loanProduct.minNumberOfRepayments) &&
        Objects.equals(this.minPrincipalAmount, loanProduct.minPrincipalAmount) &&
        Objects.equals(this.minimumDaysBetweenDisbursalAndFirstRepayment, loanProduct.minimumDaysBetweenDisbursalAndFirstRepayment) &&
        Objects.equals(this.multiDisburseLoan, loanProduct.multiDisburseLoan) &&
        Objects.equals(this.name, loanProduct.name) &&
        Objects.equals(this._new, loanProduct._new) &&
        Objects.equals(this.nominalInterestRatePerPeriod, loanProduct.nominalInterestRatePerPeriod) &&
        Objects.equals(this.numberOfRepayments, loanProduct.numberOfRepayments) &&
        Objects.equals(this.overAppliedCalculationType, loanProduct.overAppliedCalculationType) &&
        Objects.equals(this.overAppliedNumber, loanProduct.overAppliedNumber) &&
        Objects.equals(this.overDueDaysForRepaymentEvent, loanProduct.overDueDaysForRepaymentEvent) &&
        Objects.equals(this.overdueDaysForNPA, loanProduct.overdueDaysForNPA) &&
        Objects.equals(this.paymentAllocationRules, loanProduct.paymentAllocationRules) &&
        Objects.equals(this.periodicAccrualAccountingEnabled, loanProduct.periodicAccrualAccountingEnabled) &&
        Objects.equals(this.principalAmount, loanProduct.principalAmount) &&
        Objects.equals(this.principalThresholdForLastInstallment, loanProduct.principalThresholdForLastInstallment) &&
        Objects.equals(this.productInterestRecalculationDetails, loanProduct.productInterestRecalculationDetails) &&
        Objects.equals(this.rates, loanProduct.rates) &&
        Objects.equals(this.repaymentStartDateType, loanProduct.repaymentStartDateType) &&
        Objects.equals(this.shortName, loanProduct.shortName) &&
        Objects.equals(this.startDate, loanProduct.startDate) &&
        Objects.equals(this.syncExpectedWithDisbursementDate, loanProduct.syncExpectedWithDisbursementDate) &&
        Objects.equals(this.transactionProcessingStrategyCode, loanProduct.transactionProcessingStrategyCode) &&
        Objects.equals(this.transactionProcessingStrategyName, loanProduct.transactionProcessingStrategyName) &&
        Objects.equals(this.upfrontAccrualAccountingEnabled, loanProduct.upfrontAccrualAccountingEnabled) &&
        Objects.equals(this.useBorrowerCycle, loanProduct.useBorrowerCycle) &&
        Objects.equals(this.variableInstallmentConfig, loanProduct.variableInstallmentConfig);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountMovesOutOfNPAOnlyOnArrearsCompletion, accountingDisabled, accountingRule, allowApprovedDisbursedAmountsOverApplied, allowFullTermForTranche, allowVariabeInstallments, arrearsBasedOnOriginalSchedule, borrowerCycleVariations, canDefineInstallmentAmount, canUseForTopup, cashBasedAccountingEnabled, charges, closeDate, creditAllocationRules, currency, delinquencyBucket, description, disallowExpectedDisbursements, dueDaysForRepaymentEvent, enableInstallmentLevelDelinquency, equalAmortization, externalId, fixedPrincipalPercentagePerInstallment, floatingRates, fund, holdGuaranteeFunds, id, includeInBorrowerCycle, interestPeriodFrequencyType, interestRecalculationEnabled, linkedToFloatingInterestRate, loanConfigurableAttributes, loanProductGuaranteeDetails, loanProductMinMaxConstraints, loanProductRelatedDetail, loanProductTrancheDetails, maxNominalInterestRatePerPeriod, maxNumberOfRepayments, maxPrincipalAmount, minNominalInterestRatePerPeriod, minNumberOfRepayments, minPrincipalAmount, minimumDaysBetweenDisbursalAndFirstRepayment, multiDisburseLoan, name, _new, nominalInterestRatePerPeriod, numberOfRepayments, overAppliedCalculationType, overAppliedNumber, overDueDaysForRepaymentEvent, overdueDaysForNPA, paymentAllocationRules, periodicAccrualAccountingEnabled, principalAmount, principalThresholdForLastInstallment, productInterestRecalculationDetails, rates, repaymentStartDateType, shortName, startDate, syncExpectedWithDisbursementDate, transactionProcessingStrategyCode, transactionProcessingStrategyName, upfrontAccrualAccountingEnabled, useBorrowerCycle, variableInstallmentConfig);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LoanProduct {\n");
    sb.append("    accountMovesOutOfNPAOnlyOnArrearsCompletion: ").append(toIndentedString(accountMovesOutOfNPAOnlyOnArrearsCompletion)).append("\n");
    sb.append("    accountingDisabled: ").append(toIndentedString(accountingDisabled)).append("\n");
    sb.append("    accountingRule: ").append(toIndentedString(accountingRule)).append("\n");
    sb.append("    allowApprovedDisbursedAmountsOverApplied: ").append(toIndentedString(allowApprovedDisbursedAmountsOverApplied)).append("\n");
    sb.append("    allowFullTermForTranche: ").append(toIndentedString(allowFullTermForTranche)).append("\n");
    sb.append("    allowVariabeInstallments: ").append(toIndentedString(allowVariabeInstallments)).append("\n");
    sb.append("    arrearsBasedOnOriginalSchedule: ").append(toIndentedString(arrearsBasedOnOriginalSchedule)).append("\n");
    sb.append("    borrowerCycleVariations: ").append(toIndentedString(borrowerCycleVariations)).append("\n");
    sb.append("    canDefineInstallmentAmount: ").append(toIndentedString(canDefineInstallmentAmount)).append("\n");
    sb.append("    canUseForTopup: ").append(toIndentedString(canUseForTopup)).append("\n");
    sb.append("    cashBasedAccountingEnabled: ").append(toIndentedString(cashBasedAccountingEnabled)).append("\n");
    sb.append("    charges: ").append(toIndentedString(charges)).append("\n");
    sb.append("    closeDate: ").append(toIndentedString(closeDate)).append("\n");
    sb.append("    creditAllocationRules: ").append(toIndentedString(creditAllocationRules)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    delinquencyBucket: ").append(toIndentedString(delinquencyBucket)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    disallowExpectedDisbursements: ").append(toIndentedString(disallowExpectedDisbursements)).append("\n");
    sb.append("    dueDaysForRepaymentEvent: ").append(toIndentedString(dueDaysForRepaymentEvent)).append("\n");
    sb.append("    enableInstallmentLevelDelinquency: ").append(toIndentedString(enableInstallmentLevelDelinquency)).append("\n");
    sb.append("    equalAmortization: ").append(toIndentedString(equalAmortization)).append("\n");
    sb.append("    externalId: ").append(toIndentedString(externalId)).append("\n");
    sb.append("    fixedPrincipalPercentagePerInstallment: ").append(toIndentedString(fixedPrincipalPercentagePerInstallment)).append("\n");
    sb.append("    floatingRates: ").append(toIndentedString(floatingRates)).append("\n");
    sb.append("    fund: ").append(toIndentedString(fund)).append("\n");
    sb.append("    holdGuaranteeFunds: ").append(toIndentedString(holdGuaranteeFunds)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    includeInBorrowerCycle: ").append(toIndentedString(includeInBorrowerCycle)).append("\n");
    sb.append("    interestPeriodFrequencyType: ").append(toIndentedString(interestPeriodFrequencyType)).append("\n");
    sb.append("    interestRecalculationEnabled: ").append(toIndentedString(interestRecalculationEnabled)).append("\n");
    sb.append("    linkedToFloatingInterestRate: ").append(toIndentedString(linkedToFloatingInterestRate)).append("\n");
    sb.append("    loanConfigurableAttributes: ").append(toIndentedString(loanConfigurableAttributes)).append("\n");
    sb.append("    loanProductGuaranteeDetails: ").append(toIndentedString(loanProductGuaranteeDetails)).append("\n");
    sb.append("    loanProductMinMaxConstraints: ").append(toIndentedString(loanProductMinMaxConstraints)).append("\n");
    sb.append("    loanProductRelatedDetail: ").append(toIndentedString(loanProductRelatedDetail)).append("\n");
    sb.append("    loanProductTrancheDetails: ").append(toIndentedString(loanProductTrancheDetails)).append("\n");
    sb.append("    maxNominalInterestRatePerPeriod: ").append(toIndentedString(maxNominalInterestRatePerPeriod)).append("\n");
    sb.append("    maxNumberOfRepayments: ").append(toIndentedString(maxNumberOfRepayments)).append("\n");
    sb.append("    maxPrincipalAmount: ").append(toIndentedString(maxPrincipalAmount)).append("\n");
    sb.append("    minNominalInterestRatePerPeriod: ").append(toIndentedString(minNominalInterestRatePerPeriod)).append("\n");
    sb.append("    minNumberOfRepayments: ").append(toIndentedString(minNumberOfRepayments)).append("\n");
    sb.append("    minPrincipalAmount: ").append(toIndentedString(minPrincipalAmount)).append("\n");
    sb.append("    minimumDaysBetweenDisbursalAndFirstRepayment: ").append(toIndentedString(minimumDaysBetweenDisbursalAndFirstRepayment)).append("\n");
    sb.append("    multiDisburseLoan: ").append(toIndentedString(multiDisburseLoan)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    _new: ").append(toIndentedString(_new)).append("\n");
    sb.append("    nominalInterestRatePerPeriod: ").append(toIndentedString(nominalInterestRatePerPeriod)).append("\n");
    sb.append("    numberOfRepayments: ").append(toIndentedString(numberOfRepayments)).append("\n");
    sb.append("    overAppliedCalculationType: ").append(toIndentedString(overAppliedCalculationType)).append("\n");
    sb.append("    overAppliedNumber: ").append(toIndentedString(overAppliedNumber)).append("\n");
    sb.append("    overDueDaysForRepaymentEvent: ").append(toIndentedString(overDueDaysForRepaymentEvent)).append("\n");
    sb.append("    overdueDaysForNPA: ").append(toIndentedString(overdueDaysForNPA)).append("\n");
    sb.append("    paymentAllocationRules: ").append(toIndentedString(paymentAllocationRules)).append("\n");
    sb.append("    periodicAccrualAccountingEnabled: ").append(toIndentedString(periodicAccrualAccountingEnabled)).append("\n");
    sb.append("    principalAmount: ").append(toIndentedString(principalAmount)).append("\n");
    sb.append("    principalThresholdForLastInstallment: ").append(toIndentedString(principalThresholdForLastInstallment)).append("\n");
    sb.append("    productInterestRecalculationDetails: ").append(toIndentedString(productInterestRecalculationDetails)).append("\n");
    sb.append("    rates: ").append(toIndentedString(rates)).append("\n");
    sb.append("    repaymentStartDateType: ").append(toIndentedString(repaymentStartDateType)).append("\n");
    sb.append("    shortName: ").append(toIndentedString(shortName)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    syncExpectedWithDisbursementDate: ").append(toIndentedString(syncExpectedWithDisbursementDate)).append("\n");
    sb.append("    transactionProcessingStrategyCode: ").append(toIndentedString(transactionProcessingStrategyCode)).append("\n");
    sb.append("    transactionProcessingStrategyName: ").append(toIndentedString(transactionProcessingStrategyName)).append("\n");
    sb.append("    upfrontAccrualAccountingEnabled: ").append(toIndentedString(upfrontAccrualAccountingEnabled)).append("\n");
    sb.append("    useBorrowerCycle: ").append(toIndentedString(useBorrowerCycle)).append("\n");
    sb.append("    variableInstallmentConfig: ").append(toIndentedString(variableInstallmentConfig)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

