/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.self.loanaccount.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.exception.UnrecognizedQueryParamException;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.client.exception.ClientNotFoundException;
import org.apache.fineract.portfolio.loanaccount.api.LoanChargesApiResource;
import org.apache.fineract.portfolio.loanaccount.api.LoanTransactionsApiResource;
import org.apache.fineract.portfolio.loanaccount.api.LoansApiResource;
import org.apache.fineract.portfolio.loanaccount.exception.LoanNotFoundException;
import org.apache.fineract.portfolio.loanaccount.exception.LoanTemplateTypeRequiredException;
import org.apache.fineract.portfolio.loanaccount.exception.NotSupportedLoanTemplateTypeException;
import org.apache.fineract.portfolio.loanaccount.guarantor.api.GuarantorsApiResource;
import org.apache.fineract.portfolio.loanaccount.guarantor.data.GuarantorData;
import org.apache.fineract.portfolio.self.client.service.AppuserClientMapperReadService;
import org.apache.fineract.portfolio.self.config.SelfServiceModuleIsEnabledCondition;
import org.apache.fineract.portfolio.self.loanaccount.api.SelfLoansApiResourceSwagger;
import org.apache.fineract.portfolio.self.loanaccount.data.SelfLoansDataValidator;
import org.apache.fineract.portfolio.self.loanaccount.service.AppuserLoansMapperReadService;
import org.apache.fineract.useradministration.domain.AppUser;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Path(value="/v1/self/loans")
@Component
@Tag(name="Self Loans", description="")
@Conditional(value={SelfServiceModuleIsEnabledCondition.class})
public class SelfLoansApiResource {
    private final PlatformSecurityContext context;
    private final LoansApiResource loansApiResource;
    private final LoanTransactionsApiResource loanTransactionsApiResource;
    private final LoanChargesApiResource loanChargesApiResource;
    private final AppuserLoansMapperReadService appuserLoansMapperReadService;
    private final AppuserClientMapperReadService appUserClientMapperReadService;
    private final SelfLoansDataValidator dataValidator;
    private final GuarantorsApiResource guarantorsApiResource;

    @GET
    @Path(value="{loanId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Loan", description="Retrieves a Loan\n\nExample Requests:\n\nself/loans/1\n\n\nself/loans/1?fields=id,principal,annualInterestRate\n\n\nself/loans/1?fields=id,principal,annualInterestRate&associations=repaymentSchedule,transactions")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SelfLoansApiResourceSwagger.GetSelfLoansLoanIdResponse.class))})})
    public String retrieveLoan(@PathParam(value="loanId") @Parameter(description="loanId") Long loanId, @Context UriInfo uriInfo) {
        this.dataValidator.validateRetrieveLoan(uriInfo);
        this.validateAppuserLoanMapping(loanId);
        boolean staffInSelectedOfficeOnly = false;
        String associations = "all";
        String exclude = null;
        String fields = null;
        return this.loansApiResource.retrieveLoan(loanId, false, "all", exclude, fields, uriInfo);
    }

    @GET
    @Path(value="{loanId}/transactions/{transactionId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Loan Transaction Details", description="Retrieves a Loan Transaction DetailsExample Request:\n\nself/loans/5/transactions/3")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SelfLoansApiResourceSwagger.GetSelfLoansLoanIdTransactionsTransactionIdResponse.class))})})
    public String retrieveTransaction(@PathParam(value="loanId") @Parameter(description="loanId") Long loanId, @PathParam(value="transactionId") @Parameter(description="transactionId") Long transactionId, @QueryParam(value="fields") @Parameter(in=ParameterIn.QUERY, name="fields", description="Optional Loan Transaction attribute list to be in the response", required=false, example="id,date,amount") String fields, @Context UriInfo uriInfo) {
        this.dataValidator.validateRetrieveTransaction(uriInfo);
        this.validateAppuserLoanMapping(loanId);
        return this.loanTransactionsApiResource.retrieveTransaction(loanId, transactionId, fields, uriInfo);
    }

    @GET
    @Path(value="{loanId}/charges")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Loan Charges", description="Lists loan Charges\n\nExample Requests:\n\nself/loans/1/charges\n\n\nself/loans/1/charges?fields=name,amountOrPercentage")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=SelfLoansApiResourceSwagger.GetSelfLoansLoanIdChargesResponse.class)))})})
    public String retrieveAllLoanCharges(@PathParam(value="loanId") @Parameter(description="loanId") Long loanId, @Context UriInfo uriInfo) {
        this.validateAppuserLoanMapping(loanId);
        return this.loanChargesApiResource.retrieveAllLoanCharges(loanId, uriInfo);
    }

    @GET
    @Path(value="{loanId}/charges/{chargeId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Loan Charge", description="Retrieves a Loan Charge\n\nExample Requests:\n\nself/loans/1/charges/1\n\n\nself/loans/1/charges/1?fields=name,amountOrPercentage")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SelfLoansApiResourceSwagger.GetSelfLoansLoanIdChargesResponse.class))})})
    public String retrieveLoanCharge(@PathParam(value="loanId") @Parameter(description="loanId") Long loanId, @PathParam(value="chargeId") @Parameter(description="chargeId") Long loanChargeId, @Context UriInfo uriInfo) {
        this.validateAppuserLoanMapping(loanId);
        return this.loanChargesApiResource.retrieveLoanCharge(loanId, loanChargeId, uriInfo);
    }

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Loan Details Template", description="Retrieves Loan Details Template\n\nThis is a convenience resource. It can be useful when building maintenance user interface screens for client applications. The template data returned consists of any or all of:\n\nField Defaults\nAllowed description Lists\n\nExample Requests:\n\nself/loans/template?templateType=individual&clientId=1\n\n\nself/loans/template?templateType=individual&clientId=1&productId=1")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SelfLoansApiResourceSwagger.GetSelfLoansTemplateResponse.class))})})
    public String template(@QueryParam(value="clientId") @Parameter(description="clientId") Long clientId, @QueryParam(value="productId") @Parameter(description="productId") Long productId, @QueryParam(value="templateType") @Parameter(description="templateType") String templateType, @Context UriInfo uriInfo) {
        if (clientId != null) {
            this.validateAppuserClientsMapping(clientId);
        }
        if (templateType == null) {
            String errorMsg = "Loan template type must be provided";
            throw new LoanTemplateTypeRequiredException("Loan template type must be provided");
        }
        if (!templateType.equalsIgnoreCase("individual") && !templateType.equalsIgnoreCase("collateral")) {
            String errorMsg = "Loan template type '" + templateType + "' is not supported";
            throw new NotSupportedLoanTemplateTypeException(errorMsg, new Object[]{templateType});
        }
        Long groupId = null;
        boolean staffInSelectedOfficeOnly = false;
        boolean onlyActive = true;
        return this.loansApiResource.template(clientId, groupId, productId, templateType, false, true, uriInfo);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Calculate Loan Repayment Schedule | Submit a new Loan Application", description="Calculate Loan Repayment Schedule:\n\nCalculates Loan Repayment Schedule\n\nMandatory Fields: productId, principal, loanTermFrequency, loanTermFrequencyType, numberOfRepayments, repaymentEvery, repaymentFrequencyType, interestRatePerPeriod, amortizationType, interestType, interestCalculationPeriodType, expectedDisbursementDate, transactionProcessingStrategyCode\n\nSubmit a new Loan Application:\n\nMandatory Fields: clientId, productId, principal, loanTermFrequency, loanTermFrequencyType, loanType, numberOfRepayments, repaymentEvery, repaymentFrequencyType, interestRatePerPeriod, amortizationType, interestType, interestCalculationPeriodType, transactionProcessingStrategyCode, expectedDisbursementDate, submittedOnDate, loanType\n\nAdditional Mandatory Fields if interest recalculation is enabled for product and Rest frequency not same as repayment period: recalculationRestFrequencyDate\n\nAdditional Mandatory Fields if interest recalculation with interest/fee compounding is enabled for product and compounding frequency not same as repayment period: recalculationCompoundingFrequencyDate\n\nAdditional Mandatory Field if Entity-Datatable Check is enabled for the entity of type loan: datatables\n\nOptional Fields: graceOnPrincipalPayment, graceOnInterestPayment, graceOnInterestCharged, linkAccountId, allowPartialPeriodInterestCalcualtion, fixedEmiAmount, maxOutstandingLoanBalance, disbursementData, graceOnArrearsAgeing, createStandingInstructionAtDisbursement (requires linkedAccountId if set to true)\n\nShowing request/response for 'Submit a new Loan Application'")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=SelfLoansApiResourceSwagger.PostSelfLoansRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SelfLoansApiResourceSwagger.PostSelfLoansResponse.class))})})
    public String calculateLoanScheduleOrSubmitLoanApplication(@QueryParam(value="command") @Parameter(description="command") String commandParam, @Context UriInfo uriInfo, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        HashMap attr = this.dataValidator.validateLoanApplication(apiRequestBodyAsJson);
        Long clientId = (Long)attr.get("clientId");
        this.validateAppuserClientsMapping(clientId);
        return this.loansApiResource.calculateLoanScheduleOrSubmitLoanApplication(commandParam, uriInfo, apiRequestBodyAsJson);
    }

    @PUT
    @Path(value="{loanId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a Loan Application", description="Loan application can only be modified when in 'Submitted and pending approval' state. Once the application is approved, the details cannot be changed using this method.")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=SelfLoansApiResourceSwagger.PutSelfLoansLoanIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SelfLoansApiResourceSwagger.PutSelfLoansLoanIdResponse.class))})})
    public String modifyLoanApplication(@PathParam(value="loanId") @Parameter(description="loanId") Long loanId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        HashMap attr = this.dataValidator.validateModifyLoanApplication(apiRequestBodyAsJson);
        this.validateAppuserLoanMapping(loanId);
        Long clientId = (Long)attr.get("clientId");
        if (clientId != null) {
            this.validateAppuserClientsMapping(clientId);
        }
        String command = null;
        return this.loansApiResource.modifyLoanApplication(loanId, command, apiRequestBodyAsJson);
    }

    @POST
    @Path(value="{loanId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Applicant Withdraws from Loan Application", description="Applicant Withdraws from Loan Application\n\nMandatory Fields: withdrawnOnDate")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=SelfLoansApiResourceSwagger.PostSelfLoansLoanIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SelfLoansApiResourceSwagger.PostSelfLoansLoanIdResponse.class))})})
    public String stateTransitions(@PathParam(value="loanId") @Parameter(description="loanId") Long loanId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        if (!this.is(commandParam, "withdrawnByApplicant")) {
            throw new UnrecognizedQueryParamException("command", commandParam, new Object[0]);
        }
        this.validateAppuserLoanMapping(loanId);
        return this.loansApiResource.stateTransitions(loanId, commandParam, apiRequestBodyAsJson);
    }

    private void validateAppuserLoanMapping(Long loanId) {
        AppUser user = this.context.authenticatedUser();
        boolean isLoanMappedToUser = this.appuserLoansMapperReadService.isLoanMappedToUser(loanId, (Long)user.getId());
        if (!isLoanMappedToUser) {
            throw new LoanNotFoundException(loanId);
        }
    }

    private void validateAppuserClientsMapping(Long clientId) {
        AppUser user = this.context.authenticatedUser();
        boolean mappedClientId = this.appUserClientMapperReadService.isClientMappedToUser(clientId, (Long)user.getId());
        if (!mappedClientId) {
            throw new ClientNotFoundException(clientId);
        }
    }

    private boolean is(String commandParam, String commandValue) {
        return StringUtils.isNotBlank((CharSequence)commandParam) && commandParam.trim().equalsIgnoreCase(commandValue);
    }

    @GET
    @Path(value="{loanId}/guarantors")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<GuarantorData> retrieveGuarantorDetails(@PathParam(value="loanId") Long loanId) {
        this.validateAppuserLoanMapping(loanId);
        return this.guarantorsApiResource.retrieveGuarantorDetails(loanId);
    }

    @Generated
    public SelfLoansApiResource(PlatformSecurityContext context, LoansApiResource loansApiResource, LoanTransactionsApiResource loanTransactionsApiResource, LoanChargesApiResource loanChargesApiResource, AppuserLoansMapperReadService appuserLoansMapperReadService, AppuserClientMapperReadService appUserClientMapperReadService, SelfLoansDataValidator dataValidator, GuarantorsApiResource guarantorsApiResource) {
        this.context = context;
        this.loansApiResource = loansApiResource;
        this.loanTransactionsApiResource = loanTransactionsApiResource;
        this.loanChargesApiResource = loanChargesApiResource;
        this.appuserLoansMapperReadService = appuserLoansMapperReadService;
        this.appUserClientMapperReadService = appUserClientMapperReadService;
        this.dataValidator = dataValidator;
        this.guarantorsApiResource = guarantorsApiResource;
    }
}

