/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.rate.service;

import jakarta.persistence.PersistenceException;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.rate.domain.Rate;
import org.apache.fineract.portfolio.rate.domain.RateRepository;
import org.apache.fineract.portfolio.rate.exception.RateNotFoundException;
import org.apache.fineract.portfolio.rate.serialization.RateDefinitionCommandFromApiJsonDeserializer;
import org.apache.fineract.portfolio.rate.service.RateWriteService;
import org.apache.fineract.useradministration.domain.AppUser;
import org.apache.fineract.useradministration.domain.AppUserRepository;
import org.apache.fineract.useradministration.exception.UserNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.transaction.annotation.Transactional;

public class RateWriteServiceImpl
implements RateWriteService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RateWriteServiceImpl.class);
    private final RateRepository rateRepository;
    private final AppUserRepository appUserRepository;
    private final PlatformSecurityContext context;
    private final RateDefinitionCommandFromApiJsonDeserializer fromApiJsonDeserializer;

    public CommandProcessingResult createRate(JsonCommand command) {
        try {
            this.context.authenticatedUser();
            this.fromApiJsonDeserializer.validateForCreate(command.json());
            Long approveUserId = command.longValueOfParameterNamed("approveUserId");
            AppUser approveUser = null;
            if (approveUserId != null) {
                approveUser = (AppUser)this.appUserRepository.findById((Object)approveUserId).orElseThrow(() -> new UserNotFoundException(approveUserId));
            }
            Rate rate = Rate.fromJson((JsonCommand)command, approveUser);
            this.rateRepository.saveAndFlush((Object)rate);
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)rate.getId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleRateDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleRateDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    public CommandProcessingResult updateRate(Long rateId, JsonCommand command) {
        try {
            this.context.authenticatedUser();
            Rate rateToUpdate = (Rate)this.rateRepository.findById((Object)rateId).orElseThrow(() -> new RateNotFoundException(rateId));
            Map changes = rateToUpdate.update(command);
            this.fromApiJsonDeserializer.validateForUpdate(command.json());
            if (changes.containsKey("approveUserId")) {
                Long newApproveUserId = (Long)changes.get("approveUserId");
                AppUser newApproveUser = null;
                if (newApproveUserId != null) {
                    newApproveUser = (AppUser)this.appUserRepository.findById((Object)newApproveUserId).orElseThrow(() -> new UserNotFoundException(newApproveUserId));
                }
                rateToUpdate.setApproveUser(newApproveUser);
            }
            if (!changes.isEmpty()) {
                this.rateRepository.saveAndFlush((Object)rateToUpdate);
            }
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(rateId).with(changes).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleRateDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.resourceResult((Long)-1L);
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleRateDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    private void handleRateDataIntegrityIssues(JsonCommand command, Throwable realCause, Exception dve) {
        if (realCause.getMessage().contains("rate_name_org")) {
            String name = command.stringValueOfParameterNamed("name");
            throw new PlatformDataIntegrityException("error.msg.fund.duplicate.externalId", "A rate with name '" + name + "' already exists", "name", new Object[]{name});
        }
        log.error("Error due to Exception", (Throwable)dve);
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.fund.unknown.data.integrity.issue", (String)("Unknown data integrity issue with resource: " + realCause.getMessage()));
    }

    @Generated
    public RateWriteServiceImpl(RateRepository rateRepository, AppUserRepository appUserRepository, PlatformSecurityContext context, RateDefinitionCommandFromApiJsonDeserializer fromApiJsonDeserializer) {
        this.rateRepository = rateRepository;
        this.appUserRepository = appUserRepository;
        this.context = context;
        this.fromApiJsonDeserializer = fromApiJsonDeserializer;
    }
}

